@extends('layouts.app')
@section('content')
<div class="container">
    <h2>Danh sách bảng đấu - {{ $tournament->name }}</h2>
    <a href="{{ route('admin.groups.create', $tournament) }}" class="btn btn-success mb-3">Thêm bảng đấu</a>
    <table class="table">
        <thead>
            <tr>
                <th>ID</th>
                <th>Tên bảng</th>
                <th>Hành động</th>
            </tr>
        </thead>
        <tbody>
            @foreach($groups as $group)
            <tr>
                <td>{{ $group->id }}</td>
                <td>{{ $group->name }}</td>
                <td>
                    <a href="{{ route('admin.groups.edit', [$tournament, $group]) }}"
                        class="btn btn-sm btn-primary">Sửa</a>
                    <form action="{{ route('admin.groups.destroy', [$tournament, $group]) }}" method="POST"
                        style="display:inline-block;">
                        @csrf @method('DELETE')
                        <button type="submit" class="btn btn-sm btn-danger"
                            onclick="return confirm('Bạn có chắc muốn xóa?')">Xóa</button>
                    </form>
                    <a href="{{ route('admin.pairs.index', $group) }}" class="btn btn-sm btn-info">Cặp đấu</a>
                </td>
            </tr>
            @endforeach
        </tbody>
    </table>
</div>
@endsection