<?php

declare(strict_types=1);

return [
    'account' => [
        'connect_password' => '代理连接密码',
        'credit' => '账户余额',
        'group' => '所属分组',
        'last_login' => '最近登录',
        'level' => '账号等级',
        'reason' => [
            'expired' => '账号套餐已过期',
            'normal' => '账号一切正常',
            'overused' => '本时段使用流量超过 <code>:data</code> GB，触发限制<br/> <code id="banedTime">:min</code> 后解除',
            'traffic_exhausted' => '套餐流量已用完',
            'unknown' => '未知原因，请刷新浏览器后重试。如问题持续，请联系客服',
        ],
        'remain' => '剩余流量',
        'reset' => '{0} 还有 <code id="restTime">:days</code> 重置流量|[1,*] 还有 :days 天重置流量',
        'speed_limit' => '限速',
        'status' => '账号状态',
        'time' => '套餐有效期',
    ],
    'attribute' => [
        'address' => '地区',
        'data' => '流量',
        'ip' => 'IP地址',
        'isp' => '运营商',
        'node' => '线路',
    ],
    'bought_at' => '购买日期',
    'clients' => '客户端',
    'contact' => '联系方式',
    'coupon' => [
        'discount' => '优惠',
        'error' => [
            'expired' => '优惠券已过期',
            'inactive' => '优惠券尚未生效',
            'minimum' => '本券最低使用金额为 :amount',
            'overused' => '本券只能使用 :times 次',
            'run_out' => '优惠券已用完',
            'services' => '商品不符合折扣条件，请查看促销条款',
            'unknown' => '无效优惠券',
            'unmet' => '不满足使用条件',
            'used' => '优惠券已被使用',
            'users' => '账户不符合促销条件',
            'wait' => '活动将于 :time 生效，请耐心等待！',
        ],
        'input' => '请输入充值券码',
    ],
    'current_role' => '当前身份',
    'error_response' => '出现了错误，请稍后再试。',
    'home' => [
        'announcement' => '公告',
        'attendance' => [
            'attribute' => '签到',
            'disable' => '系统未开启签到功能',
            'done' => '今天已经签到过了，请明天再试！',
            'failed' => '系统❌异常',
            'success' => '签到成功，获得 :data',
        ],
        'chat_group' => '聊天群组',
        'empty_announcement' => '暂无公告',
        'traffic_logs' => '流量记录',
        'wechat_push' => '微信推送',
    ],
    'invite' => [
        'attribute' => '邀请码',
        'counts' => '共计 <code>:num</code> 枚邀请码',
        'generate_failed' => '生成失败：已无邀请码生成名额',
        'logs' => '邀请记录',
        'promotion' => '通过您的邀请码注册并激活，您和受邀用户将获得 <mark>:traffic</mark> 流量奖励；当他们消费时，您将获得他们消费金额的 <mark>:referral_percent%</mark> 作为奖励。',
        'tips' => '剩余 <strong>:num</strong> 枚可用邀请名额，邀请码创建后 :days 天内有效',
    ],
    'invitee' => '受邀者',
    'inviter' => '邀请者',
    'invoice' => [
        'active_prepaid_question' => '是否提前启用预付套餐？',
        'active_prepaid_tips' => '启用后：<br>现有账号套餐将失效<br>账号过期日期将重新计算',
        'amount' => '金额',
        'attribute' => '订单',
        'detail' => '消费记录',
    ],
    'knowledge' => [
        'basic' => '基础',
        'title' => '知识库',
    ],
    'menu' => [
        'admin_dashboard' => '管理',
        'help' => '帮助',
        'home' => '主页',
        'invites' => '邀请',
        'invoices' => '账单',
        'nodes' => '线路',
        'profile' => '设置',
        'promotion' => '推广',
        'shop' => '服务',
        'tickets' => '工单',
    ],
    'node' => [
        'info' => '配置信息',
        'rate' => ':ratio 倍流量消耗',
        'setting' => '代理设置',
        'unstable' => '线路波动中/维护中',
    ],
    'oauth' => [
        'bind' => '绑定',
        'bind_title' => '绑定社交账号',
        'not_bind' => '尚未绑定',
        'rebind' => '重新绑定',
        'unbind' => '解绑',
    ],
    'pay' => '支付',
    'payment' => [
        'close_tips' => '请在 <code>:minutes</code> 分钟内完成支付，否则订单将被取消',
        'creating' => '正在创建支付订单...',
        'error' => '充值金额不合法',
        'insufficient_balance' => '您的余额不足，请先充值',
        'manual' => [
            'hint' => '扫码支付后，请按顺序点击【下一步】，直到点击【提交】完成支付',
            'next' => '下一步',
            'payment_tips' => '支付时，请充值对应金额（多不退，少需补）',
            'pre' => '上一步',
            'red_packet' => '支付宝领红包',
            'steps' => [
                'complete' => [
                    'description' => '等待支付人工核对',
                    'title' => '完成',
                ],
                'notice' => [
                    'description' => '如何正确人工支付',
                    'title' => '须知',
                ],
                'payment' => [
                    'description' => '获取支付二维码，进行支付',
                    'title' => '支付',
                ],
                'remark' => [
                    'description' => '填写登录账号，以便人工核对',
                    'title' => '备注账号',
                ],
            ],
        ],
        'method' => '支付方式',
        'mobile_tips' => '<strong>手机用户</strong>：长按二维码 -> 保存图片 -> 打开支付应用 -> 扫一扫 -> 选择相册 -> 选择图片付款',
        'order_creation' => [
            'failed' => '创建订单失败，请尝试其他支付方式！',
            'info' => '我们将在【24小时】内对购买/充值的款项进行开通！请耐心等待',
            'order_limit' => '此商品限购 :limit_num 次，您已购买 :count 次',
            'order_timeout' => '订单超时未支付，已自动关闭',
            'payment_disabled' => '订单创建失败：系统未开启在线支付功能',
            'pending_order' => '订单创建失败：尚有未支付的订单，请先完成支付',
            'plan_required' => '购买加油包前，请先购买套餐',
            'price_issue' => '订单创建失败：订单总价异常',
            'price_zero' => '订单创建失败：订单总价为0，无需使用在线支付',
            'product_unavailable' => '订单创建失败：商品已下架',
            'success' => '创建订单成功！',
            'unknown_order' => '未知订单',
            'unknown_payment' => '未知支付方式',
        ],
        'qrcode_tips' => '请使用 <strong class="red-600">:software</strong> 扫描此二维码',
        'redirect_stripe' => '跳转至 Stripe 支付界面',
    ],
    'purchase' => [
        'completed' => '购买完成！',
        'promotion' => '快来购买服务吧！',
        'required' => '此功能仅限付费用户，请先',
        'to_unlock' => '购买服务解锁',
    ],
    'recharge' => '充值',
    'recharge_credit' => '余额充值',
    'recharging' => '充值中...',
    'referral' => [
        'link' => '推广链接',
        'logs' => '佣金记录',
        'msg' => [
            'account' => '账号已过期，请先购买服务',
            'applied' => '已有申请，请等待之前的申请处理完',
            'error' => '返利单建立失败，请稍后尝试或联系管理员',
            'unfulfilled' => '满 :amount 才可提现，请继续努力',
            'wait' => '请等待管理员审核',
        ],
        'total' => '合计返利 :amount（:total 次），满 :money 可提现。',
    ],
    'registered_at' => '注册时间',
    'reset_data' => [
        'action' => '重置流量',
        'cost' => '需要 <code>:amount</code>',
        'cost_tips' => '本次重置流量将扣除余额 :amount！',
    ],
    'scan_qrcode' => '请使用客户端扫描二维码',
    'service' => [
        'country_count' => '覆盖 <code>:num</code> 个国家或地区',
        'node_count' => '<code>:num</code> 条优质线路',
        'unlimited' => '不限速',
    ],
    'shop' => [
        'buy' => '购买',
        'call4help' => '如有疑问请开工单联系客服',
        'change_amount' => '充值金额',
        'change_amount_help' => '请输入充值金额',
        'conflict' => '套餐冲突',
        'conflict_tips' => '<p>当前购买套餐将设置为 <code>预付套餐</code></p><ol class="text-left"><li>预付套餐将在当前套餐失效后自动生效</li><li>您也可以在支付后在订单页面手动激活预付套餐</li></ol>',
        'description' => '描述',
        'hot' => '热销',
        'limited' => '限购',
        'pay_credit' => '余额支付',
        'pay_online' => '在线支付',
        'price' => '价格',
        'quantity' => '数量',
        'service' => '服务',
        'subtotal' => '小计',
        'total' => '合计',
    ],
    'subscribe' => [
        'custom' => '自定义订阅',
        'error' => '更换订阅地址失败',
        'exchange_warning' => '更换订阅地址将导致:\n1.旧地址立即失效\n2.连接密码被更改',
        'info' => [
            'download' => '已用下行',
            'title' => '账户摘要 [非实时]',
            'total' => '套餐流量',
            'upload' => '已用上行',
        ],
        'link' => '订阅链接',
        'ss_only' => '只订阅SS',
        'ssr_only' => '只订阅SSR（包含SS）',
        'tips' => '警告：该订阅链接仅限个人使用，请勿传播，否则将导致账号流量异常并触发封号机制。',
        'trojan_only' => '只订阅Trojan',
        'v2ray_only' => '只订阅V2Ray',
    ],
    'telegram' => [
        'bind_exists' => '该账号已经绑定了Telegram账号',
        'bind_missing' => '没有查询到您的用户信息，请先绑定账号',
        'command' => [
            'bind' => '绑定你的:web_name账号',
            'intro' => '你可以使用以下指令',
            'traffic' => '查询流量信息',
            'unbind' => '解除绑定',
            'web_url' => '获取最新:web_name网址',
        ],
        'get_url' => ':web_name的最新网址是',
        'params_missing' => '参数有误，请携带邮箱地址发送',
        'ticket_missing' => '工单不存在',
        'ticket_reply' => '#`:id` 工单回复成功',
        'traffic_query' => '流量查询',
        'user_missing' => '用户不存在',
    ],
    'ticket' => [
        'attribute' => '工单',
        'close_msg' => '工单：ID:id 用户已手动关闭',
        'close_tips' => '确定要关闭该工单吗？',
        'content_placeholder' => '请详细描述您的问题或需要帮助的地方，以便我们快速解决',
        'error' => '出现未知错误，请联系客服处理',
        'new' => '创建新工单',
        'online_hour' => '在线时间',
        'reply' => '回复',
        'reply_confirm' => '确定回复工单吗？',
        'reply_placeholder' => '说点什么吧？',
        'service_hours' => '客服工作时间',
        'service_tips' => '本站有多种联系方式，请使用其中 <code>一种</code> 联系客服！<br>重复请求会影响客服处理。',
        'submit_tips' => '确定提交工单吗？',
        'title_placeholder' => '请简单描述您的问题类型或涉及的内容',
    ],
    'traffic_logs' => [
        'daily' => '本月流量使用情况',
        'hourly' => '今日流量使用情况',
        'tips' => '提示：流量统计更新有一定延迟。',
    ],
    'tutorials' => '教程',
    'withdraw' => '提现',
    'withdraw_at' => '提现日期',
    'withdraw_commission' => '提取佣金',
    'withdraw_logs' => '提现记录',
];