<?php

declare(strict_types=1);

return [
    'action' => [
        'add_item' => 'Thêm :attribute',
        'edit_item' => 'Chỉnh sửa :attribute',
    ],
    'aff' => [
        'apply_counts' => 'Tổng cộng có <code>:num</code> yêu cầu rút tiền',
        'commission_counts' => 'Yêu cầu này liên quan đến tổng cộng <code>:num</code> đơn hàng',
        'commission_title' => 'Chi tiết yêu cầu rút tiền',
        'counts' => 'Tổng cộng có <code>:num</code> bản ghi hoàn tiền',
        'rebate_title' => 'Lịch sử hoàn tiền',
        'referral' => 'Hoàn tiền giới thiệu',
        'title' => 'Danh sách yêu cầu rút tiền',
    ],
    'article' => [
        'category_hint' => 'Cùng một danh mục sẽ được nhóm vào cùng một thư mục',
        'counts' => 'Tổng cộng có <code>:num</code> bài viết',
        'logo_placeholder' => 'Hoặc nhập URL logo',
        'title' => 'Danh sách bài viết',
        'type' => [
            'announcement' => 'Thông báo',
            'knowledge' => 'Bài viết',
        ],
    ],
    'clear' => 'Xóa',
    'clone' => 'Nhân bản',
    'confirm' => [
        'continues' => 'Bạn có chắc chắn muốn tiếp tục hành động này không?',
        'delete' => [0 => 'Bạn có chắc chắn muốn xóa :attribute', 1 => ']?'],
        'export' => 'Bạn có chắc chắn muốn xuất toàn bộ?',
    ],
    'coupon' => [
        'counts' => 'Tổng cộng có <code>:num</code> phiếu giảm giá',
        'created_days_hint' => '<code>:days</code> ngày sau khi đăng ký',
        'discount' => 'Giảm giá',
        'export_title' => 'Xuất phiếu giảm giá',
        'groups_hint' => 'Chỉ có thể sử dụng cho các nhóm người dùng đã chọn',
        'info_title' => 'Thông tin phiếu giảm giá',
        'levels_hint' => 'Chỉ có thể sử dụng cho các cấp độ người dùng đã chọn',
        'limit_hint' => 'Các điều kiện này có quan hệ <strong>VÀ</strong>, vui lòng sử dụng đúng cách',
        'minimum_hint' => 'Chỉ có thể sử dụng khi số tiền thanh toán vượt quá <strong>:num</strong>',
        'name_hint' => 'Sẽ hiển thị trên giao diện người dùng',
        'newbie' => [
            'created_days' => 'Ngày tạo tài khoản',
            'first_discount' => 'Giảm giá lần đầu',
            'first_order' => 'Đơn hàng đầu tiên',
        ],
        'priority_hint' => 'Mã phiếu giảm giá có ưu tiên cao nhất sẽ được sử dụng trước. Tối đa là 255',
        'services_blacklist_hint' => 'Không thể sử dụng cho các sản phẩm trong danh sách đen, để trống nếu không sử dụng điều kiện này',
        'services_placeholder' => 'Nhập ID sản phẩm, sau đó nhấn Enter',
        'services_whitelist_hint' => 'Chỉ có thể sử dụng cho các sản phẩm trong danh sách trắng, để trống nếu không sử dụng điều kiện này',
        'single_use' => 'Sử dụng một lần',
        'sn_hint' => 'Cung cấp mã phiếu giảm giá cho người dùng, để trống sẽ mặc định là mã ngẫu nhiên 8 ký tự',
        'title' => 'Danh sách phiếu giảm giá',
        'type' => [
            'charge' => 'Phiếu nạp tiền',
            'discount' => 'Phiếu giảm giá',
            'voucher' => 'Phiếu mua hàng',
        ],
        'type_hint' => 'Giảm giá: giảm số tiền sản phẩm, Giảm phần trăm: giảm giá theo phần trăm sản phẩm, Nạp tiền: nạp tiền vào tài khoản người dùng',
        'used_hint' => 'Mỗi người dùng có thể sử dụng tối đa <strong>:num</strong> lần',
        'user_whitelist_hint' => 'Người dùng trong danh sách trắng có thể sử dụng, để trống nếu không sử dụng điều kiện này',
        'users_blacklist_hint' => 'Người dùng trong danh sách đen không thể sử dụng, để trống nếu không sử dụng điều kiện này',
        'users_placeholder' => 'Nhập ID người dùng, sau đó nhấn Enter',
        'value' => '{1} ➖ :num|{2} :num% giảm giá|{3} ➕ :num',
        'value_hint' => 'Phạm vi từ 1% đến 99%',
    ],
    'creating' => 'Đang thêm...',
    'dashboard' => [
        'abnormal_users' => 'Người dùng có lưu lượng bất thường trong 1 giờ qua',
        'active_days_users' => 'Người dùng hoạt động trong :days ngày qua',
        'available_users' => 'Người dùng hoạt động',
        'credit' => 'Tổng số dư',
        'current_month_traffic_consumed' => 'Lưu lượng tiêu thụ trong tháng này',
        'days_traffic_consumed' => 'Lưu lượng tiêu thụ trong :days ngày qua',
        'expiring_users' => 'Người dùng sắp hết hạn',
        'inactive_days_users' => 'Người dùng không hoạt động hơn :days ngày',
        'maintaining_nodes' => 'Nút đang bảo trì',
        'nodes' => 'Số nút',
        'online_orders' => 'Đơn hàng thanh toán trực tuyến',
        'online_users' => 'Người dùng trực tuyến',
        'orders' => 'Tổng số đơn hàng',
        'overuse_users' => 'Người dùng sử dụng dữ liệu vượt quá 90%',
        'paid_users' => 'Người dùng trả phí',
        'succeed_orders' => 'Đơn hàng thanh toán thành công',
        'users' => 'Tổng số người dùng',
        'withdrawing_commissions' => 'Hoa hồng đang chờ rút',
        'withdrawn_commissions' => 'Hoa hồng đã rút',
    ],
    'end_time' => 'Thời gian kết thúc',
    'goods' => [
        'counts' => 'Tổng cộng <code>:num</code> sản phẩm',
        'info' => [
            'available_date_hint' => 'Tự động trừ dữ liệu từ tổng khi đến hạn',
            'desc_placeholder' => 'Mô tả ngắn gọn sản phẩm',
            'limit_num_hint' => 'Số lần mua tối đa mỗi người dùng, 0 là không giới hạn',
            'list_hint' => 'Bắt đầu mỗi dòng bằng <code>&lt;li&gt;</code> và kết thúc bằng <code>&lt;/li&gt;</code>',
            'list_placeholder' => 'Thêm nội dung tùy chỉnh',
            'period_hint' => 'Dữ liệu gói sẽ được đặt lại mỗi N ngày',
            'type_hint' => 'Gói đăng ký ảnh hưởng đến thời hạn tài khoản, gói dữ liệu chỉ trừ dữ liệu, không ảnh hưởng đến thời hạn',
        ],
        'sell_and_used' => 'Đã sử dụng / Đã bán',
        'status' => [
            'no' => 'Ngừng bán',
            'yes' => 'Đang bán',
        ],
        'title' => 'Danh sách sản phẩm',
        'type' => [
            'package' => 'Gói dữ liệu',
            'plan' => 'Gói đăng ký',
            'top_up' => 'Nạp tiền',
        ],
    ],
    'hint' => 'Gợi ý',
    'logs' => [
        'ban' => [
            'ban_time' => 'Thời gian cấm',
            'last_connect_at' => 'Thời gian kết nối cuối cùng',
            'reason' => 'Lý do',
            'time' => 'Thời gian',
            'title' => 'Hồ sơ cấm người dùng',
        ],
        'callback' => 'Nhật ký hồi đáp <small>(Thanh toán)</small>',
        'counts' => 'Tổng cộng <code>:num</code> bản ghi',
        'credit_title' => 'Hồ sơ thay đổi số dư',
        'ip_monitor' => 'Giám sát IP trực tuyến <small>Dữ liệu thời gian thực trong 2 phút</small>',
        'notification' => 'Nhật ký email',
        'order' => [
            'is_coupon' => 'Sử dụng mã giảm giá',
            'is_expired' => 'Hết hạn',
            'title' => 'Danh sách đơn hàng',
            'update_conflict' => 'Cập nhật thất bại: Xung đột đơn hàng',
        ],
        'rule' => [
            'clear_all' => 'Xóa tất cả các bản ghi',
            'clear_confirm' => 'Bạn có muốn xóa tất cả các hồ sơ kích hoạt không?',
            'created_at' => 'Thời gian kích hoạt',
            'name' => 'Tên quy tắc kích hoạt',
            'reason' => 'Lý do kích hoạt',
            'tag' => '✅ Truy cập nội dung không được phép',
            'title' => 'Hồ sơ kích hoạt quy tắc',
        ],
        'subscribe' => 'Danh sách đăng ký',
        'user_data_modify_title' => 'Hồ sơ thay đổi dữ liệu',
        'user_ip' => [
            'connect' => 'Kết nối IP',
            'title' => 'Danh sách IP trực tuyến <small>10 phút gần đây</small>',
        ],
        'user_traffic' => [
            'choose_node' => 'Chọn nút',
            'title' => 'Hồ sơ sử dụng dữ liệu',
        ],
    ],
    'marketing' => [
        'counts' => 'Tổng cộng có <code>:num</code> email',
        'email' => [
            'ever_paid' => 'Đã thanh toán',
            'expired_date' => 'Ngày hết hạn',
            'filters' => 'Bộ lọc',
            'loading_statistics' => 'Đang tải thống kê...',
            'never_paid' => 'Chưa thanh toán',
            'paid_servicing' => 'Dịch vụ trả phí',
            'previously_paid' => 'Đã từng thanh toán',
            'recent_traffic_abnormal' => 'Lưu lượng bất thường trong giờ qua',
            'recently_active' => 'Hoạt động gần đây',
            'targeted_users_count' => 'Số lượng người dùng mục tiêu',
            'traffic_usage_over' => 'Sử dụng lưu lượng vượt quá N%',
            'will_expire_date' => '',
        ],
        'email_send' => 'Gửi email nhóm',
        'error_message' => 'Thông báo lỗi',
        'processed' => 'Yêu cầu đã được xử lý',
        'push_send' => 'Gửi thông báo',
        'send_status' => 'Trạng thái gửi',
        'send_time' => 'Thời gian gửi',
        'targeted_users_not_found' => 'Không tìm thấy người dùng mục tiêu',
        'unknown_sending_type' => 'Loại gửi không xác định',
    ],
    'massive_export' => 'Xuất hàng loạt',
    'menu' => [
        'analysis' => [
            'accounting' => 'Sổ kế toán',
            'attribute' => 'Phân tích dữ liệu',
            'node_flow' => 'Phân tích lưu lượng của nút',
            'site_flow' => 'Lưu lượng trang web',
            'user_flow' => 'Lưu lượng người dùng',
        ],
        'customer_service' => [
            'article' => 'Quản lý bài viết',
            'attribute' => 'Dịch vụ khách hàng',
            'marketing' => 'Phát sóng tin nhắn',
            'ticket' => 'Yêu cầu hỗ trợ',
        ],
        'dashboard' => 'Bảng điều khiển',
        'log' => [
            'attribute' => 'Hệ thống nhật ký',
            'notify' => 'Hồ sơ thông báo',
            'online_logs' => 'Nhật ký trực tuyến',
            'online_monitor' => 'Giám sát trực tuyến',
            'payment_callback' => 'Hồi đáp thanh toán',
            'service_ban' => 'Hồ sơ cấm',
            'system' => 'Nhật ký hệ thống',
            'traffic' => 'Sử dụng lưu lượng',
            'traffic_flow' => 'Thay đổi lưu lượng',
        ],
        'node' => [
            'attribute' => 'Hệ thống nút',
            'auth' => 'Ủy quyền nút',
            'cert' => 'Danh sách chứng chỉ',
            'list' => 'Quản lý nút',
        ],
        'promotion' => [
            'attribute' => 'Khuyến mãi',
            'invite' => 'Quản lý lời mời',
            'rebate_flow' => 'Lịch sử hoàn tiền',
            'withdraw' => 'Quản lý rút tiền',
        ],
        'rbac' => [
            'attribute' => 'RBAC',
            'permission' => 'Quyền hạn',
            'role' => 'Vai trò',
        ],
        'rule' => [
            'attribute' => 'Quy tắc kiểm toán',
            'group' => 'Nhóm quy tắc',
            'list' => 'Danh sách quy tắc',
            'trigger' => 'Hồ sơ kích hoạt',
        ],
        'setting' => [
            'attribute' => 'Cài đặt hệ thống',
            'email_suffix' => 'Quản lý hậu tố email',
            'system' => 'Tham số hệ thống',
            'universal' => 'Cài đặt chung',
        ],
        'shop' => [
            'attribute' => 'Hệ thống sản phẩm',
            'coupon' => 'Quản lý mã giảm giá',
            'goods' => 'Quản lý sản phẩm',
            'order' => 'Đơn hàng sản phẩm',
        ],
        'tools' => [
            'analysis' => 'Phân tích nhật ký',
            'attribute' => 'Bộ công cụ',
            'convert' => 'Chuyển đổi định dạng',
            'decompile' => 'Giải mã',
            'import' => 'Nhập dữ liệu',
        ],
        'user' => [
            'attribute' => 'Người dùng',
            'credit_log' => 'Lịch sử số dư',
            'group' => 'Nhóm người dùng',
            'list' => 'Quản lý người dùng',
            'oauth' => 'OAuth',
            'subscribe' => 'Quản lý đăng ký',
        ],
    ],
    'minute' => 'phút',
    'monitor' => [
        'daily_chart' => 'Biểu đồ lưu lượng hàng ngày',
        'hint' => '<strong>Gợi ý:</strong> Nếu không có dữ liệu, hãy kiểm tra các tác vụ theo lịch trình',
        'monthly_chart' => 'Biểu đồ lưu lượng hàng tháng',
        'node' => 'Lưu lượng nút',
        'user' => 'Lưu lượng người dùng',
    ],
    'no' => 'Không',
    'node' => [
        'auth' => [
            'counts' => 'Tổng cộng <code>:num</code> bản ghi ủy quyền',
            'deploy' => [
                'attribute' => 'Triển khai Backend',
                'command' => 'Lệnh',
                'real_time_logs' => 'Nhật ký thời gian thực',
                'recent_logs' => 'Nhật ký gần đây',
                'restart' => 'Khởi động lại',
                'same' => 'Giống trên',
                'start' => 'Khởi động',
                'status' => 'Trạng thái',
                'stop' => 'Dừng',
                'title' => 'Triển khai Backend :type_label',
                'trojan_hint' => 'Vui lòng điền tên nút <a href=":url" target="_blank">và phân giải đến IP tương ứng</a>',
                'uninstall' => 'Gỡ cài đặt',
                'update' => 'Cập nhật',
            ],
            'empty' => 'Không có nút nào cần tạo quyền ủy quyền',
            'generating_all' => 'Xác nhận tạo khóa ủy quyền cho tất cả các nút?',
            'reset_auth' => 'Đặt lại khóa ủy quyền',
            'title' => 'Danh sách ủy quyền nút <small>WEBAPI</small>',
        ],
        'cert' => [
            'counts' => 'Tổng cộng <code>:num</code> chứng chỉ tên miền',
            'key_placeholder' => 'Giá trị KEY của chứng chỉ, có thể để trống. Backend VNET-V2Ray hỗ trợ cấp phát tự động',
            'pem_placeholder' => 'Giá trị PEM của chứng chỉ, có thể để trống. Backend VNET-V2Ray hỗ trợ cấp phát tự động',
            'title' => 'Danh sách chứng chỉ tên miền <small>(Đối với ngụy trang tên miền của nút V2Ray)</small>',
        ],
        'connection_test' => 'Kiểm tra kết nối',
        'counts' => 'Tổng cộng <code>:num</code> nút',
        'info' => [
            'additional_ports_hint' => 'Nếu bật, vui lòng cấu hình <span class="red-700"><a href="javascript:showTnc();">additional_ports</a></span> của máy chủ',
            'basic' => 'Thông tin cơ bản',
            'data_rate_hint' => 'Ví dụ: 0.1 có nghĩa là 100M sẽ được tính là 10M; 5 có nghĩa là 100M sẽ được tính là 500M',
            'ddns_hint' => 'Các nút IP động yêu cầu <a href="https://github.com/NewFuture/DDNS" target="_blank">cấu hình DDNS</a>. Đối với loại nút này, Kiểm tra kết nối sẽ được thực hiện qua tên miền.',
            'detection' => [
                'all' => 'Cả hai',
                'hint' => 'Kiểm tra ngẫu nhiên mỗi 30-60 phút',
                'icmp' => 'Chỉ ICMP',
                'tcp' => 'Chỉ TCP',
            ],
            'display' => [
                'all' => 'Hiển thị hoàn toàn',
                'hint' => 'Người dùng có thể xem/đăng ký nút này hay không',
                'invisible' => 'Không hiển thị',
                'node' => 'Chỉ hiển thị trong Trang Nút',
                'sub' => 'Chỉ hiển thị trong Đăng ký',
            ],
            'domain_hint' => 'Sau khi bật DDNS trong cài đặt hệ thống, tên miền và các IP sẽ tự động cập nhật! Bạn không cần chỉnh sửa thông tin này tại trang web đăng ký tên miền.',
            'domain_placeholder' => 'Tên miền máy chủ, sẽ sử dụng trước nếu điền',
            'extend' => 'Thông tin mở rộng',
            'hint' => '<strong>Lưu ý:</strong> <code>ID</code> tự động tạo là <code>node_id</code> cho backend ShadowsocksR và <code>nodeId</code> cho backend V2Ray',
            'ipv4_hint' => 'Nhiều IP nên được phân cách bằng dấu phẩy, ví dụ: 1.1.1.1,8.8.8.8',
            'ipv4_placeholder' => 'Địa chỉ IPv4 của máy chủ',
            'ipv6_hint' => 'Nhiều IP nên được phân cách bằng dấu phẩy, ví dụ: 1.1.1.1,8.8.8.8',
            'ipv6_placeholder' => 'Địa chỉ IPv6 của máy chủ',
            'level_hint' => 'Cấp độ: 0 - Không giới hạn cấp độ, tất cả đều có thể xem.',
            'obfs_param_hint' => 'Điền vào tham số để ngụy trang lưu lượng nếu obfs không phải là [plain]; &#13;&#10;Đề xuất cổng 80 nếu obfs là [http_simple]; &#13;&#10;Đề xuất cổng 443 nếu obfs là [tls];',
            'push_port_hint' => 'Bắt buộc. Đảm bảo rằng cổng này đã được mở trong tường lửa của máy chủ, nếu không thông báo đẩy sẽ bị lỗi.',
            'single_hint' => 'Đề xuất cổng 80/443. Backend cần <br> cấu hình chế độ nghiêm ngặt: chỉ kết nối qua các cổng được chỉ định. (<a href="javascript:showPortsOnlyConfig();">Cách cấu hình</a>)',
            'v2_cover' => [
                'dtls' => 'DTLS 1.2',
                'http' => 'HTTP',
                'none' => 'Không ngụy trang',
                'srtp' => 'SRTP',
                'utp' => 'uTP',
                'wechat' => 'Video WeChat',
                'wireguard' => 'WireGuard',
            ],
            'v2_host_hint' => 'Khi sử dụng ngụy trang HTTP, nhiều tên miền nên được phân cách bằng dấu phẩy, trong khi WebSocket chỉ cho phép một tên miền.',
            'v2_method_hint' => 'Giao thức truyền tải WebSocket không nên sử dụng phương pháp mã hóa \'none\'.',
            'v2_net_hint' => 'Vui lòng bật TLS cho WebSocket',
            'v2_tls_provider_hint' => 'Các backend khác nhau có cấu hình khác nhau:',
        ],
        'proxy_info' => '*Tương thích với giao thức Shadowsocks',
        'proxy_info_hint' => 'Để tương thích, vui lòng thêm <span class="red-700">_compatible</span> vào giao thức và ngụy trang trong cấu hình máy chủ',
        'refresh_geo' => 'Làm mới vị trí địa lý',
        'refresh_geo_all' => 'Làm mới thông tin địa lý',
        'reload' => 'Tải lại Backend',
        'reload_all' => 'Tải lại tất cả backend',
        'reload_confirm' => 'Bạn có muốn tải lại backend của nút không?',
        'traffic_monitor' => 'Thống kê lưu lượng',
    ],
    'oauth' => [
        'counts' => 'Tổng cộng <code>:num</code> bản ghi ủy quyền',
        'title' => 'Ủy quyền bên thứ ba',
    ],
    'optional' => 'Tùy chọn',
    'permission' => [
        'counts' => 'Tổng cộng có <code>:num</code> quyền hạn',
        'description_hint' => 'Mô tả, ví dụ: [Hệ thống A] Chỉnh sửa A',
        'name_hint' => 'Tên định tuyến, ví dụ: admin.permission.create,update',
        'title' => 'Danh sách quyền hạn',
    ],
    'query' => 'Truy vấn',
    'report' => [
        'annually_accounting' => 'Giao dịch hàng năm',
        'annually_site_flow' => 'Lưu lượng hàng năm',
        'avg_traffic_30d' => 'Lưu lượng trung bình 30 ngày',
        'current_month' => 'Tháng này',
        'current_year' => 'Năm nay',
        'daily_accounting' => 'Giao dịch hàng ngày',
        'daily_distribution' => 'Phân phối hàng ngày',
        'daily_site_flow' => 'Lưu lượng hàng ngày',
        'daily_traffic' => 'Lưu lượng hàng ngày',
        'hourly_traffic' => 'Lưu lượng hàng giờ',
        'last_month' => 'Tháng trước',
        'last_year' => 'Năm trước',
        'monthly_accounting' => 'Giao dịch hàng tháng',
        'monthly_site_flow' => 'Lưu lượng hàng tháng',
        'select_hourly_date' => 'Chọn ngày theo giờ',
        'sum_traffic_30d' => 'Tỷ lệ lưu lượng 30 ngày',
        'today' => 'Hôm nay',
    ],
    'require' => 'Bắt buộc',
    'role' => [
        'counts' => 'Tổng cộng có <code>:num</code> vai trò',
        'description_hint' => 'Tên hiển thị trên bảng điều khiển, ví dụ: Quản trị viên',
        'modify_admin_error' => 'Vui lòng không sửa đổi quản trị viên cấp cao!',
        'name_hint' => 'Tên định danh duy nhất, ví dụ: Administrator',
        'permissions_all' => 'Tất cả quyền hạn',
        'title' => 'Danh sách vai trò',
    ],
    'rule' => [
        'counts' => 'Tổng cộng có <code>:num</code> quy tắc kiểm tra',
        'group' => [
            'counts' => 'Tổng cộng có <code>:num</code> nhóm',
            'title' => 'Nhóm quy tắc',
            'type' => [
                'off' => 'Chặn',
                'on' => 'Cho phép',
            ],
        ],
        'title' => 'Danh sách quy tắc',
        'type' => [
            'domain' => 'Tên miền',
            'ip' => 'IP',
            'protocol' => 'Giao thức',
            'reg' => 'Biểu thức chính quy',
        ],
    ],
    'select_all' => 'Chọn tất cả',
    'selected_hint' => 'Các quy tắc đã được phân bổ có thể tìm kiếm tại đây',
    'set_to' => 'Đặt thành :attribute',
    'setting' => [
        'common' => [
            'connect_nodes' => 'Số lượng nút kết nối',
            'set_default' => 'Đặt làm mặc định',
            'title' => 'Cấu hình chung',
        ],
        'email' => [
            'black' => 'Danh sách đen',
            'rule' => 'Quy tắc',
            'tail' => 'Hậu tố email',
            'tail_placeholder' => 'Vui lòng nhập hậu tố email',
            'title' => 'Danh sách lọc email <small>(dùng để chặn đăng ký email cụ thể)</small>',
            'white' => 'Danh sách trắng',
        ],
        'no_permission' => 'Bạn không có quyền thay đổi tham số!',
        'system' => [
            'account' => 'Tài khoản',
            'auto_job' => 'Tự động hóa',
            'check_in' => 'Điểm danh',
            'extend' => 'Nâng cao',
            'menu' => 'Menu',
            'node' => 'Nút',
            'notify' => 'Thông báo',
            'other' => 'Logo|CS|Phân tích',
            'payment' => 'Thanh toán',
            'promotion' => 'Tiếp thị liên kết',
            'title' => 'Cài đặt hệ thống',
            'web' => 'Chung',
            'task_settings' => 'Cài đặt nhiệm vụ',
        ],
    ],
    'sort_asc' => 'Giá trị sắp xếp càng lớn, càng ưu tiên',
    'start_time' => 'Thời gian bắt đầu',
    'system' => [
        'contact_telegram' => 'Link Telegram Liên hệ',
        'task_limit_new_user' => 'Giới hạn nhiệm vụ (Người dùng mới)',
        'task_limit_intermediate_user' => 'Giới hạn nhiệm vụ (Người dùng trung gian)',
        'task_limit_veteran_user' => 'Giới hạn nhiệm vụ (Người dùng kỳ cựu)',
        'tasks_unit' => 'nhiệm vụ/ngày',
        'task_countdown_hours' => 'Thời gian hoàn thành nhiệm vụ (giờ)',
        'product_price' => 'Giá sản phẩm mặc định',
        'member_reward' => 'Thưởng thành viên mặc định',
        'AppStore_id' => 'Tài khoản Apple',
        'AppStore_password' => 'Mật khẩu Apple',
        'account_expire_notification' => 'Thông báo hết hạn tài khoản',
        'active_account' => [
            'after' => 'Kích hoạt sau khi đăng ký',
            'before' => 'Kích hoạt trước khi đăng ký',
        ],
        'active_times' => 'Số lần kích hoạt tài khoản',
        'admin_invite_days' => 'Thời hạn hiệu lực mã mời của quản trị viên',
        'aff_salt' => 'Mã hóa thông tin người dùng trong liên kết giới thiệu',
        'alipay_qrcode' => 'Mã QR Alipay',
        'auto_release_port' => 'Cơ chế thu hồi cổng',
        'bark_key' => 'Khóa thiết bị Bark',
        'captcha' => [
            'geetest' => 'Geetest',
            'hcaptcha' => 'hCaptcha',
            'recaptcha' => 'Google reCaptcha',
            'standard' => 'Captcha tiêu chuẩn',
            'turnstile' => 'Turnstile',
        ],
        'captcha_key' => 'Khóa Captcha',
        'captcha_secret' => 'Bí mật/ID Captcha',
        'codepay_id' => 'ID CodePay',
        'codepay_key' => 'Khóa giao tiếp CodePay',
        'codepay_url' => 'URL yêu cầu CodePay',
        'data_anomaly_notification' => 'Thông báo bất thường dữ liệu',
        'data_exhaust_notification' => 'Thông báo hết dữ liệu',
        'ddns_key' => 'Khóa nhà cung cấp DNS',
        'ddns_mode' => 'Chế độ DDNS',
        'ddns_secret' => 'Bí mật nhà cung cấp DNS',
        'default_days' => 'Thời hạn mặc định',
        'default_traffic' => 'Lưu lượng mặc định',
        'demo_restriction' => 'Không được phép thay đổi cấu hình này trong môi trường demo!',
        'detection_check_times' => 'Thông báo kiểm tra chặn',
        'dingTalk_access_token' => 'Token truy cập DingTalk',
        'dingTalk_secret' => 'Bí mật DingTalk',
        'epay_key' => 'Khóa thương gia ePay',
        'epay_mch_id' => 'ID thương gia ePay',
        'epay_url' => 'URL giao diện ePay',
        'expire_days' => 'Ngưỡng cảnh báo hết hạn',
        'f2fpay_app_id' => 'ID ứng dụng Alipay',
        'f2fpay_private_key' => 'Khóa riêng tư Alipay',
        'f2fpay_public_key' => 'Khóa công khai Alipay',
        'forbid' => [
            'china' => 'Chặn truy cập từ Trung Quốc',
            'mainland' => 'Chặn truy cập từ Trung Quốc đại lục',
            'oversea' => 'Chặn truy cập từ nước ngoài',
        ],
        'forbid_mode' => 'Chế độ cấm truy cập',
        'hint' => [
            'AppStore_id' => 'Dùng trong bài viết hướng dẫn iOS',
            'AppStore_password' => 'Dùng trong bài viết hướng dẫn iOS',
            'account_expire_notification' => 'Thông báo hết hạn tài khoản',
            'active_times' => 'Số lần kích hoạt tài khoản qua email trong 24 giờ',
            'admin_invite_days' => 'Thời hạn hiệu lực mã mời của quản trị viên',
            'aff_salt' => 'Muối mã hóa cho URL giới thiệu',
            'auto_release_port' => 'Tự động giải phóng cổng sau khi bị cấm hoặc hết hạn <code>'.config('tasks.release_port').'</code> ngày',
            'bark_key' => 'Khóa thiết bị cho thông báo đẩy iOS',
            'captcha_key' => 'Xem <a href="https://proxypanel.gitbook.io/wiki/captcha" target="_blank">hướng dẫn cài đặt</a>',
            'data_anomaly_notification' => 'Thông báo cho quản trị viên khi lưu lượng hàng giờ vượt quá ngưỡng',
            'data_exhaust_notification' => 'Thông báo khi lưu lượng sắp hết',
            'ddns_key' => 'Xem <a href="https://proxypanel.gitbook.io/wiki/ddns" target="_blank">hướng dẫn cài đặt</a>',
            'ddns_mode' => 'Đồng bộ thay đổi tên miền & IP với nhà cung cấp DNS',
            'default_days' => 'Thời hạn mặc định cho tài khoản mới, 0 nghĩa là hết hạn ngay hôm nay',
            'default_traffic' => 'Lưu lượng mặc định cho tài khoản mới',
            'detection_check_times' => 'Tự động ngắt kết nối nút sau N lần thông báo, 0 là không giới hạn, tối đa 12',
            'dingTalk_access_token' => 'Token truy cập bot tùy chỉnh <a href=https://open.dingtalk.com/document/group/custom-robot-access#title-jfe-yo9-jl2 target=_blank>truy cập</a>',
            'dingTalk_secret' => 'Bí mật bot tùy chỉnh khi bật ký',
            'expire_days' => 'Bắt đầu thông báo hết hạn tài khoản',
            'f2fpay_app_id' => 'APPID Alipay',
            'f2fpay_private_key' => 'Khóa riêng tư Alipay từ công cụ tạo khóa bí mật',
            'f2fpay_public_key' => 'Không phải khóa công khai APP!',
            'forbid_mode' => 'Chặn truy cập từ các khu vực cụ thể',
            'iYuu_token' => 'Điền <a href=https://iyuu.cn target=_blank>token IYUU</a> trước khi bật',
            'invite_num' => 'Số lượng lời mời mặc định cho mỗi người dùng',
            'is_activate_account' => 'Yêu cầu kích hoạt qua email',
            'is_ban_status' => '(Cẩn thận) Cấm tài khoản sẽ đặt lại mọi dữ liệu người dùng',
            'is_captcha' => 'Yêu cầu captcha để đăng nhập/đăng ký nếu bật',
            'is_checkin' => 'Phần thưởng ngẫu nhiên khi điểm danh',
            'is_clear_log' => '(Khuyến nghị) Tự động xóa nhật ký không cần thiết khi bật',
            'is_custom_subscribe' => 'Hiển thị thời gian hết hạn & lưu lượng còn lại trên danh sách đăng ký khi bật',
            'is_email_filtering' => 'Danh sách đen: Người dùng có thể đăng ký với đuôi email không có trong danh sách đen; Danh sách trắng: Người dùng phải đăng ký với đuôi email có trong danh sách trắng',
            'is_forbid_robot' => 'Trả về lỗi 404 nếu truy cập bởi bot/proxy',
            'is_free_code' => 'Ẩn mã mời miễn phí nếu tắt',
            'is_rand_port' => 'Cổng ngẫu nhiên khi thêm/đăng ký người dùng',
            'is_register' => 'Tắt đăng ký nếu bỏ chọn',
            'is_subscribe_ban' => 'Tự động cấm nếu yêu cầu đăng ký vượt quá ngưỡng',
            'is_traffic_ban' => 'Tự động vô hiệu hóa dịch vụ nếu lưu lượng vượt quá ngưỡng trong 1 giờ',
            'maintenance_content' => 'Thông báo bảo trì tùy chỉnh',
            'maintenance_mode' => 'Chuyển hướng người dùng bình thường đến trang bảo trì nếu bật | Quản trị viên có thể đăng nhập qua <a href=\'javascript:(0)\'>:url</a>',
            'maintenance_time' => 'Dùng cho đồng hồ đếm ngược trên trang bảo trì',
            'min_port' => 'Phạm vi cổng 1000 - 65535',
            'node_blocked_notification' => 'Phát hiện nút bị chặn hàng giờ, thông báo cho quản trị viên',
            'node_daily_notification' => 'Báo cáo sử dụng nút hàng ngày',
            'node_offline_notification' => 'Phát hiện ngoại tuyến mỗi 10 phút, thông báo nếu có nút nào ngoại tuyến',
            'node_renewal_notification' => 'Nhắc nhở quản trị viên gia hạn nút trước 7 ngày, 3 ngày và 1 ngày trước khi hết hạn.',
            'oauth_path' => 'Vui lòng bật nền tảng trong .ENV trước',
            'offline_check_times' => 'Ngừng thông báo sau N lần cảnh báo trong 24 giờ',
            'password_reset_notification' => 'Cho phép đặt lại mật khẩu qua email nếu bật',
            'paybeaver_app_id' => '<a href="https://merchant.paybeaver.com/" target="_blank">Trung tâm thương gia</a> -> Nhà phát triển -> App ID',
            'paybeaver_app_secret' => '<a href="https://merchant.paybeaver.com/" target="_blank">Trung tâm thương gia</a> -> Nhà phát triển -> App Secret',
            'payjs_mch_id' => 'Lấy từ <a href="https://payjs.cn/dashboard/member" target="_blank">trang thành viên</a>',
            'payment_confirm_notification' => 'Thông báo cho quản trị viên để xử lý đơn hàng thanh toán thủ công',
            'payment_received_notification' => 'Thông báo cho người dùng khi nhận được thanh toán',
            'pushDeer_key' => 'Điền <a href=https://www.pushdeer.com/official.html target=_blank>PushDeer Push Key</a> trước khi bật',
            'pushplus_token' => 'Điền <a href=https://www.pushplus.plus/push1.html target=_blank>PushPlus Token</a> trước khi bật',
            'rand_subscribe' => 'Trả về danh sách nút ngẫu nhiên nếu bật, nếu không sẽ theo thứ tự danh sách nút',
            'redirect_url' => 'Chuyển hướng yêu cầu bị chặn đến URL này khi quy tắc được kích hoạt',
            'referral_money' => 'Số tiền tối thiểu có thể rút',
            'referral_percent' => 'Tỷ lệ phần trăm của số tiền đơn hàng mà người giới thiệu nhận được',
            'referral_status' => 'Đóng hệ thống giới thiệu mà không ảnh hưởng đến dữ liệu hiện có',
            'referral_traffic' => 'Tặng lưu lượng miễn phí khi đăng ký qua liên kết giới thiệu',
            'referral_type' => 'Tính hoàn tiền mới theo chế độ mới sau khi chuyển đổi',
            'register_ip_limit' => 'Số lượng đăng ký cho phép mỗi IP trong 24 giờ, 0 là không giới hạn',
            'reset_password_times' => 'Số lần đặt lại mật khẩu qua email trong 24 giờ',
            'reset_traffic' => 'Tự động đặt lại lưu lượng dựa trên chu kỳ gói của người dùng',
            'server_chan_key' => 'Điền <a href="https://sct.ftqq.com/r/2626" target="_blank">ServerChan SCKEY</a> trước khi bật',
            'standard_currency' => 'Tiền tệ chính sử dụng trong bảng điều khiển',
            'subject_name' => 'Tên sản phẩm tùy chỉnh trong các cổng thanh toán',
            'subscribe_ban_times' => 'Số lượng yêu cầu đăng ký tối đa mỗi người dùng trong 24 giờ',
            'subscribe_domain' => 'Bắt đầu với http:// hoặc https:// để tránh lỗi DNS poisoning',
            'subscribe_max' => 'Số lượng nút tối đa trả về trong danh sách đăng ký, 0 là tất cả',
            'telegram_token' => 'Lấy <a href=https://t.me/BotFather target=_blank>TOKEN</a> từ @BotFather',
            'tg_chat_token' => 'Điền <a href=https://t.me/realtgchat_bot target=_blank>TG Chat token</a> trước khi bật',
            'ticket_closed_notification' => 'Thông báo cho người dùng khi vé được đóng',
            'ticket_created_notification' => 'Thông báo cho quản trị viên/người dùng tùy thuộc vào người tạo',
            'ticket_replied_notification' => 'Thông báo cho bên kia khi vé được trả lời',
            'traffic_ban_time' => 'Thời gian cấm tự động cho các ngoại lệ',
            'traffic_ban_value' => 'Kích hoạt cấm tài khoản tự động nếu vượt quá giá trị này trong 1 giờ',
            'traffic_limit_time' => 'Khoảng thời gian giữa các lần điểm danh',
            'traffic_warning_percent' => 'Gửi thông báo hết lưu lượng khi sử dụng hàng ngày đạt đến tỷ lệ phần trăm này',
            'user_invite_days' => 'Thời hạn hiệu lực của mã mời do người dùng tạo',
            'username_type' => 'Loại tên người dùng mặc định cho người dùng',
            'v2ray_tls_provider' => 'Cấu hình TLS của V2Ray, cấu hình nút sẽ ghi đè',
            'web_api_url' => 'Ví dụ: '.config('app.url'),
            'webmaster_email' => 'Email liên hệ hiển thị trong một số thông báo lỗi',
            'website_analytics' => 'Mã JavaScript phân tích trang web',
            'website_callback_url' => 'Ngăn chặn lỗi callback thanh toán do DNS poisoning',
            'website_customer_service' => 'Mã JavaScript dịch vụ khách hàng',
            'website_name' => 'Tên trang web trong email',
            'website_security_code' => 'Yêu cầu mã bảo mật để truy cập trang web nếu được thiết lập',
            'website_url' => 'Tên miền chính sử dụng cho các liên kết',
            'wechat_aid' => '<a href="https://work.weixin.qq.com/wework_admin/frame#apps" target="_blank">Quản lý ứng dụng</a> -> AgentId',
            'wechat_cid' => 'Lấy từ <a href="https://work.weixin.qq.com/wework_admin/frame#profile" target="_blank">Thông tin doanh nghiệp</a>',
            'wechat_encodingAESKey' => 'Quản lý ứng dụng -> Cài đặt ứng dụng -> EncodingAESKey',
            'wechat_secret' => 'Bí mật ứng dụng (cần WeChat doanh nghiệp để xem)',
            'wechat_token' => 'Cài đặt ứng dụng -> TOKEN, URL callback: :url',
            'contact_telegram' => 'Nhập link Telegram liên hệ đầy đủ (ví dụ: https://t.me/yourgroup).',
            'task_limit_new_user' => 'Số nhiệm vụ tối đa mỗi ngày cho người dùng mới (ví dụ: đăng ký dưới 7 ngày).',
            'task_limit_intermediate_user' => 'Số nhiệm vụ tối đa mỗi ngày cho người dùng trung gian (ví dụ: đăng ký 7-30 ngày).',
            'task_limit_veteran_user' => 'Số nhiệm vụ tối đa mỗi ngày cho người dùng kỳ cựu (ví dụ: đăng ký trên 30 ngày).',
            'task_countdown_hours' => 'Số giờ người dùng có để hoàn thành một nhiệm vụ được giao.',
            'product_price' => 'Giá mặc định cho một đăng sản phẩm/nhiệm vụ mới bởi người dùng doanh nghiệp.',
            'member_reward' => 'Phần thưởng mặc định cho thành viên hoàn thành một nhiệm vụ.',
        ],
        'iYuu_token' => 'Token IYUU',
        'invite_num' => 'Số lượng lời mời mặc định',
        'is_AliPay' => 'Thanh toán Alipay',
        'is_QQPay' => 'Thanh toán QQ',
        'is_WeChatPay' => 'Thanh toán WeChat',
        'is_activate_account' => 'Kích hoạt tài khoản',
        'is_ban_status' => 'Tự động cấm khi hết hạn',
        'is_captcha' => 'Chế độ Captcha',
        'is_checkin' => 'Điểm danh nhận lưu lượng',
        'is_clear_log' => 'Tự động xóa nhật ký',
        'is_custom_subscribe' => 'Đăng ký nâng cao',
        'is_email_filtering' => 'Cơ chế lọc email',
        'is_forbid_robot' => 'Cấm robot truy cập',
        'is_free_code' => 'Mã mời miễn phí',
        'is_invite_register' => 'Mời đăng ký',
        'is_otherPay' => 'Thanh toán đặc biệt',
        'is_rand_port' => 'Cổng ngẫu nhiên',
        'is_register' => 'Đăng ký người dùng',
        'is_subscribe_ban' => 'Tự động cấm yêu cầu đăng ký bất thường',
        'is_traffic_ban' => 'Tự động cấm sử dụng lưu lượng bất thường',
        'is_MoMo' => 'Thanh toán Momo',
        'momo_partner_code' => 'Partner Code',
        'momo_public_key' => 'Public Key',
        'momo_secret_key' => 'Secret Key',
        'momo_access_key' => 'Access Key',
        'momo_api_endpoint' => 'API Endpoint',
        'momo_account_number' => 'Account Number',
        'momo_account_name' => 'Account Name',
        'momo_min_amount' => 'Minimum Amount',
        'momo_max_amount' => 'Maximum Amount',
        'momo_qr_code_url' => 'QR Code URL',
        'is_HoodPay' => 'Thanh toán HoodPay',
        'hoodpay_api_key' => '[HoodPay] API Key',
        'hoodpay_api_secret' => '[HoodPay] API Secret',
        'hoodpay_merchant_id' => '[HoodPay] Merchant ID',
        'hoodpay_webhook_url' => '[HoodPay] Webhook URL',
        'hoodpay_callback_url' => '[HoodPay] Callback URL',
        'hoodpay_payment_url' => '[HoodPay] Payment URL',
        'hoodpay_min_amount' => '[HoodPay] Minimum Amount',
        'hoodpay_max_amount' => '[HoodPay] Maximum Amount',
        'hoodpay_business_id' => '[HoodPay] Business ID',
        'hoodpay_api_url' => '[HoodPay] API URL',
        'hoodpay_logo' => '[HoodPay] Logo URL',
        'maintenance_content' => 'Nội dung thông báo bảo trì',
        'maintenance_mode' => 'Chế độ bảo trì',
        'maintenance_time' => 'Thời gian kết thúc bảo trì',
        'min_port' => 'Phạm vi cổng',
        'min_rand_traffic' => 'Phạm vi lưu lượng',
        'node_blocked_notification' => 'Thông báo chặn nút',
        'node_daily_notification' => 'Báo cáo sử dụng nút hàng ngày',
        'node_offline_notification' => 'Thông báo nút ngoại tuyến',
        'node_renewal_notification' => 'Thông báo gia hạn nút',
        'notification' => [
            'channel' => [
                'bark' => 'Bark',
                'dingtalk' => 'DingTalk',
                'email' => 'Email',
                'iyuu' => 'IYUU',
                'pushdeer' => 'PushDeer',
                'pushplus' => 'PushPlus',
                'serverchan' => 'ServerChan',
                'site' => 'Thông báo trên trang',
                'telegram' => 'Telegram',
                'tg_chat' => 'TG Chat',
                'wechat' => 'WeChat doanh nghiệp',
            ],
            'send_test' => 'Gửi tin nhắn thử nghiệm',
            'test' => [
                'content' => 'Nội dung kiểm tra',
                'success' => 'Gửi thành công. Vui lòng kiểm tra điện thoại của bạn để nhận thông báo đẩy.',
                'title' => 'Đây là tiêu đề kiểm tra',
                'unknown_channel' => 'Kênh không xác định',
            ],
        ],
        'oauth_path' => 'Nền tảng đăng nhập bên thứ ba',
        'offline_check_times' => 'Số lần thông báo ngoại tuyến',
        'params_required' => 'Vui lòng hoàn thiện các tham số cần thiết cho :attribute trước!',
        'password_reset_notification' => 'Thông báo đặt lại mật khẩu',
        'paybeaver_app_id' => 'ID ứng dụng PayBeaver',
        'paybeaver_app_secret' => 'Bí mật ứng dụng PayBeaver',
        'payjs_key' => 'Khóa giao tiếp PayJs',
        'payjs_mch_id' => 'ID thương gia PayJs',
        'payment' => [
            'attribute' => 'Cổng thanh toán',
            'channel' => [
                'alipay' => 'Alipay F2F',
                'codepay' => 'CodePay',
                'epay' => 'ePay',
                'manual' => 'Thanh toán thủ công',
                'paybeaver' => 'PayBeaver',
                'payjs' => 'PayJs',
                'paypal' => 'PayPal',
                'stripe' => 'Stripe',
                'theadpay' => 'THeadPay',
                'momo' => 'Momo',
                'hoodpay' => 'HoodPay',
                'wechat' => 'WeChat Pay',
            ],
            'hint' => [
                'alipay' => 'Chức năng này yêu cầu đi đến <a href="https://open.alipay.com/platform/appManage.htm?#/create/" target="_blank">Nền tảng mở của Ant Financial Services</a> để đăng ký quyền và ứng dụng',
                'codepay' => 'Vui lòng đi đến <a href="https://codepay.fateqq.com/i/377289" target="_blank">CodePay</a>. Đăng ký tài khoản, tải xuống và cài đặt phần mềm của nó',
                'manual' => 'Sau khi cổng thanh toán được cài đặt và chọn, nó sẽ hiển thị trên giao diện người dùng',
                'paybeaver' => 'Vui lòng đi đến <a href="https://merchant.paybeaver.com/?aff_code=iK4GNuX8" target="_blank">PayBeaver</a> để đăng ký tài khoản',
                'payjs' => 'Vui lòng đi đến <a href="https://payjs.cn/ref/zgxjnb" target="_blank">PayJs</a> để đăng ký tài khoản',
                'paypal' => 'Đăng nhập vào <a href="https://www.paypal.com/businessprofile/mytools/apiaccess/firstparty" target="_blank">trang đăng ký API</a> với tài khoản thương gia của bạn, đồng ý và nhận thông tin cài đặt',
                'theadpay' => 'Vui lòng đi đến <a href="https://theadpay.com/" target="_blank">THeadPay</a> để yêu cầu tài khoản',
                'momo' => 'Vui lòng đi đến <a href="https://momo.vn/" target="_blank">Momo</a> để yêu cầu tài khoản',
                'stripe' => 'Vui lòng đi đến <a href="https://dashboard.stripe.com/" target="_blank">Stripe</a> để đăng ký tài khoản',
                'wechat' => 'Vui lòng đi đến <a href="https://mp.weixin.qq.com/" target="_blank">Tài khoản doanh nghiệp</a> để đăng ký tài khoản',
                'hoodpay' => 'Vui lòng đi đến <a href="https://hoodpay.com/" target="_blank">HoodPay</a> để đăng ký tài khoản',
            ],
            'notes' => [
            'credit_update_failed' => 'Cập nhật tín dụng thất bại. Cần kiểm tra thủ công.',
            'user_not_found_deposit' => 'Không tìm thấy người dùng cho khoản nạp tiền. Cần kiểm tra thủ công.',
            'order_not_pending' => 'Đơn hàng :sn không ở trạng thái chờ xử lý. Cần kiểm tra thủ công.',
            'associated_order_not_found' => 'Không tìm thấy đơn hàng liên kết. Cần kiểm tra thủ công.',
            ],
            'epay_info_title' => 'Thông tin EPay (Chỉ mang tính tham khảo)',
            'epay_merchant_status' => 'Trạng thái Merchant: ',
            'epay_account_balance' => ' | Số dư tài khoản: ',
            'epay_settlement_account' => ' | Tài khoản thanh toán: ',
            'epay_channel_fee_alipay' => '<br/><br/>Phí kênh: 【Alipay - ',
            'epay_channel_fee_wechat' => '% | WeChat - ',
            'epay_channel_fee_qq' => '% | QQ Wallet - ',
            'epay_info_disclaimer' => '%】<br/><br/> Vui lòng tham khảo thông tin từ nền tảng thanh toán. Thông tin này được lấy qua API và chỉ mang tính tham khảo.',
        ],
        'payment_confirm_notification' => 'Thông báo xác nhận thanh toán thủ công',
        'payment_received_notification' => 'Thông báo thanh toán thành công',
        'paypal_app_id' => 'ID ứng dụng PayPal',
        'paypal_client_id' => 'ID khách hàng PayPal',
        'paypal_client_secret' => 'Bí mật khách hàng PayPal',
        'placeholder' => [
            'bark_key' => 'Điền mã thiết bị Bark rồi nhấn Cập nhật',
            'codepay_url' => 'https://codepay.fateqq.com/creat_order/?',
            'default_url' => 'Mặc định là :url',
            'dingTalk_access_token' => 'Token truy cập bot tùy chỉnh',
            'dingTalk_secret' => 'Bí mật bot tùy chỉnh sau khi ký',
            'iYuu_token' => 'Điền token IYUU rồi nhấn Cập nhật',
            'pushDeer_key' => 'Điền Push Key của PushDeer rồi nhấn Cập nhật',
            'pushplus_token' => 'Vui lòng đăng ký tại ServerChan',
            'server_chan_key' => 'Điền SCKEY của ServerChan rồi nhấn Cập nhật',
            'telegram_token' => 'Điền token Telegram rồi nhấn Cập nhật',
            'tg_chat_token' => 'Vui lòng đăng ký tại Telegram',
            'wechat_aid' => 'AID ứng dụng WeChat doanh nghiệp',
            'wechat_cid' => 'Điền CID WeChat rồi nhấn Cập nhật',
            'wechat_secret' => 'Bí mật ứng dụng WeChat doanh nghiệp',
        ],
        'pushDeer_key' => 'Khóa PushDeer',
        'pushplus_token' => 'Token PushPlus',
        'rand_subscribe' => 'Đăng ký ngẫu nhiên',
        'redirect_url' => 'URL chuyển hướng',
        'referral' => [
            'loop' => 'Hoàn tiền liên tục',
            'once' => 'Hoàn tiền lần đầu',
        ],
        'referral_money' => 'Giới hạn rút tiền tối thiểu',
        'referral_percent' => 'Tỷ lệ hoàn tiền',
        'referral_status' => 'Chức năng giới thiệu',
        'referral_traffic' => 'Thưởng lưu lượng khi đăng ký',
        'referral_type' => 'Loại hoàn tiền',
        'register_ip_limit' => 'Giới hạn đăng ký cùng IP',
        'reset_password_times' => 'Số lần đặt lại mật khẩu',
        'reset_traffic' => 'Tự động đặt lại lưu lượng',
        'server_chan_key' => 'Khóa ServerChan',
        'standard_currency' => 'Tiền tệ chính',
        'stripe_public_key' => 'Khóa công khai Stripe',
        'stripe_secret_key' => 'Khóa bí mật Stripe',
        'stripe_signing_secret' => 'Bí mật ký WebHook Stripe',
        'subject_name' => 'Tên sản phẩm tùy chỉnh',
        'subscribe_ban_times' => 'Giới hạn yêu cầu đăng ký',
        'subscribe_domain' => 'URL đăng ký nút',
        'subscribe_max' => 'Số lượng nút đăng ký tối đa',
        'telegram_token' => 'Token Telegram',
        'tg_chat_token' => 'Token TG Chat',
        'theadpay_key' => 'Khóa thương gia THeadPay',
        'theadpay_mchid' => 'ID thương gia THeadPay',
        'theadpay_url' => 'URL giao diện THeadPay',
        'ticket_closed_notification' => 'Thông báo đóng vé',
        'ticket_created_notification' => 'Thông báo tạo vé mới',
        'ticket_replied_notification' => 'Thông báo trả lời vé',
        'traffic_ban_time' => 'Thời gian cấm',
        'traffic_ban_value' => 'Ngưỡng lưu lượng bất thường',
        'traffic_limit_time' => 'Khoảng thời gian kiểm tra',
        'traffic_warning_percent' => 'Ngưỡng cảnh báo lưu lượng',
        'trojan_license' => 'Giấy phép Trojan',
        'user_invite_days' => 'Thời hạn hiệu lực mã mời của người dùng',
        'username' => [
            'any' => 'Tên người dùng bất kỳ',
            'email' => 'Email',
            'mobile' => 'Số điện thoại',
        ],
        'username_type' => 'Loại tên người dùng',
        'v2ray_license' => 'Giấy phép V2Ray',
        'v2ray_tls_provider' => 'Cấu hình TLS V2Ray',
        'web_api_url' => 'URL API',
        'webmaster_email' => 'Email quản trị viên',
        'website_analytics' => 'Mã phân tích trang web',
        'website_callback_url' => 'URL callback thanh toán',
        'website_customer_service' => 'Mã dịch vụ khách hàng',
        'website_home_logo' => 'Logo trang chủ',
        'website_logo' => 'Logo trang nội bộ',
        'website_name' => 'Tên trang web',
        'website_security_code' => 'Mã bảo mật trang web',
        'website_url' => 'URL trang web',
        'wechat_aid' => 'ID ứng dụng WeChat',
        'wechat_cid' => 'ID WeChat',
        'wechat_encodingAESKey' => 'Khóa mã hóa WeChat',
        'wechat_qrcode' => 'Mã QR WeChat',
        'wechat_secret' => 'Bí mật WeChat',
        'wechat_token' => 'Token WeChat',
    ],
    'system_generate' => 'Hệ thống tạo ra',
    'ticket' => [
        'close_confirm' => 'Bạn có muốn đóng yêu cầu hỗ trợ này không?',
        'counts' => 'Tổng cộng <code>:num</code> yêu cầu hỗ trợ',
        'error' => 'Lỗi không xác định! Vui lòng kiểm tra nhật ký',
        'inviter_info' => 'Thông tin người mời',
        'self_send' => 'Bạn không thể tạo vé cho chính mình!',
        'send_to' => 'Vui lòng điền thông tin người dùng mục tiêu',
        'title' => 'Danh sách yêu cầu hỗ trợ',
        'user_info' => 'Thông tin người dùng',
    ],
    'times' => 'Lần',
    'tools' => [
        'analysis' => [
            'file_missing' => ':file_name không tồn tại. Vui lòng tạo tệp trước.',
            'not_enough' => 'Ít hơn 15,000 bản ghi, không thể phân tích',
            'req_url' => 'Nhật ký URL yêu cầu gần đây',
            'title' => 'Phân tích nhật ký SSR <small>Chỉ dành cho một nút</small>',
        ],
        'convert' => [
            'content_placeholder' => 'Vui lòng điền thông tin cấu hình cần chuyển đổi.',
            'file_missing' => 'Tệp không tồn tại. Vui lòng kiểm tra quyền truy cập thư mục.',
            'missing_error' => 'Chuyển đổi không thành công: Thông tin cấu hình thiếu trường [port_password] hoặc trường này bị trống.',
            'params_unknown' => 'Ngoại lệ tham số',
            'title' => 'Chuyển đổi định dạng <small>SS sang SSR</small>',
        ],
        'decompile' => [
            'attribute' => 'Giải mã liên kết cấu hình',
            'content_placeholder' => 'Vui lòng điền các liên kết ShadowsocksR cần giải mã, cách nhau bằng dòng mới.',
            'title' => 'Giải mã <small>Thông tin cấu hình</small>',
        ],
        'import' => [
            'file_error' => 'Đã xảy ra lỗi không xác định. Vui lòng tải lại lên.',
            'file_required' => 'Vui lòng chọn tệp để tải lên',
            'file_type_error' => 'Chỉ cho phép tải lên các tệp loại :type.',
            'format_error' => 'Lỗi phân tích định dạng nội dung. Vui lòng tải lên tệp :type đáp ứng định dạng quy định.',
        ],
    ],
    'unselected_hint' => 'Các quy tắc chưa được phân bổ có thể tìm kiếm tại đây',
    'user' => [
        'admin_deletion' => 'Quản trị viên hệ thống không thể bị xóa',
        'bulk_account_quantity' => 'Số lượng tài khoản được tạo hàng loạt',
        'connection_test' => 'Kiểm tra kết nối',
        'counts' => 'Tổng cộng <code>:num</code> tài khoản',
        'group' => [
            'counts' => 'Tổng cộng <code>:num</code> nhóm',
            'name' => 'Tên nhóm',
            'title' => 'Kiểm soát nhóm người dùng<small> (Một nút có thể thuộc nhiều nhóm, nhưng người dùng chỉ có thể thuộc một nhóm; đối với các nút hiển thị/có sẵn cho người dùng, nhóm có ưu tiên cao hơn cấp độ)</small>',
        ],
        'info' => [
            'account' => 'Thông tin tài khoản',
            'expired_date_hint' => 'Để trống để mặc định thời hạn một năm',
            'proxy' => 'Thông tin proxy',
            'recharge_placeholder' => 'Nếu là số âm, sẽ trừ vào số dư',
            'reset_date_hint' => 'Ngày đặt lại lưu lượng tiếp theo',
            'switch' => 'Chuyển đổi danh tính',
            'uuid_hint' => 'UUID cho V2Ray',
        ],
        'online_monitor' => 'Giám sát trực tuyến',
        'proxies_config' => 'Thông tin kết nối cho :username',
        'proxy_info' => 'Thông tin cấu hình',
        'reset_confirm' => [0 => 'Bạn có muốn đặt lại lưu lượng của [', 1 => '] không?'],
        'reset_traffic' => 'Đặt lại lưu lượng',
        'traffic_monitor' => 'Thống kê lưu lượng',
        'update_help' => 'Cập nhật thành công, quay lại?',
        'user_view' => 'Chuyển sang chế độ người dùng',
        'reset_password' => 'Đặt lại mật khẩu',
        'reset_password_for' => 'Đặt lại mật khẩu cho :username',
        'password_reset_success' => 'Đặt lại mật khẩu thành công cho :username',
        'deleted_success' => 'Xóa tài khoản :username thành công',
        'switch_to_user' => 'Chuyển sang chế độ người dùng',
        'switch_confirm' => 'Bạn có muốn chuyển sang chế độ người dùng không?',
        'switched_to_user' => 'Đã chuyển sang :username thành công.',
        'switched_back_to_admin' => 'Đã chuyển về chế độ quản trị viên thành công.',
        'impersonating_user' => 'Đang giả mạo người dùng',
        'switch_back_to_admin_short' => 'Quay lại quản trị viên',
    ],
    'user_dashboard' => 'Bảng điều khiển người dùng',
    'yes' => 'Có',
    'zero_unlimited_hint' => '0 hoặc để trống cho không giới hạn',
    'products' => [
        'manage_title' => 'Sản Phẩm',
        'product_list' => 'Danh Sách Sản Phẩm',
        'id' => 'ID',
        'gmap_link' => 'Link GMAP',
        'creator' => 'Người Tạo',
        'amount' => 'Số Lượng',
        'price' => 'Giá',
        'status' => 'Trạng Thái',
        'created_at' => 'Ngày Tạo',
        'actions' => 'Hành Động',
        'review' => 'Duyệt',
        'edit_product_status' => 'Chỉnh Sửa Trạng Thái Sản Phẩm',
        'product_details' => 'Chi Tiết Sản Phẩm',
        'view_details' => 'Chi Tiết',
        'description' => 'Mô Tả',
        'link_drive' => 'Link Drive',
        'current_status' => 'Trạng Thái Hiện Tại',
        'new_status' => 'Trạng Thái Mới',
        'update_status' => 'Cập Nhật Trạng Thái',
        'select_status' => 'Chọn Trạng Thái',
        'product_management' => 'Quản Lý Sản Phẩm',
        'approve' => 'Chấp Thuận',
        'reject' => 'Từ Chối',
        'pending_approval' => 'Chờ duyệt',
        'approved_by_admin' => 'Đã duyệt',
        'rejected_by_admin' => 'Từ chối',
        'status_updated_successfully' => 'Cập nhật trạng thái sản phẩm thành công.',
        'refund_processed' => 'Sản phẩm đã bị từ chối và số tiền đã được hoàn lại cho người dùng business.',
        'status_update_failed' => 'Cập nhật trạng thái sản phẩm thất bại.',
        'product_not_found' => 'Không tìm thấy sản phẩm.',
        'user_not_found_for_refund' => 'Không tìm thấy người dùng để hoàn tiền.',
        'fail_to_refund' => 'Hoàn tiền thất bại.',
        'cannot_change_status_for_current_state' => 'Không thể thay đổi trạng thái cho sản phẩm ở tình trạng này.',
        'admin_notes' => 'Ghi chú của QTV',
        'enter_admin_notes_placeholder' => 'Nhập ghi chú của QTV',
        'create_new' => 'Tạo mới',
    ],
    'user_tasks' => [
        'menu_title' => 'Nhiệm vụ',
        'filter_status' => 'Lọc theo Trạng thái',
        'filter_user_id' => 'Lọc theo ID Người dùng',
        'filter_product_id' => 'Lọc theo ID Sản phẩm',
        'id' => 'ID',
        'user' => 'Người dùng',
        'product' => 'Sản phẩm (Link Gmap)',
        'reward' => 'Phần thưởng',
        'assigned_at' => 'Giao lúc',
        'deadline_at' => 'Hạn chót',
        'submitted_at' => 'Nộp lúc',
        'status' => 'Trạng thái',
        'admin_notes' => 'Ghi chú của QTV',
        'actions' => 'Hành động',
        'admin_notes_for_task' => 'Ghi chú của QTV cho Nhiệm vụ #:id',
        'report_notes_for_task' => 'Ghi chú báo cáo cho Nhiệm vụ #:id',
        'update_status' => 'Cập nhật Trạng thái',
        'update_status_for_task' => 'Cập nhật Trạng thái cho Nhiệm vụ #:id',
        'new_status' => 'Trạng thái mới',
        'error_updating_user_credit' => 'Lỗi khi cập nhật sô dư người dùng',
        'report_notes' => 'Ghi chú báo cáo',
    ],
    'user_management' => [
        'title' => 'Quản lý người dùng',
        'user_list' => 'Danh sách người dùng',
        'menu_title' => 'Người dùng',
        'edit_user_title' => 'Chỉnh sửa người dùng: :name',
        'edit_user' => 'Chỉnh sửa người dùng',
        'max_daily_tasks' => 'Giới hạn nhiệm vụ hàng ngày',
        'max_daily_tasks_placeholder' => 'Giới hạn nhiệm vụ hàng ngày',
        'max_daily_tasks_desc' => 'Giới hạn số lượng nhiệm vụ mà người dùng có thể thực hiện trong một ngày.',
        'account_status' => 'Trạng thái tài khoản',
        'change_password_section' => 'Đặt lại mật khẩu',
        'change_password_desc' => 'Đặt lại mật khẩu cho người dùng này. Để trống để giữ nguyên mật khẩu hiện tại.',
    ],
    'withdraw_requests' => [
        'menu_title' => 'Yêu cầu Rút tiền',
        'manage_title' => 'Quản lý Yêu cầu Rút tiền',
        'list_title' => 'Danh sách Yêu cầu Rút tiền',
        'details_title' => 'Chi tiết Yêu cầu Rút tiền',
        'user' => 'Người dùng',
        'amount' => 'Số tiền',
        'payment_method' => 'Phương thức TT',
        'payment_details' => 'Chi tiết Thanh toán',
        'status' => [
            'title' => 'Trạng thái',
        ],
        'requested_at' => 'Ngày yêu cầu',
        'processed_at' => 'Ngày xử lý',
        'admin_notes' => 'Ghi chú QTV',
        'actions' => 'Hành động',
        'update_status_short' => 'Cập nhật TT',
        'update_status_for' => 'Cập nhật Trạng thái cho Yêu cầu',
        'current_status' => 'Trạng thái hiện tại',
        'new_status' => 'Trạng thái mới',
        'approve' => 'Duyệt',
        'reject' => 'Từ chối',
        'mark_as_paid' => 'Đánh dấu Đã thanh toán',
        'transaction_id' => 'Mã giao dịch (Nếu có)',
        'status_updated_successfully' => 'Cập nhật trạng thái yêu cầu rút tiền thành công.',
        'status_not_changed' => 'Trạng thái không thay đổi.',
        'refund_failed_credit_update' => 'Hoàn tiền cho người dùng thất bại.',
        'user_not_found' => 'Không tìm thấy người dùng của yêu cầu này.',
        'no_requests_found' => 'Không tìm thấy yêu cầu rút tiền nào.',
        'user_current_credit' => 'Số dư hiện tại của người dùng',
        'cannot_change_from_paid' => 'Không thể thay đổi trạng thái từ "Đã thanh toán". Tạo điều chỉnh mới nếu cần.',
        'cannot_approve_rejected' => 'Không thể duyệt trực tiếp một yêu cầu đã bị từ chối. Vui lòng xem xét cẩn thận.',
    ],
    'validation' => [
        'value_less_than' => 'Giá trị không thể nhỏ hơn :value',
        'value_greater_than' => 'Giá trị không thể lớn hơn :value',
        'value_equal_to' => 'Giá trị phải bằng :value',
        'value_not_equal_to' => 'Giá trị không được bằng :value',
        'value_required' => 'Giá trị là bắt buộc',
        'value_required_if' => 'Giá trị là bắt buộc nếu :other là :value',
        'value_required_unless' => 'Giá trị là bắt buộc trừ khi :other là :value',
        'value_required_with' => 'Giá trị là bắt buộc nếu :values được cung cấp',
        'value_required_without' => 'Giá trị là bắt buộc nếu :values không được cung cấp',
        'value_required_with_all' => 'Giá trị là bắt buộc nếu tất cả :values được cung cấp',
        'value_required_without_all' => 'Giá trị là bắt buộc nếu không có :values nào được cung cấp',
        'value_in' => 'Giá trị phải là một trong các: :values',
        'value_not_in' => 'Giá trị không được là một trong các: :values',
        'value_array' => 'Giá trị phải là một mảng',
        'value_string' => 'Giá trị phải là một chuỗi',
        'value_integer' => 'Giá trị phải là một số nguyên',
        'value_numeric' => 'Giá trị phải là một số',
        'value_boolean' => 'Giá trị phải là đúng hoặc sai',
        'value_date' => 'Giá trị phải là một ngày hợp lệ',
        'value_email' => 'Giá trị phải là một địa chỉ email hợp lệ',
        'value_url' => 'Giá trị phải là một URL hợp lệ',
        'value_ip' => 'Giá trị phải là một địa chỉ IP hợp lệ',    
    ],
];