<?php

declare(strict_types=1);

return [
    'account' => [
        'connect_password' => 'プロキシ接続パスワード',
        'credit' => 'アカウント残高',
        'group' => 'グループ',
        'last_login' => '最終ログイン',
        'level' => 'アカウントレベル',
        'reason' => [
            'expired' => 'プランの有効期限が切れています',
            'normal' => 'アカウントは正常です',
            'overused' => 'この期間の <code>:data</code> GB 制限を超えました。<br/> 制限は <code id="banedTime">:min</code> 分後に解除されます',
            'traffic_exhausted' => 'データが使い果たされました',
            'unknown' => '不明な理由です。ブラウザをリフレッシュしてみてください。問題が続く場合はサポートに連絡してください。',
        ],
        'remain' => '残りデータ',
        'reset' => '{0} データは <code id="restTime">:days</code> 後にリセットされます |{1} データリセットまで :days 日 |[2,*] データリセットまで :days 日',
        'speed_limit' => '速度制限',
        'status' => 'アカウント状態',
        'time' => 'プラン期間',
    ],
    'attribute' => [
        'address' => '所在地',
        'data' => 'データ',
        'ip' => 'IPアドレス',
        'isp' => 'ISP',
        'node' => 'ノード',
    ],
    'bought_at' => '購入日',
    'clients' => 'クライアント',
    'contact' => 'お問い合わせ',
    'coupon' => [
        'discount' => '割引',
        'error' => [
            'expired' => 'クーポンの有効期限が切れています',
            'inactive' => 'クーポンはまだ有効ではありません',
            'minimum' => '最低利用金額は :amount です',
            'overused' => 'クーポンの利用可能回数は :times 回です',
            'run_out' => 'クーポンの利用回数が制限に達しました',
            'services' => '商品は割引対象外です。キャンペーン規約をご確認ください。',
            'unknown' => '無効なクーポン',
            'unmet' => '利用条件を満たしていません',
            'used' => 'クーポンは使用済みです',
            'users' => 'アカウントはキャンペーン対象外です',
            'wait' => ':timeに有効になりますので、お待ちください。',
        ],
        'input' => 'クーポンコードを入力',
    ],
    'current_role' => '現在のロール',
    'error_response' => 'エラーが発生しました。時間をおいて再度お試しください。',
    'home' => [
        'announcement' => 'お知らせ',
        'attendance' => [
            'attribute' => 'チェックイン',
            'disable' => 'チェックイン機能が無効です',
            'done' => '既にチェックイン済みです。明日また来てください！',
            'failed' => 'システムエラー',
            'success' => ':data データを受け取りました',
        ],
        'chat_group' => 'チャットグループ',
        'empty_announcement' => 'お知らせはありません',
        'traffic_logs' => 'データ記録',
        'wechat_push' => 'WeChat通知',
    ],
    'invite' => [
        'attribute' => '招待コード',
        'counts' => '招待コード総数 <code>:num</code>',
        'generate_failed' => '生成失敗: 招待コードの上限に達しました',
        'logs' => '招待履歴',
        'promotion' => '招待コードで登録すると、招待元と被招待者の両方に<mark>:traffic</mark>データが付与されます。被招待者が購入した場合、購入金額の<mark>:referral_percent%</mark>が報酬として付与されます。',
        'tips' => '残招待コード <strong>:num</strong> 個。招待コードは発行後:days日で失効します。',
    ],
    'invitee' => '被招待者',
    'inviter' => '招待者',
    'invoice' => [
        'active_prepaid_question' => '前払いパッケージをすぐにアクティブにしますか?',
        'active_prepaid_tips' => 'アクティブ後:<br>- 現在のパッケージはすぐに失効!<br>- 有効期限は本日から再開!',
        'amount' => '金額',
        'attribute' => '注文',
        'detail' => '購入履歴',
    ],
    'knowledge' => [
        'basic' => '基本',
        'title' => 'ナレッジベース',
    ],
    'menu' => [
        'admin_dashboard' => 'ダッシュボード',
        'help' => 'ヘルプ',
        'home' => 'ホーム',
        'invites' => '招待',
        'invoices' => '請求書',
        'nodes' => 'ノード',
        'profile' => 'プロフィール',
        'promotion' => 'プロモーション',
        'shop' => 'ショップ',
        'tickets' => 'チケット',
    ],
    'node' => [
        'info' => '構成情報',
        'rate' => ':ratio 倍のデータ使用',
        'setting' => 'プロキシ設定',
        'unstable' => 'ノードが不安定/メンテナンス中',
    ],
    'oauth' => [
        'bind' => '連携する',
        'bind_title' => 'ソーシャルアカウントを連携',
        'not_bind' => '未連携',
        'rebind' => '再連携する',
        'unbind' => '連携解除',
    ],
    'pay' => '支払う',
    'payment' => [
        'close_tips' => '<code>:minutes分</code>以内に支払いを完了してください。そうしないと注文は自動的にキャンセルされます。',
        'creating' => '支払いを作成中...',
        'error' => 'チャージ金額が正しくありません',
        'insufficient_balance' => '残高が不足しています。先にチャージしてください。',
        'manual' => [
            'hint' => 'QRコードで支払いをスキャンした後、指示に従って【次へ】を順番にクリックし、最後に【送信】をクリックして支払いを完了してください。',
            'next' => '次のステップ',
            'payment_tips' => '正確な金額を支払ってください。オーバーペイの返金はなく、アンダーペイの場合は差額をチャージ',
            'pre' => '前のステップ',
            'red_packet' => 'Alipayレッドパケット',
            'steps' => [
                'complete' => [
                    'description' => '支払いの手動確認を待っています',
                    'title' => '完了',
                ],
                'notice' => [
                    'description' => '手動支払いの方法',
                    'title' => '注意',
                ],
                'payment' => [
                    'description' => '支払いQRコードを取得',
                    'title' => '支払う',
                ],
                'remark' => [
                    'description' => '手動確認のためにログインアカウントを入力してください',
                    'title' => 'アカウント備考',
                ],
            ],
        ],
        'method' => '決済方法',
        'mobile_tips' => '<strong>モバイルユーザー</strong>: QRコードを長押し -> 画像を保存 -> 支払アプリを開く -> アルバムから読み取る',
        'order_creation' => [
            'failed' => '注文の作成に失敗しました。他の支払い方法をお試しください！',
            'info' => 'ご購入/ご入金の処理は【24時間】以内に行いますので、しばらくお待ちください。',
            'order_limit' => 'この商品は :limit_num 回まで購入可能です。すでに :count 回購入しています。',
            'order_timeout' => '注文がタイムアウトし、未払いのため自動的にキャンセルされました。',
            'payment_disabled' => '注文の作成に失敗しました：システムでオンライン支払い機能が有効になっていません。',
            'pending_order' => '注文の作成に失敗しました：未払いの注文があります。先にそれらの支払いを完了してください。',
            'plan_required' => '追加パッケージを購入する前に、まずプランを購入してください。',
            'price_issue' => '注文の作成に失敗しました：注文の総額が異常です',
            'price_zero' => '注文の作成に失敗しました：注文の総額が0です。オンライン支払いは不要です。',
            'product_unavailable' => '注文の作成に失敗しました：商品は販売終了しました。',
            'success' => '注文が正常に作成されました！',
            'unknown_order' => '不明な注文',
            'unknown_payment' => '不明な支払い方法',
        ],
        'qrcode_tips' => '<strong class="red-600">:software</strong>でQRコードをスキャンしてください',
        'redirect_stripe' => 'Stripeの支払ページに移動中',
    ],
    'purchase' => [
        'completed' => '購入が完了しました！',
        'promotion' => '今すぐサービスを購入！',
        'required' => 'この機能は無料ユーザーには利用できません。まずは',
        'to_unlock' => '購入して解放',
    ],
    'recharge' => 'チャージ',
    'recharge_credit' => '残高チャージ',
    'recharging' => 'チャージ中...',
    'referral' => [
        'link' => '紹介リンク',
        'logs' => '報酬履歴',
        'msg' => [
            'account' => 'アカウントの有効期限が切れています。まずはサービスを購入してください。',
            'applied' => '申請はすでに存在しています。処理完了をお待ちください。',
            'error' => '申請の作成に失敗しました。時間をおいて再度試すか、管理者にお問い合わせください。',
            'unfulfilled' => '出金には :amount が必要です。頑張ってください!',
            'wait' => '管理者による承認をお待ちください。',
        ],
        'total' => '総報酬 :amount(:total 回)。:money 以上になると出金できます。',
    ],
    'registered_at' => '登録日',
    'reset_data' => [
        'action' => 'データリセット',
        'cost' => 'コスト <code>:amount</code>',
        'cost_tips' => 'データリセットには :amount が差し引かれます!',
    ],
    'scan_qrcode' => 'クライアントでQRコードをスキャン',
    'service' => [
        'country_count' => '<code>:num</code> カ国をカバー',
        'node_count' => '<code>:num</code> 本の高品質ノード',
        'unlimited' => '無制限',
    ],
    'shop' => [
        'buy' => '購入',
        'call4help' => 'お問い合わせはチケットにてお願いします',
        'change_amount' => 'チャージ金額',
        'change_amount_help' => 'チャージ金額を入力',
        'conflict' => 'プラン競合',
        'conflict_tips' => '<p>現在の購入は<code>前払いプラン</code>として設定されます</p><p><ol class="text-left"><li>前払いプランは、現在のプラン終了後に自動で開始されます!</li><li>支払い後に手動でプランを開始することができます!</li></ol>',
        'description' => '説明',
        'hot' => '人気',
        'limited' => '限定',
        'pay_credit' => '残高支払い',
        'pay_online' => 'オンライン支払い',
        'price' => '価格',
        'quantity' => '数量',
        'service' => 'サービス',
        'subtotal' => '小計',
        'total' => '合計',
    ],
    'subscribe' => [
        'custom' => 'カスタムサブスクリプション',
        'error' => 'サブスクリプション変更エラー',
        'exchange_warning' => 'サブスクリプション変更により:\n1. 現在のサブはすぐに無効になる\n2. 接続パスワードが変更される',
        'info' => [
            'download' => 'ダウンロードデータ',
            'title' => 'アカウント概要 [リアルタイムではない]',
            'total' => 'プランデータ',
            'upload' => 'アップロードデータ',
        ],
        'link' => 'サブスクリプションリンク',
        'ss_only' => 'SSのみ',
        'ssr_only' => 'SSRのみ(SS含む)',
        'tips' => '警告: このサブスクリプションリンクは個人利用目的でのみ共有可。アカウントの異常なデータ使用を検知し、自動的にBANする可能性があるため、リンクは共有しないでください。',
        'trojan_only' => 'Trojanのみ',
        'v2ray_only' => 'V2Rayのみ',
    ],
    'telegram' => [
        'bind_exists' => 'このアカウントはすでにTelegramアカウントにリンクされています。',
        'bind_missing' => 'ユーザー情報が見つかりません。先にアカウントをリンクしてください。',
        'command' => [
            'bind' => 'あなたの:web_nameアカウントをリンクしてください',
            'intro' => '次のコマンドを使用できます',
            'traffic' => 'データ使用量を確認する',
            'unbind' => 'リンク解除',
            'web_url' => '最新の:web_name URLを取得する',
        ],
        'get_url' => ':web_nameの最新URLは',
        'params_missing' => 'パラメーターに誤りがあります。メールアドレスを含めて再送信してください。',
        'ticket_missing' => 'チケットが存在しません',
        'ticket_reply' => 'チケット #`:id` への返信が成功しました',
        'traffic_query' => 'データ使用量の確認',
        'user_missing' => 'ユーザーが存在しません',
    ],
    'ticket' => [
        'attribute' => 'チケット',
        'close_msg' => 'チケット: ID :id がユーザーによって閉じられました',
        'close_tips' => 'このチケットを閉じますか?',
        'content_placeholder' => '問題を詳細に説明して助けを得ることができるようにしてください',
        'error' => '不明なエラーです。スタッフに通知してください。',
        'new' => '新規チケット',
        'online_hour' => 'オンライン時間',
        'reply' => '返信',
        'reply_confirm' => 'チケットへの返信を確定しますか?',
        'reply_placeholder' => 'ここにコメントを入力...',
        'service_hours' => '営業時間',
        'service_tips' => 'ご連絡は<code>1つの</code>方法のみでお願いします。<br>重複したリクエストは対応を遅らせます。',
        'submit_tips' => 'チケットを提出しますか?',
        'title_placeholder' => '簡単に問題を説明してください',
    ],
    'traffic_logs' => [
        'daily' => '今月のデータ使用',
        'hourly' => '今日のデータ使用',
        'tips' => '：トラフィックのデータは遅延を提供します。',
    ],
    'tutorials' => 'チュートリアル',
    'withdraw' => '出金',
    'withdraw_at' => '出金日',
    'withdraw_commission' => '報酬出金',
    'withdraw_logs' => '出金記録',
];
