<?php

declare(strict_types=1);

return [
    'action' => [
        'add_item' => ':attribute を追加',
        'edit_item' => ':attribute を編集',
    ],
    'aff' => [
        'apply_counts' => '合計 <code>:num</code> 引き出し申請',
        'commission_counts' => 'この申請には合計 <code>:num</code> の注文が含まれます',
        'commission_title' => '申請詳細',
        'counts' => '合計 <code>:num</code> リベート履歴',
        'rebate_title' => 'リベート履歴',
        'referral' => '紹介リベート',
        'title' => '引き出し申請リスト',
    ],
    'article' => [
        'category_hint' => '同じカテゴリは一緒にグループ化されます',
        'counts' => '合計 <code>:num</code> 記事',
        'logo_placeholder' => 'またはロゴのURLを入力してください',
        'title' => '記事リスト',
        'type' => [
            'announcement' => 'お知らせ',
            'knowledge' => '記事',
        ],
    ],
    'clear' => 'クリア',
    'clone' => 'クローン',
    'confirm' => [
        'continues' => 'この操作を続行しますか？',
        'delete' => [0 => ':attribute を削除してもよろしいですか【', 1 => '】？'],
        'export' => 'すべてをエクスポートしてもよろしいですか？',
    ],
    'coupon' => [
        'counts' => '合計 <code>:num</code> クーポン',
        'created_days_hint' => '登録後 <code>:days</code> 日',
        'discount' => '割引',
        'export_title' => 'クーポンエクスポート',
        'groups_hint' => '選択されたユーザーグループのみ使用可能',
        'info_title' => 'クーポン情報',
        'levels_hint' => '選択されたユーザーレベルのみ使用可能',
        'limit_hint' => '条件は <strong>AND</strong> 関係にあります。適切に使用してください。',
        'minimum_hint' => '支払いが<strong>:num</strong>を超える場合のみ使用可能',
        'name_hint' => '表示用',
        'newbie' => [
            'created_days' => 'アカウント年齢',
            'first_discount' => '初回割引',
            'first_order' => '初回注文',
        ],
        'priority_hint' => '適格な最高優先度のクーポンが最初に使用されます。最大255',
        'services_blacklist_hint' => 'ブラックリストの商品には使用不可、未使用の場合は空白のまま',
        'services_placeholder' => '商品IDを入力し、Enterキーを押します',
        'services_whitelist_hint' => 'ホワイトリストの商品にのみ使用可能、未使用の場合は空白のまま',
        'single_use' => '一度きりの使用',
        'sn_hint' => '空白の場合、8桁のランダムコード',
        'title' => 'クーポンリスト',
        'type' => [
            'charge' => 'チャージ',
            'discount' => '割引',
            'voucher' => 'バウチャー',
        ],
        'type_hint' => '割引：金額を控除、割引率：パーセンテージ割引、チャージ：残高に追加',
        'used_hint' => '各ユーザーはこのクーポンを最大<strong>:num</strong>回使用できます',
        'user_whitelist_hint' => 'ホワイトリストのユーザーは使用可能、未使用の場合は空白のまま',
        'users_blacklist_hint' => 'ブラックリストのユーザーは使用不可、未使用の場合は空白のまま',
        'users_placeholder' => 'ユーザーIDを入力し、Enterキーを押します',
        'value' => '{1} ➖ :num|{2} :num% 割引|{3} ➕ :num',
        'value_hint' => '範囲は1％から99％',
    ],
    'creating' => '追加中...',
    'dashboard' => [
        'abnormal_users' => '過去1時間以内に異常なトラフィックのユーザー',
        'active_days_users' => '過去 :days 日間のアクティブユーザー',
        'available_users' => '有効ユーザー数',
        'credit' => '総残高',
        'current_month_traffic_consumed' => '今月のデータ使用量',
        'days_traffic_consumed' => '過去 :days 日間のデータ使用量',
        'expiring_users' => '間もなく有効期限が切れるユーザー',
        'inactive_days_users' => '過去 :days 日間非アクティブなユーザー',
        'maintaining_nodes' => 'メンテナンス中のノード',
        'nodes' => 'ノード数',
        'online_orders' => 'オンライン決済注文数',
        'online_users' => '現在オンラインのユーザー',
        'orders' => '総注文数',
        'overuse_users' => 'データ使用量が90％を超えるユーザー',
        'paid_users' => '有料ユーザー数',
        'succeed_orders' => '支払い成功の注文数',
        'users' => '総ユーザー数',
        'withdrawing_commissions' => '引き出し待ちのコミッション',
        'withdrawn_commissions' => '引き出されたコミッション',
    ],
    'end_time' => '終了時間',
    'goods' => [
        'counts' => '合計 <code>:num</code> 商品',
        'info' => [
            'available_date_hint' => '期限が切れると、合計データから対応するデータが自動的に控除されます',
            'desc_placeholder' => '簡単な商品説明',
            'limit_num_hint' => 'ユーザーごとの購入回数の上限、0は無制限',
            'list_hint' => '各行の内容は<code>&lt;li&gt;</code>で始まり<code>&lt;/li&gt;</code>で終わります',
            'list_placeholder' => 'カスタムコンテンツを追加',
            'period_hint' => 'プランのデータ許容量はN日ごとにリセットされます',
            'type_hint' => 'プランはアカウントの有効期限に影響し、パッケージはデータのみを控除し、有効期限には影響しません',
        ],
        'sell_and_used' => '使用 / 販売',
        'status' => [
            'no' => '販売停止',
            'yes' => '販売中',
        ],
        'title' => '商品リスト',
        'type' => [
            'package' => 'データパッケージ',
            'plan' => 'サブスクリプションプラン',
            'top_up' => 'チャージ',
        ],
    ],
    'hint' => 'ヒント',
    'logs' => [
        'ban' => [
            'ban_time' => '禁止時間',
            'last_connect_at' => '最終接続時間',
            'reason' => '理由',
            'time' => '期間',
            'title' => 'ユーザー禁止履歴',
        ],
        'callback' => 'コールバックログ <small>(支払い)</small>',
        'counts' => '合計 <code>:num</code> 記録',
        'credit_title' => '残高変更履歴',
        'ip_monitor' => 'オンラインIP監視 <small>リアルタイム2分</small>',
        'notification' => 'メール送信履歴',
        'order' => [
            'is_coupon' => 'クーポン使用',
            'is_expired' => '期限切れ',
            'title' => '注文リスト',
            'update_conflict' => '更新失敗：注文の競合',
        ],
        'rule' => [
            'clear_all' => 'すべての記録をクリア',
            'clear_confirm' => 'すべてのトリガー記録をクリアしてもよろしいですか？',
            'created_at' => 'トリガー時間',
            'name' => 'トリガールール名',
            'reason' => 'トリガー理由',
            'tag' => '✅ 許可されていないコンテンツへのアクセス',
            'title' => 'ルールトリガー記録',
        ],
        'subscribe' => 'サブスクリプションリスト',
        'user_data_modify_title' => 'データ変更履歴',
        'user_ip' => [
            'connect' => '接続IP',
            'title' => 'ユーザーオンラインIPリスト <small>直近10分</small>',
        ],
        'user_traffic' => [
            'choose_node' => 'ノードを選択',
            'title' => 'データ使用履歴',
        ],
    ],
    'marketing' => [
        'counts' => '合計 <code>:num</code> メール',
        'email' => [
            'ever_paid' => '支払い済み',
            'expired_date' => '期限切れの日付',
            'filters' => 'フィルター',
            'loading_statistics' => '統計情報を読み込み中...',
            'never_paid' => '支払いなし',
            'paid_servicing' => '有料サービス',
            'previously_paid' => '以前に支払い済み',
            'recent_traffic_abnormal' => '直近1時間のトラフィック異常',
            'recently_active' => '最近アクティブ',
            'targeted_users_count' => 'ターゲットユーザー数',
            'traffic_usage_over' => 'トラフィック使用量がN%を超えました',
            'will_expire_date' => '期限が切れる日付',
        ],
        'email_send' => 'メール送信',
        'error_message' => 'エラーメッセージ',
        'processed' => 'リクエストが処理されました',
        'push_send' => '通知送信',
        'send_status' => '送信状態',
        'send_time' => '送信時間',
        'targeted_users_not_found' => 'ターゲットユーザーが見つかりません',
        'unknown_sending_type' => '未知の送信タイプ',
    ],
    'massive_export' => '一括エクスポート',
    'menu' => [
        'analysis' => [
            'accounting' => '会計',
            'attribute' => 'データ分析',
            'node_flow' => 'ノードトラフィック分析',
            'site_flow' => 'サイトトラフィック',
            'user_flow' => 'ユーザートラフィック',
        ],
        'customer_service' => [
            'article' => '記事管理',
            'attribute' => 'カスタマーサービスシステム',
            'marketing' => 'メッセージの配信',
            'ticket' => 'サポートチケット',
        ],
        'dashboard' => 'ダッシュボード',
        'log' => [
            'attribute' => 'ログシステム',
            'notify' => '通知履歴',
            'online_logs' => 'オンライン履歴',
            'online_monitor' => 'オンラインモニタリング',
            'payment_callback' => '支払いコールバック',
            'service_ban' => '禁止履歴',
            'system' => 'システムログ',
            'traffic' => 'データ使用',
            'traffic_flow' => 'データ変動',
        ],
        'node' => [
            'attribute' => 'ノードシステム',
            'auth' => 'ノード認証',
            'cert' => '証明書リスト',
            'list' => 'ノード管理',
        ],
        'promotion' => [
            'attribute' => 'プロモーション',
            'invite' => '招待管理',
            'rebate_flow' => 'リベート履歴',
            'withdraw' => '引き出し管理',
        ],
        'rbac' => [
            'attribute' => '権限システム',
            'permission' => '権限管理',
            'role' => '役割リスト',
        ],
        'rule' => [
            'attribute' => '監査ルール',
            'group' => 'ルールグループ',
            'list' => 'ルールリスト',
            'trigger' => 'トリガー履歴',
        ],
        'setting' => [
            'attribute' => 'システム設定',
            'email_suffix' => 'メールフィルタ管理',
            'system' => 'システム設定',
            'universal' => '共通設定',
        ],
        'shop' => [
            'attribute' => '商品システム',
            'coupon' => 'クーポン管理',
            'goods' => '商品管理',
            'order' => '商品注文',
        ],
        'tools' => [
            'analysis' => 'ログ分析',
            'attribute' => 'ツールセット',
            'convert' => 'フォーマット変換',
            'decompile' => '逆コンパイル',
            'import' => 'データインポート',
        ],
        'user' => [
            'attribute' => 'ユーザーシステム',
            'credit_log' => '残高変動履歴',
            'group' => 'ユーザーグループ',
            'list' => 'ユーザー管理',
            'oauth' => 'サードパーティ認証',
            'subscribe' => 'サブスクリプション管理',
        ],
    ],
    'minute' => '分',
    'monitor' => [
        'daily_chart' => '日次トラフィック使用量',
        'hint' => '<strong>ヒント：</strong> データがない場合はスケジュールタスクを確認してください。',
        'monthly_chart' => '月次トラフィック使用量',
        'node' => 'ノードトラフィック',
        'user' => 'ユーザートラフィック',
    ],
    'no' => 'いいえ',
    'node' => [
        'auth' => [
            'counts' => '合計 <code>:num</code> 認証記録',
            'deploy' => [
                'attribute' => 'バックエンドデプロイ',
                'command' => 'コマンド',
                'real_time_logs' => 'リアルタイムログ',
                'recent_logs' => '最近のログ',
                'restart' => '再起動',
                'same' => '上記と同じ',
                'start' => '開始',
                'status' => '状態',
                'stop' => '停止',
                'title' => ':type_label バックエンドのデプロイ',
                'trojan_hint' => 'ノード名を入力し、対応するIPに解決してください<a href=":url" target="_blank">。',
                'uninstall' => 'アンインストール',
                'update' => '更新',
            ],
            'empty' => '認証生成が必要なノードはありません',
            'generating_all' => 'すべてのノードの認証キーを生成してもよろしいですか？',
            'reset_auth' => '認証キーをリセット',
            'title' => 'ノード認証リスト<small>WEBAPI</small>',
        ],
        'cert' => [
            'counts' => '合計 <code>:num</code> ドメイン証明書',
            'key_placeholder' => '証明書のKEY値。空白でも可。VNET-V2Rayバックエンドは自動発行をサポート。',
            'pem_placeholder' => '証明書のPEM値。空白でも可。VNET-V2Rayバックエンドは自動発行をサポート。',
            'title' => 'ドメイン証明書リスト<small>（V2Rayノードの偽装ドメイン）</small>',
        ],
        'connection_test' => '接続テスト',
        'counts' => '合計 <code>:num</code> ノード',
        'info' => [
            'additional_ports_hint' => '有効にする場合は、サーバーの<span class="red-700"><a href="javascript:showTnc();">additional_ports</a></span>を設定してください。',
            'basic' => '基本情報',
            'data_rate_hint' => '例：0.1は100Mを10Mとしてカウントすることを意味します。5は100Mを500Mとしてカウントします。',
            'ddns_hint' => '動的IPノードには<a href="https://github.com/NewFuture/DDNS" target="_blank">DDNS設定</a>が必要です。このタイプのノードはドメイン名を通じて接続テストが行われます。',
            'detection' => [
                'all' => '両方',
                'hint' => '30〜60分ごとにランダムにチェック',
                'icmp' => 'ICMPのみ',
                'tcp' => 'TCPのみ',
            ],
            'display' => [
                'all' => '完全に可視',
                'hint' => 'サブスクリプション/ノードリストに表示されるかどうか',
                'invisible' => '完全に不可視',
                'node' => '【ノード】ページにのみ表示',
                'sub' => '【サブスクリプション】にのみ表示',
            ],
            'domain_hint' => 'システム設定でDDNSモードが有効になっている場合、ドメイン名とIPは自動的に更新されます。ドメインレジストラのウェブサイトで情報を編集する必要はありません。',
            'domain_placeholder' => 'サーバードメイン、入力されている場合は優先的に使用されます',
            'extend' => '拡張情報',
            'hint' => '<strong>注意：</strong> 自動生成された<code>ID</code>はShadowsocksRの<code>node_id</code>およびV2Rayの<code>nodeId</code>です。',
            'ipv4_hint' => '複数のIPは英語のコンマで区切ります。例: 1.1.1.1,8.8.8.8',
            'ipv4_placeholder' => 'サーバーのIPv4アドレス',
            'ipv6_hint' => '複数のIPは英語のコンマで区切ります。例: 1.1.1.1,8.8.8.8',
            'ipv6_placeholder' => 'サーバーのIPv6アドレス',
            'level_hint' => 'レベル：0 - レベル制限なし、すべて可視。',
            'obfs_param_hint' => 'obfsが[plain]でない場合、トラフィック偽装のためのパラメータを入力します；&#13;&#10;obfsが[http_simple]の場合、ポート80を推奨します；&#13;&#10;obfsが[tls]の場合、ポート443を推奨します。',
            'push_port_hint' => '必須。サーバーファイアウォールでこのポートが開かれていることを確認してください。そうしないと、メッセージプッシュが異常になります。',
            'single_hint' => '推奨ポートは80または443。バックエンドには<br>厳格モード設定が必要です：ユーザーのポートは接続できず、指定されたポートのみで接続できます（<a href="javascript:showPortsOnlyConfig();">設定方法</a>）',
            'v2_cover' => [
                'dtls' => 'DTLS1.2データパケット',
                'http' => 'HTTPデータストリーム',
                'none' => '偽装なし',
                'srtp' => 'ビデオ通話データ (SRTP)',
                'utp' => 'BTダウンロードデータ (uTP)',
                'wechat' => 'WeChatビデオ通話',
                'wireguard' => 'WireGuardデータパケット',
            ],
            'v2_host_hint' => 'http偽装の場合、複数のドメインはコンマで区切りますが、WebSocketは単一のドメインのみを許可します。',
            'v2_method_hint' => 'WebSocket伝送プロトコルは「none」暗号化方式を使用しないでください。',
            'v2_net_hint' => 'WebSocket用にTLSを有効にしてください。',
            'v2_tls_provider_hint' => '異なるバックエンドには異なる設定があります：',
        ],
        'proxy_info' => '*Shadowsocksプロトコルと互換性があります',
        'proxy_info_hint' => '互換性のために、サーバー構成でプロトコルとobfsに<span class="red-700">_compatible</span>を追加してください。',
        'refresh_geo' => '地理情報を更新',
        'refresh_geo_all' => 'すべてのノード地理情報を更新',
        'reload' => 'バックエンドをリロード',
        'reload_all' => 'すべてのバックエンドをリロード',
        'reload_confirm' => 'ノードのバックエンドをリロードしてもよろしいですか？',
        'traffic_monitor' => 'トラフィック統計',
    ],
    'oauth' => [
        'counts' => '合計 <code>:num</code> 認証記録',
        'title' => 'サードパーティ認証',
    ],
    'optional' => 'オプション',
    'permission' => [
        'counts' => '合計 <code>:num</code> 権限行動',
        'description_hint' => '説明を入力、例：【システムA】Aの編集',
        'name_hint' => 'ルート名を入力、例：admin.permission.create,update',
        'title' => '権限行動リスト',
    ],
    'query' => 'クエリ',
    'report' => [
        'annually_accounting' => '年次取引',
        'annually_site_flow' => '年次トラフィック消費',
        'avg_traffic_30d' => '過去30日間の平均日次トラフィック',
        'current_month' => '今月',
        'current_year' => '今年',
        'daily_accounting' => '日次取引',
        'daily_distribution' => '日次分布',
        'daily_site_flow' => '日次トラフィック消費',
        'daily_traffic' => '日次トラフィック',
        'hourly_traffic' => '毎時トラフィック',
        'last_month' => '先月',
        'last_year' => '去年',
        'monthly_accounting' => '月次取引',
        'monthly_site_flow' => '月次トラフィック消費',
        'select_hourly_date' => '時間別の日付を選択',
        'sum_traffic_30d' => '過去30日間のトラフィック比率',
        'today' => '今日',
    ],
    'require' => '必須',
    'role' => [
        'counts' => '合計 <code>:num</code> 権限ロール',
        'description_hint' => '表示名、例：管理者',
        'modify_admin_error' => 'スーパ管理者を変更しないでください！',
        'name_hint' => 'ユニークな識別名、例：Admin',
        'permissions_all' => 'すべての権限',
        'title' => '権限ロールリスト',
    ],
    'rule' => [
        'counts' => '合計 <code>:num</code> ルール',
        'group' => [
            'counts' => '合計 <code>:num</code> グループ',
            'title' => 'ルールグループ',
            'type' => [
                'off' => 'ブロック',
                'on' => '許可',
            ],
        ],
        'title' => 'ルールリスト',
        'type' => [
            'domain' => 'ドメイン',
            'ip' => 'IP',
            'protocol' => 'プロトコル',
            'reg' => '正規表現',
        ],
    ],
    'select_all' => 'すべて選択',
    'selected_hint' => '割り当てられたルールはここで検索できます',
    'set_to' => ':attributeに設定',
    'setting' => [
        'common' => [
            'connect_nodes' => '関連ノード数',
            'set_default' => 'デフォルトに設定',
            'title' => '共通設定',
        ],
        'email' => [
            'black' => 'ブラックリスト',
            'rule' => 'ルール',
            'tail' => 'メールドメイン',
            'tail_placeholder' => 'メールドメインを入力してください',
            'title' => 'メールフィルタリスト <small>（特定のメールドメインの登録をブロックするため）</small>',
            'white' => 'ホワイトリスト',
        ],
        'no_permission' => 'パラメータを変更する権限がありません！',
        'system' => [
            'account' => 'アカウント設定',
            'auto_job' => '自動タスク',
            'check_in' => 'チェックインシステム',
            'extend' => '拡張機能',
            'menu' => 'メニュー',
            'node' => 'ノード設定',
            'notify' => '通知システム',
            'other' => 'ロゴ|カスタマーサービス|統計',
            'payment' => '支払いシステム',
            'promotion' => 'プロモーションシステム',
            'title' => 'システム設定',
            'web' => 'ウェブ一般',
        ],
    ],
    'sort_asc' => 'ソート値が大きいほど優先度が高くなります',
    'start_time' => '開始時間',
    'system' => [
        'AppStore_id' => 'Appleアカウント',
        'AppStore_password' => 'Appleパスワード',
        'account_expire_notification' => 'アカウント有効期限通知',
        'active_account' => [
            'after' => '登録後に有効化',
            'before' => '登録前に有効化',
        ],
        'active_times' => 'アカウント有効化回数',
        'admin_invite_days' => '管理者-招待コード有効期',
        'aff_salt' => '招待リンク ユーザーID暗号化',
        'alipay_qrcode' => 'Alipay QRコード',
        'auto_release_port' => 'ポート回収メカニズム',
        'bark_key' => 'Barkデバイスキー',
        'captcha' => [
            'geetest' => 'Geetest',
            'hcaptcha' => 'hCaptcha',
            'recaptcha' => 'Google reCaptcha',
            'standard' => '標準Captcha',
            'turnstile' => 'Turnstile',
        ],
        'captcha_key' => 'Captchaキー',
        'captcha_secret' => 'Captchaシークレット/ID',
        'codepay_id' => 'CodePay ID',
        'codepay_key' => '通信キー',
        'codepay_url' => 'リクエストURL',
        'data_anomaly_notification' => 'データ異常通知',
        'data_exhaust_notification' => 'データ使用量通知',
        'ddns_key' => 'DNSプロバイダーキー',
        'ddns_mode' => 'DDNSモード',
        'ddns_secret' => 'DNSプロバイダーシークレット',
        'default_days' => '初期有効期限',
        'default_traffic' => '初期データ量',
        'demo_restriction' => 'デモ環境では、この設定の変更は許可されていません！',
        'detection_check_times' => 'ブロック検出通知',
        'dingTalk_access_token' => 'DingTalkカスタムボット Access Token',
        'dingTalk_secret' => 'DingTalkカスタムボット シークレット',
        'epay_key' => 'ePayキー',
        'epay_mch_id' => 'ePay商人ID',
        'epay_url' => 'インターフェースURL',
        'expire_days' => '有効期限警告しきい値',
        'f2fpay_app_id' => 'アプリID',
        'f2fpay_private_key' => 'アプリプライベートキー',
        'f2fpay_public_key' => 'Alipayパブリックキー',
        'forbid' => [
            'china' => '中国を禁止',
            'mainland' => '中国本土を禁止',
            'oversea' => '海外を禁止',
        ],
        'forbid_mode' => 'アクセス禁止モード',
        'hint' => [
            'AppStore_id' => 'iOSソフトウェア設定ガイドで使用するAppleアカウント',
            'AppStore_password' => 'iOSソフトウェア設定ガイドで使用するAppleパスワード',
            'account_expire_notification' => 'ユーザーにアカウントの有効期限を通知',
            'active_times' => '24時間以内にメールでアカウントを有効化できる回数',
            'admin_invite_days' => '管理者が生成する招待コードの有効期限',
            'aff_salt' => '空白の場合、招待リンクにユーザーIDが表示されます。任意の英数字を入力すると、ユーザーIDが暗号化されます。',
            'auto_release_port' => '封鎖/有効期限切れ <code>'.config('tasks.release_port').'</code> 日後に自動的にポートを解放',
            'bark_key' => 'iOSデバイスにBarkアプリをインストールし、URLの後に続く一連の文字列を入力。Barkを有効にするには、この値を必ず入力してください。',
            'captcha_key' => '設定ガイドは<a href="https://proxypanel.gitbook.io/wiki/captcha" target="_blank">こちら</a>を参照してください。',
            'data_anomaly_notification' => '1時間以内にデータ使用量が異常な閾値を超えた場合、管理者に通知します。',
            'data_exhaust_notification' => 'ユーザーにデータ使用量が尽きる前に通知します。',
            'ddns_key' => '設定ガイドは<a href="https://proxypanel.gitbook.io/wiki/ddns" target="_blank">こちら</a>を参照してください。',
            'ddns_mode' => 'ノードの「ドメイン、IPv4、IPv6」を追加/編集/削除するときに、対応する内容をDNSプロバイダーに自動更新します。',
            'default_days' => 'ユーザー登録時のデフォルトのアカウント有効期限。0の場合は当日有効期限。',
            'default_traffic' => 'ユーザー登録時のデフォルトのデータ量。',
            'detection_check_times' => 'ノードがN回通知された後に自動的にオフラインになります。0または空白の場合は制限なし、最大12回。',
            'dingTalk_access_token' => 'DingTalkカスタムボットの<a href=https://open.dingtalk.com/document/group/custom-robot-access#title-jfe-yo9-jl2 target=_blank>アクセスToken</a>を参照してください。',
            'dingTalk_secret' => 'オプションです。ボットの[サイン]を有効にした場合は必須項目です。',
            'expire_days' => '【アカウント有効期限通知】の開始閾値。毎日ユーザーに通知します。',
            'f2fpay_app_id' => 'アプリのAPPID。',
            'f2fpay_private_key' => '生成された秘密鍵ソフトウェアから得られるアプリの秘密鍵。',
            'f2fpay_public_key' => '注意：これはアプリの公開鍵ではありません。',
            'forbid_mode' => '指定された地域のIPをブロックします。ブロックされていない地域は通常アクセスできます。',
            'iYuu_token' => 'IYUUを有効にするには、この値を必ず入力してください（<a href=https://iyuu.cn target=_blank>IYUUトークンを申請</a>）。',
            'invite_num' => 'ユーザーがデフォルトで持っている招待数。',
            'is_activate_account' => '有効にすると、ユーザーはメールでアカウントを有効化する必要があります。',
            'is_ban_status' => '(慎重に)アカウント全体を禁止すると、アカウントのすべてのデータがリセットされ、ユーザーはログインできなくなります。無効にした場合、ユーザーの代理のみを禁止します。',
            'is_captcha' => '有効にすると、ログイン/登録時にCaptcha認証が必要です。',
            'is_checkin' => 'ログイン時にデータ範囲に基づいてランダムにデータを取得します。',
            'is_clear_log' => '（推奨）有効にすると、自動的に不要なログをクリアします。',
            'is_custom_subscribe' => '有効にすると、サブスクリプション情報の上部に有効期限と残りのデータが表示されます（特定のクライアントのみサポート）。',
            'is_email_filtering' => 'ブラックリスト：ユーザーはブラックリスト外の任意のメールアドレスで登録できます。ホワイトリスト：ユーザーはホワイトリスト内のメールアドレスでのみ登録できます。',
            'is_forbid_robot' => 'ロボット、クローラー、プロキシがサイトにアクセスした場合、404エラーを返します。',
            'is_free_code' => '無効にすると、無料の招待コードは表示されません。',
            'is_rand_port' => 'ユーザー登録時、ユーザー追加時にランダムなポートを生成します。',
            'is_register' => '無効にすると、登録できません。',
            'is_subscribe_ban' => '有効にすると、ユーザーのサブスクリプションリンクリクエストが設定された閾値を超えた場合、自動的に禁止されます。',
            'is_traffic_ban' => '1時間以内にデータ使用量が異常な閾値を超えた場合、自動的にアカウントを禁止します（代理のみ禁止）。',
            'maintenance_content' => 'カスタムメンテナンス情報。',
            'maintenance_mode' => '有効にすると、ユーザーはメンテナンスページにリダイレクトされます。管理者は<a href=\'javascript:(0)\'>:url</a>でログインできます。',
            'maintenance_time' => 'メンテナンスページのカウントダウンに使用されます。',
            'min_port' => 'ポート範囲：1000〜65535。',
            'node_blocked_notification' => '毎時ノードのブロックを検出し、管理者に通知します。',
            'node_daily_notification' => '各ノードの前日のデータ使用量を報告します。',
            'node_offline_notification' => '10分ごとにノードのオフライン状況を検出し、管理者に通知します。',
            'node_renewal_notification' => 'ノードの有効期限が切れる7日前、3日前、1日前に管理者に更新をリマインドします。',
            'oauth_path' => 'まず.ENVにプラットフォームを追加し、有効にしてください。',
            'offline_check_times' => '24時間以内にN回通知された後、通知を停止します。',
            'password_reset_notification' => '有効にすると、ユーザーはパスワードをリセットできます。',
            'paybeaver_app_id' => '<a href="https://merchant.paybeaver.com/" target="_blank">商人センター</a> -> 開発者 -> App ID',
            'paybeaver_app_secret' => '<a href="https://merchant.paybeaver.com/" target="_blank">商人センター</a> -> 開発者 -> App Secret',
            'payjs_mch_id' => '情報は<a href="https://payjs.cn/dashboard/member" target="_blank">このページ</a>で取得できます。',
            'payment_confirm_notification' => 'ユーザーが手動支払いを行った後、管理者に注文を処理するよう通知します。',
            'payment_received_notification' => 'ユーザーが支払いを完了した後、注文ステータスを通知します。',
            'pushDeer_key' => 'PushDeerを有効にするには、この値を必ず入力してください（<a href=https://www.pushdeer.com/official.html target=_blank>Push Keyを申請</a>）。',
            'pushplus_token' => 'PushPlusを有効にするには、この値を必ず入力してください（<a href=https://www.pushplus.plus/push1.html target=_blank>Tokenを申請</a>）。',
            'rand_subscribe' => '有効にすると、サブスクリプション時にノード情報がランダムに返されます。それ以外の場合はノードリストの順序に従って返されます。',
            'redirect_url' => '監査ルールがトリガーされた場合、リクエストがブロックされ、このURLにリダイレクトされます。',
            'referral_money' => '引き出し可能な最小金額。',
            'referral_percent' => '招待リンクから登録されたアカウントの各注文のリベート割合。',
            'referral_status' => '無効にすると、ユーザーには表示されませんが、既存のデータには影響しません。',
            'referral_traffic' => '招待リンクまたは招待コードを使用して登録すると、対応するデータ量が贈られます。',
            'referral_type' => 'モードを切り替えた後、古いデータは変更されず、新しいリベートは新しいモードに基づいて計算されます。',
            'register_ip_limit' => '24時間以内に同一IPで許可される登録数。0または空白の場合は無制限。',
            'reset_password_times' => '24時間以内にメールでパスワードをリセットできる回数。',
            'reset_traffic' => 'ユーザーは購入したプランの日付に基づいて自動的にデータがリセットされます。',
            'server_chan_key' => 'ServerChanを有効にするには、この値を必ず入力してください（<a href="https://sct.ftqq.com/r/2626" target="_blank">SCKEYを申請</a>）。',
            'standard_currency' => 'ウェブサイトで使用されるデフォルトの通貨。',
            'subject_name' => '支払いチャネルで表示される商品のタイトル。',
            'subscribe_ban_times' => '24時間以内にサブスクリプションリンクリクエストの回数制限。',
            'subscribe_domain' => '（推奨）パネルドメインがDNS汚染された場合に備えて、http://またはhttps://を含める必要があります。',
            'subscribe_max' => 'クライアントがサブスクリプション時に取得するノード数。0または空白の場合はすべてのノードを返します。',
            'telegram_token' => 'TelegramボットのTOKENを<a href=https://t.me/BotFather target=_blank>BotFather</a>から取得してください。',
            'tg_chat_token' => 'TGチャットを有効にするには、この値を必ず入力してください（<a href=https://t.me/realtgchat_bot target=_blank>Tokenを申請</a>）。',
            'ticket_closed_notification' => 'チケットがクローズされたときにユーザーに通知します。',
            'ticket_created_notification' => '新しいチケットが作成されたときに管理者またはユーザーに通知します。作成者に依存します。',
            'ticket_replied_notification' => 'チケットに返信があったときに相手に通知します。',
            'traffic_ban_time' => '異常が発生したためにユーザー/サブスクリプションが禁止された期間。期限が切れると自動的に解除されます。',
            'traffic_ban_value' => '1時間以内にこの値を超えた場合、自動的にアカウントが禁止されます。',
            'traffic_limit_time' => '再度チェックインできるまでの時間間隔。',
            'traffic_warning_percent' => '【データ使用量通知】の開始閾値。毎日ユーザーに通知します。',
            'user_invite_days' => 'ユーザーが生成する招待コードの有効期限。',
            'username_type' => 'ユーザーアカウントのデフォルトのタイプ。デフォルトはメールアドレスです。',
            'v2ray_tls_provider' => 'ノードの設定がこのTLS設定を上書きします。',
            'web_api_url' => '例：'.config('app.url'),
            'webmaster_email' => 'エラーメッセージに表示される管理者の連絡先メールアドレス。',
            'website_analytics' => 'ウェブサイトの分析JavaScriptコード。',
            'website_callback_url' => 'DNS汚染による支払いコールバックの失敗を防ぐために、http://またはhttps://を含める必要があります。',
            'website_customer_service' => 'カスタマーサービスのJavaScriptコード。',
            'website_name' => 'メール送信時に表示されるウェブサイト名。',
            'website_security_code' => '空白でない場合、<a href=":url" target="_blank">セキュリティエントリ</a>にセキュリティコードを追加してアクセスする必要があります。',
            'website_url' => 'パスワードリセットやオンライン支払いに必要なURL。',
            'wechat_aid' => 'WeChatの<a href=https://work.weixin.qq.com/wework_admin/frame#apps target=_blank>アプリ管理</a>で作成されたアプリのAgentId。',
            'wechat_cid' => 'WeChatの<a href=https://work.weixin.qq.com/wework_admin/frame#profile target=_blank>企業情報</a>から取得した企業ID。',
            'wechat_encodingAESKey' => 'アプリ管理 -> アプリ設定 -> API受信設定 -> EncodingAESKey。',
            'wechat_secret' => 'アプリのシークレット（企業WeChatをダウンロードする必要があります）。',
            'wechat_token' => 'アプリ管理 -> アプリ設定 -> API受信設定 -> TOKEN。URL設定：:url。',
        ],
        'iYuu_token' => 'IYUUトークン',
        'invite_num' => 'デフォルト招待数',
        'is_AliPay' => 'Alipay支払い',
        'is_QQPay' => 'QQウォレット',
        'is_WeChatPay' => 'WeChat支払い',
        'is_activate_account' => 'アカウント有効化',
        'is_ban_status' => '有効期限自動禁止',
        'is_captcha' => 'Captchaモード',
        'is_checkin' => 'チェックインデータ追加',
        'is_clear_log' => 'ログ自動クリア',
        'is_custom_subscribe' => 'カスタムサブスクリプション',
        'is_email_filtering' => 'メールフィルタリング',
        'is_forbid_robot' => 'ロボットアクセス禁止',
        'is_free_code' => '無料招待コード',
        'is_invite_register' => '招待登録',
        'is_otherPay' => 'カスタム支払い',
        'is_rand_port' => 'ランダムポート',
        'is_register' => 'ユーザー登録',
        'is_subscribe_ban' => '異常サブスクリプションリクエスト自動禁止',
        'is_traffic_ban' => '異常データ使用自動禁止',
        'maintenance_content' => 'メンテナンス内容',
        'maintenance_mode' => 'メンテナンスモード',
        'maintenance_time' => 'メンテナンス終了時間',
        'min_port' => 'ポート範囲',
        'min_rand_traffic' => 'データ範囲',
        'node_blocked_notification' => 'ノードブロック通知',
        'node_daily_notification' => 'ノード使用レポート',
        'node_offline_notification' => 'ノードオフライン通知',
        'node_renewal_notification' => 'ノード更新通知',
        'notification' => [
            'channel' => [
                'bark' => 'Bark',
                'dingtalk' => 'DingTalk',
                'email' => 'メール',
                'iyuu' => 'IYUU',
                'pushdeer' => 'PushDeer',
                'pushplus' => 'PushPlus',
                'serverchan' => 'ServerChan',
                'site' => 'サイト内通知',
                'telegram' => 'Telegram',
                'tg_chat' => 'TGチャット',
                'wechat' => '企業WeChat',
            ],
            'send_test' => 'テストメッセージを送信',
            'test' => [
                'content' => 'テスト内容',
                'success' => '送信が成功しました。携帯電話でプッシュ通知を確認してください。',
                'title' => 'これはテストのタイトルです',
                'unknown_channel' => '不明なチャネル',
            ],
        ],
        'oauth_path' => 'サードパーティログインプラットフォーム',
        'offline_check_times' => 'オフライン通知回数',
        'params_required' => 'この:attributeの必要なパラメータを先に完了してください！',
        'password_reset_notification' => 'パスワードリセット通知',
        'paybeaver_app_id' => 'App ID',
        'paybeaver_app_secret' => 'Appシークレット',
        'payjs_key' => '通信キー',
        'payjs_mch_id' => '商人ID',
        'payment' => [
            'attribute' => '支払い設定',
            'channel' => [
                'alipay' => 'Alipay F2F',
                'codepay' => 'CodePay',
                'epay' => 'ePay',
                'manual' => '手動支払い',
                'paybeaver' => 'PayBeaver',
                'payjs' => 'PayJs',
                'paypal' => 'PayPal',
                'stripe' => 'Stripe',
                'theadpay' => 'THeadPay',
            ],
            'hint' => [
                'alipay' => 'この機能を使用するには、<a href="https://open.alipay.com/platform/appManage.htm?#/create/" target="_blank">Ant Financial Services Open Platform</a>で権限とアプリケーションを申請する必要があります。',
                'codepay' => 'CodePayに<a href="https://codepay.fateqq.com/i/377289" target="_blank">こちら</a>から登録し、ソフトウェアをダウンロードして設定してください。',
                'manual' => '設定後、ユーザーエンドに対応する表示が自動的に表示されます。',
                'paybeaver' => 'PayBeaverに<a href="https://merchant.paybeaver.com/?aff_code=iK4GNuX8" target="_blank">こちら</a>から登録してください。',
                'payjs' => 'PayJsに<a href="https://payjs.cn/ref/zgxjnb" target="_blank">こちら</a>から登録してください。',
                'paypal' => '商人アカウントで<a href="https://www.paypal.com/businessprofile/mytools/apiaccess/firstparty" target="_blank">API資格情報申請ページ</a>にログインし、同意して設定情報を取得してください。',
                'theadpay' => 'THeadPayに<a href="https://theadpay.com/" target="_blank">こちら</a>から登録してください。',
            ],
        ],
        'payment_confirm_notification' => '手動支払い確認通知',
        'payment_received_notification' => '支払い成功通知',
        'paypal_app_id' => 'App ID',
        'paypal_client_id' => 'クライアントID',
        'paypal_client_secret' => 'クライアントシークレット',
        'placeholder' => [
            'bark_key' => 'Barkのデバイスキーを入力 -> 更新をクリック',
            'codepay_url' => 'https://codepay.fateqq.com/creat_order/?',
            'default_url' => 'デフォルトは :url',
            'dingTalk_access_token' => 'カスタムボットのWebHookのaccess_token',
            'dingTalk_secret' => 'カスタムボットのサイン後に表示されるシークレット',
            'iYuu_token' => 'IYUUトークンを入力 -> 更新をクリック',
            'pushDeer_key' => 'PushDeerのPush Keyを入力 -> 更新をクリック',
            'pushplus_token' => 'ServerChanで申請してください。',
            'server_chan_key' => 'ServerChanのSCKEYを入力 -> 更新をクリック',
            'telegram_token' => 'Telegramのトークンを入力 -> 更新をクリック',
            'tg_chat_token' => 'Telegramで申請してください。',
            'wechat_aid' => 'アプリのAgentId',
            'wechat_cid' => 'WeChatの企業IDを入力 -> 更新をクリック',
            'wechat_secret' => 'アプリのシークレット',
        ],
        'pushDeer_key' => 'PushDeerキー',
        'pushplus_token' => 'PushPlusトークン',
        'rand_subscribe' => 'ランダムサブスクリプション',
        'redirect_url' => 'リダイレクトURL',
        'referral' => [
            'loop' => '継続リベート',
            'once' => '初回購入リベート',
        ],
        'referral_money' => '引き出し制限',
        'referral_percent' => 'リベート率',
        'referral_status' => 'アフィリエイト機能',
        'referral_traffic' => '登録ボーナス',
        'referral_type' => 'リベートモード',
        'register_ip_limit' => '同一IP登録制限',
        'reset_password_times' => 'パスワードリセット回数',
        'reset_traffic' => 'データ自動リセット',
        'server_chan_key' => 'ServerChan SCKEY',
        'standard_currency' => '基準通貨',
        'stripe_public_key' => 'パブリックキー',
        'stripe_secret_key' => 'シークレットキー',
        'stripe_signing_secret' => 'Webhook署名シークレット',
        'subject_name' => 'カスタム商品名',
        'subscribe_ban_times' => 'サブスクリプションリクエストしきい値',
        'subscribe_domain' => 'ノードサブスクリプションURL',
        'subscribe_max' => 'サブスクリプションノード数',
        'telegram_token' => 'Telegramトークン',
        'tg_chat_token' => 'TGチャットトークン',
        'theadpay_key' => 'THeadPayキー',
        'theadpay_mchid' => 'THeadPay商人ID',
        'theadpay_url' => 'THeadPay URL',
        'ticket_closed_notification' => 'チケットクローズ通知',
        'ticket_created_notification' => '新しいチケット通知',
        'ticket_replied_notification' => 'チケット返信通知',
        'traffic_ban_time' => '禁止期間',
        'traffic_ban_value' => 'データ異常しきい値',
        'traffic_limit_time' => '時間間隔',
        'traffic_warning_percent' => 'データ警告しきい値',
        'trojan_license' => 'Trojanライセンス',
        'user_invite_days' => 'ユーザー-招待コード有効期',
        'username' => [
            'any' => '任意のユーザー名',
            'email' => 'メールアドレス',
            'mobile' => '携帯電話番号',
        ],
        'username_type' => 'ユーザー名タイプ',
        'v2ray_license' => 'V2Rayライセンス',
        'v2ray_tls_provider' => 'V2Ray TLS設定',
        'web_api_url' => 'APIアクセスURL',
        'webmaster_email' => '管理者メール',
        'website_analytics' => 'ウェブサイト分析コード',
        'website_callback_url' => '支払いコールバックURL',
        'website_customer_service' => 'カスタマーサービスコード',
        'website_home_logo' => 'ホームページロゴ',
        'website_logo' => 'サイトロゴ',
        'website_name' => 'ウェブサイト名',
        'website_security_code' => 'ウェブサイトセキュリティコード',
        'website_url' => 'ウェブサイトURL',
        'wechat_aid' => 'WeChatアプリID',
        'wechat_cid' => 'WeChat企業ID',
        'wechat_encodingAESKey' => 'WeChatエンコーディングキー',
        'wechat_qrcode' => 'WeChat QRコード',
        'wechat_secret' => 'WeChatシークレット',
        'wechat_token' => 'WeChatトークン',
    ],
    'system_generate' => 'システム生成',
    'ticket' => [
        'close_confirm' => 'このチケットを閉じてもよろしいですか？',
        'counts' => '合計 <code>:num</code> チケット',
        'error' => '不明なエラーです。ログを確認してください。',
        'inviter_info' => '招待者情報',
        'self_send' => '自分自身のためにチケットを作成することはできません！',
        'send_to' => 'ターゲットユーザーの情報を入力してください',
        'title' => 'チケットリスト',
        'user_info' => 'ユーザー情報',
    ],
    'times' => '回',
    'tools' => [
        'analysis' => [
            'file_missing' => ':file_name が存在しません。先にファイルを作成してください。',
            'not_enough' => '記録が15,000未満のため、分析できません。',
            'req_url' => '最近のリクエストURL記録',
            'title' => 'SSRログ分析<small>シングルノード用</small>',
        ],
        'convert' => [
            'content_placeholder' => '変換する構成情報を入力してください。',
            'file_missing' => 'ファイルが見つかりません。ディレクトリのアクセス権を確認してください。',
            'missing_error' => '変換に失敗しました：設定情報に [port_password] フィールドが欠落しているか、またはこのフィールドが空です。',
            'params_unknown' => 'パラメータ例外',
            'title' => 'フォーマット変換<small>ShadowsocksからShadowsocksRへ</small>',
        ],
        'decompile' => [
            'attribute' => '逆コンパイル構成リンク',
            'content_placeholder' => '逆コンパイルするShadowsocksRリンクを入力してください。行区切りで入力。',
            'title' => '逆コンパイル<small>構成情報</small>',
        ],
        'import' => [
            'file_error' => '未知のエラーが発生しました。再度アップロードしてください。',
            'file_required' => 'アップロードするファイルを選択してください',
            'file_type_error' => ':type ファイルのみアップロードが許可されています。',
            'format_error' => 'コンテンツフォーマットの解析エラーが発生しました。指定されたフォーマットに準拠した:typeファイルをアップロードしてください。',
        ],
    ],
    'unselected_hint' => '割り当てられるルールはここで検索できます',
    'user' => [
        'admin_deletion' => 'システム管理者は削除できません',
        'bulk_account_quantity' => '一括生成されたアカウントの数',
        'connection_test' => '接続テスト',
        'counts' => '合計 <code>:num</code> アカウント',
        'group' => [
            'counts' => '合計 <code>:num</code> グループ',
            'name' => 'グループ名',
            'title' => 'ユーザーグループコントロール<small>（ノードは複数のグループに属することができますが、ユーザーは1つのグループにのみ属することができます。ユーザーが表示/利用できるノードについては、グループがレベルより優先されます）</small>',
        ],
        'info' => [
            'account' => 'アカウント情報',
            'expired_date_hint' => '空白の場合、デフォルトで1年間有効',
            'proxy' => 'プロキシ情報',
            'recharge_placeholder' => '負の値を入力すると残高が減少します',
            'reset_date_hint' => '次回のデータリセット日',
            'switch' => 'アイデンティティを切り替え',
            'uuid_hint' => 'V2RayのUUID',
        ],
        'online_monitor' => 'オンラインモニタリング',
        'proxies_config' => '【:username】の接続構成情報',
        'proxy_info' => '構成情報',
        'reset_confirm' => [0 => '【', 1 => '】のデータをリセットしてもよろしいですか？'],
        'reset_traffic' => 'データリセット',
        'traffic_monitor' => 'トラフィック統計',
        'update_help' => '更新に成功しました。戻りますか？',
        'user_view' => 'ユーザー視点に切り替え',
    ],
    'user_dashboard' => 'ユーザーダッシュボード',
    'yes' => 'はい',
    'zero_unlimited_hint' => '設定しない/0の場合、無制限',
];
