<?php

declare(strict_types=1);

return [
    'action' => [
        'add_item' => 'افزودن :attribute',
        'edit_item' => 'ویرایش :attribute',
    ],
    'aff' => [
        'apply_counts' => 'مجموع <code>:num</code> درخواست برداشت',
        'commission_counts' => 'این درخواست شامل مجموع <code>:num</code> سفارش است',
        'commission_title' => 'جزئیات درخواست',
        'counts' => 'مجموع <code>:num</code> رکورد بازگشت وجه',
        'rebate_title' => 'تاریخچه بازگشت وجه',
        'referral' => 'بازگشت وجه معرفی',
        'title' => 'لیست درخواست‌های برداشت',
    ],
    'article' => [
        'category_hint' => 'همه مقالات در یک دسته‌بندی در یک پوشه قرار می‌گیرند',
        'counts' => 'مجموع <code>:num</code> مقاله',
        'logo_placeholder' => 'یا آدرس URL لوگو را وارد کنید',
        'title' => 'مقالات',
        'type' => [
            'announcement' => 'اعلان',
            'knowledge' => 'مقاله',
        ],
    ],
    'clear' => 'پاک کردن',
    'clone' => 'کلون',
    'confirm' => [
        'continues' => 'آیا می‌خواهید این عملیات را ادامه دهید؟',
        'delete' => [0 => 'آیا می‌خواهید :attribute【', 1 => '】را حذف کنید؟'],
        'export' => 'آیا می‌خواهید همه را صادر کنید؟',
    ],
    'coupon' => [
        'counts' => 'مجموع <code>:num</code> کوپن',
        'created_days_hint' => '<code>:days</code> روز پس از ثبت‌نام',
        'discount' => 'تخفیف',
        'export_title' => 'صادرات',
        'groups_hint' => 'فقط برای گروه‌های کاربری انتخاب شده قابل استفاده است',
        'info_title' => 'اطلاعات',
        'levels_hint' => 'فقط برای سطوح کاربری انتخاب شده قابل استفاده است',
        'limit_hint' => 'قوانین دارای رابطه <strong>و</strong> هستند، به‌درستی استفاده کنید',
        'minimum_hint' => 'فقط زمانی قابل استفاده است که مبلغ پرداختی بیش از <strong>:num</strong> باشد',
        'name_hint' => 'برای نمایش',
        'newbie' => [
            'created_days' => 'عمر حساب',
            'first_discount' => 'تخفیف اولین بار',
            'first_order' => 'اولین سفارش',
        ],
        'priority_hint' => 'کوپن با اولویت بالاتر ابتدا استفاده می‌شود. حداکثر 255',
        'services_blacklist_hint' => 'برای محصولات سیاه لیست قابل استفاده نیست، خالی بگذارید اگر استفاده نمی‌شود',
        'services_placeholder' => 'شناسه محصول را وارد کنید، سپس Enter را فشار دهید',
        'services_whitelist_hint' => 'فقط برای محصولات سفید لیست قابل استفاده است، خالی بگذارید اگر استفاده نمی‌شود',
        'single_use' => 'استفاده یک‌باره',
        'sn_hint' => 'برای استفاده کاربران از کوپن، خالی بگذارید تا به صورت تصادفی یک کد 8 رقمی تولید شود',
        'title' => 'کوپن‌ها',
        'type' => [
            'charge' => 'شارژ',
            'discount' => 'تخفیف',
            'voucher' => 'کوپن',
        ],
        'type_hint' => 'کاهش: کسر مبلغ؛ تخفیف: درصد تخفیف؛ شارژ: افزودن مبلغ به موجودی',
        'used_hint' => 'هر کاربر می‌تواند این کوپن را حداکثر <strong>:num</strong> بار استفاده کند',
        'user_whitelist_hint' => 'کاربران سفید لیست می‌توانند استفاده کنند، خالی بگذارید اگر استفاده نمی‌شود',
        'users_blacklist_hint' => 'کاربران سیاه لیست نمی‌توانند استفاده کنند، خالی بگذارید اگر استفاده نمی‌شود',
        'users_placeholder' => 'شناسه کاربر را وارد کنید، سپس Enter را فشار دهید',
        'value' => '{1} ➖ :num|{2} :num% تخفیف|{3} ➕ :num',
        'value_hint' => 'محدوده 1٪ تا 99٪',
    ],
    'creating' => 'در حال افزودن...',
    'dashboard' => [
        'abnormal_users' => 'کاربرانی که در یک ساعت گذشته ترافیک غیرعادی داشته‌اند',
        'active_days_users' => 'کاربران فعال در :days روز گذشته',
        'available_users' => 'تعداد کاربران فعال',
        'credit' => 'کل موجودی',
        'current_month_traffic_consumed' => 'ترافیک مصرفی این ماه',
        'days_traffic_consumed' => 'ترافیک مصرفی در :days روز گذشته',
        'expiring_users' => 'کاربران در حال انقضا',
        'inactive_days_users' => 'کاربران غیرفعال برای بیش از :days روز',
        'maintaining_nodes' => 'گره‌های در حالت نگهداری',
        'nodes' => 'تعداد گره‌ها',
        'online_orders' => 'تعداد سفارش‌های پرداخت آنلاین',
        'online_users' => 'کاربران آنلاین کنونی',
        'orders' => 'تعداد کل سفارش‌ها',
        'overuse_users' => 'کاربرانی که بیش از 90٪ از داده استفاده کرده‌اند',
        'paid_users' => 'تعداد کاربران پرداخت کننده',
        'succeed_orders' => 'تعداد سفارش‌های پرداخت شده',
        'users' => 'تعداد کل کاربران',
        'withdrawing_commissions' => 'کمیسیون‌های در حال برداشت',
        'withdrawn_commissions' => 'کمیسیون‌های برداشت شده',
    ],
    'end_time' => 'پایان',
    'goods' => [
        'counts' => 'مجموع <code>:num</code> محصول',
        'info' => [
            'available_date_hint' => 'هنگام انقضا به‌طور خودکار از کل داده کسر می‌شود',
            'desc_placeholder' => 'توضیحات مختصر',
            'limit_num_hint' => 'حداکثر تعداد خریدها برای هر کاربر، 0 برای نامحدود',
            'list_hint' => 'هر خط را با <code><li></code> شروع کنید و با <code></li></code> پایان دهید',
            'list_placeholder' => 'افزودن محتوای سفارشی',
            'period_hint' => 'مقدار داده هر N روز برای طرح‌ها بازنشانی می‌شود',
            'type_hint' => 'طرح‌ها بر انقضای حساب تأثیر می‌گذارند، بسته‌ها فقط از داده کسر می‌کنند و بر انقضا تأثیر نمی‌گذارند',
        ],
        'sell_and_used' => 'استفاده شده / فروخته شده',
        'status' => [
            'no' => 'خارج از فروش',
            'yes' => 'در حال فروش',
        ],
        'title' => 'محصولات',
        'type' => [
            'package' => 'بسته داده',
            'plan' => 'طرح اشتراک',
            'top_up' => 'شارژ',
        ],
    ],
    'hint' => 'نکته',
    'logs' => [
        'ban' => [
            'ban_time' => 'زمان مسدودسازی',
            'last_connect_at' => 'آخرین زمان ورود',
            'reason' => 'دلیل',
            'time' => 'مدت زمان',
            'title' => 'سوابق مسدودسازی کاربران',
        ],
        'callback' => 'لاگ‌های بازگشت <small>(پرداخت)</small>',
        'counts' => 'مجموع <code>:num</code> رکورد',
        'credit_title' => 'سوابق تغییر موجودی',
        'ip_monitor' => 'IP‌های آنلاین <small>داده‌های زمان واقعی 2 دقیقه‌ای</small>',
        'notification' => 'لاگ‌های ایمیل',
        'order' => [
            'is_coupon' => 'کوپن استفاده شده',
            'is_expired' => 'منقضی شده',
            'title' => 'سفارش‌ها',
            'update_conflict' => 'به‌روزرسانی ناموفق: تعارض سفارش',
        ],
        'rule' => [
            'clear_all' => 'پاک کردن همه رکوردها',
            'clear_confirm' => 'آیا می‌خواهید همه سوابق فعال‌سازی قوانین را پاک کنید؟',
            'created_at' => 'زمان فعال‌سازی',
            'name' => 'نام قانون فعال شده',
            'reason' => 'دلیل فعال‌سازی',
            'tag' => '✅ دسترسی به محتوای غیرمجاز',
            'title' => 'سوابق فعال‌سازی قوانین',
        ],
        'subscribe' => 'اشتراک‌ها',
        'user_data_modify_title' => 'سوابق تغییر داده‌ها',
        'user_ip' => [
            'connect' => 'IP متصل شده',
            'title' => 'IP‌های آنلاین <small>10 دقیقه گذشته</small>',
        ],
        'user_traffic' => [
            'choose_node' => 'انتخاب گره',
            'title' => 'سوابق استفاده از داده‌ها',
        ],
    ],
    'marketing' => [
        'counts' => 'مجموع <code>:num</code> ایمیل',
        'email' => [
            'ever_paid' => 'پرداخت شده',
            'expired_date' => 'تاریخ انقضا',
            'filters' => 'فیلترها',
            'loading_statistics' => 'در حال بارگذاری آمار...',
            'never_paid' => 'هرگز پرداخت نشده',
            'paid_servicing' => 'خدمات پرداختی',
            'previously_paid' => 'قبلاً پرداخت شده',
            'recent_traffic_abnormal' => 'ناهنجاری ترافیک در ساعت اخیر',
            'recently_active' => 'فعالیت اخیر',
            'targeted_users_count' => 'تعداد کاربران هدف',
            'traffic_usage_over' => 'استفاده از ترافیک بیش از N%',
            'will_expire_date' => 'تاریخ انقضا آینده',
        ],
        'email_send' => 'ارسال ایمیل گروهی',
        'error_message' => 'پیام‌های خطا',
        'processed' => 'درخواست پردازش شده',
        'push_send' => 'ارسال پیام فشاری',
        'send_status' => 'وضعیت ارسال',
        'send_time' => 'زمان ارسال',
        'targeted_users_not_found' => 'کاربران هدف یافت نشد',
        'unknown_sending_type' => 'نوع ارسال ناشناخته',
    ],
    'massive_export' => 'صادرات گروهی',
    'menu' => [
        'analysis' => [
            'accounting' => 'حسابداری',
            'attribute' => 'تحلیل داده‌ها',
            'node_flow' => 'تحلیل ترافیک گره',
            'site_flow' => 'تحلیل ترافیک سایت',
            'user_flow' => 'تحلیل ترافیک کاربران',
        ],
        'customer_service' => [
            'article' => 'مدیریت مقالات',
            'attribute' => 'سیستم پشتیبانی',
            'marketing' => 'پخش پیام‌ها',
            'ticket' => 'تیکت‌های پشتیبانی',
        ],
        'dashboard' => 'مدیریت',
        'log' => [
            'attribute' => 'سیستم لاگ‌ها',
            'notify' => 'سوابق اعلان‌ها',
            'online_logs' => 'لاگ‌های آنلاین',
            'online_monitor' => 'نظارت آنلاین',
            'payment_callback' => 'بازگشت پرداخت',
            'service_ban' => 'سوابق مسدودسازی',
            'system' => 'لاگ‌های سیستم',
            'traffic' => 'استفاده از ترافیک',
            'traffic_flow' => 'تغییرات ترافیک',
        ],
        'node' => [
            'attribute' => 'سیستم گره‌ها',
            'auth' => 'مجوزهای گره',
            'cert' => 'لیست گواهینامه‌ها',
            'list' => 'مدیریت گره‌ها',
        ],
        'promotion' => [
            'attribute' => 'بازاریابی',
            'invite' => 'مدیریت دعوت‌ها',
            'rebate_flow' => 'تاریخچه تخفیف‌ها',
            'withdraw' => 'مدیریت برداشت‌ها',
        ],
        'rbac' => [
            'attribute' => 'سیستم دسترسی',
            'permission' => 'مدیریت دسترسی‌ها',
            'role' => 'لیست نقش‌ها',
        ],
        'rule' => [
            'attribute' => 'قوانین بررسی',
            'group' => 'گروه‌های قوانین',
            'list' => 'لیست قوانین',
            'trigger' => 'سوابق فعال‌سازی',
        ],
        'setting' => [
            'attribute' => 'تنظیمات سیستم',
            'email_suffix' => 'مدیریت پسوندهای ایمیل',
            'system' => 'پارامترهای سیستم',
            'universal' => 'تنظیمات عمومی',
        ],
        'shop' => [
            'attribute' => 'سیستم فروشگاه',
            'coupon' => 'مدیریت کوپن‌ها',
            'goods' => 'مدیریت محصولات',
            'order' => 'سفارش‌های محصول',
        ],
        'tools' => [
            'analysis' => 'تحلیل لاگ‌ها',
            'attribute' => 'ابزارها',
            'convert' => 'تبدیل فرمت',
            'decompile' => 'دی‌کامپایل',
            'import' => 'وارد کردن داده‌ها',
        ],
        'user' => [
            'attribute' => 'سیستم کاربران',
            'credit_log' => 'تاریخچه موجودی',
            'group' => 'گروه‌های کاربری',
            'list' => 'مدیریت کاربران',
            'oauth' => 'مجوزهای شخص ثالث',
            'subscribe' => 'مدیریت اشتراک‌ها',
        ],
    ],
    'minute' => 'دقیقه',
    'monitor' => [
        'daily_chart' => 'نمودار مصرف روزانه ترافیک',
        'hint' => '<strong>نکته:</strong> اگر داده‌ای وجود ندارد، بررسی کنید که وظایف زمان‌بندی شده به درستی اجرا می‌شوند.',
        'monthly_chart' => 'نمودار مصرف ماهانه ترافیک',
        'node' => 'ترافیک گره',
        'user' => 'ترافیک کاربر',
    ],
    'no' => 'خیر',
    'node' => [
        'auth' => [
            'counts' => 'مجموع <code>:num</code> مجوز',
            'deploy' => [
                'attribute' => 'استقرار بک‌اند',
                'command' => 'دستورات',
                'real_time_logs' => 'لاگ‌های زمان واقعی',
                'recent_logs' => 'لاگ‌های اخیر',
                'restart' => 'راه‌اندازی مجدد',
                'same' => 'همان بالا',
                'start' => 'شروع',
                'status' => 'وضعیت',
                'stop' => 'توقف',
                'title' => 'استقرار بک‌اند :type_label',
                'trojan_hint' => 'لطفاً <a href=":url" target="_blank">نام گره را وارد کنید</a> و به IP مربوطه تجزیه کنید',
                'uninstall' => 'حذف',
                'update' => 'به‌روزرسانی',
            ],
            'empty' => 'هیچ گره‌ای نیاز به تولید مجوز ندارد',
            'generating_all' => 'آیا می‌خواهید کلیدهای مجوز را برای همه گره‌ها تولید کنید؟',
            'reset_auth' => 'بازنشانی کلید مجوز',
            'title' => 'مجوزهای API <small>WEBAPI</small>',
        ],
        'cert' => [
            'counts' => 'مجموع <code>:num</code> گواهینامه دامنه',
            'key_placeholder' => 'مقدار KEY گواهینامه، می‌تواند خالی بماند. بک‌اند VNET-V2Ray از صدور خودکار پشتیبانی می‌کند',
            'pem_placeholder' => 'بک‌اند VNET-V2Ray از صدور خودکار پشتیبانی می‌کند',
            'title' => 'گواهینامه‌های دامنه <small>(برای پنهان‌سازی دامنه V2Ray)</small>',
        ],
        'connection_test' => 'تست اتصال',
        'counts' => 'مجموع <code>:num</code> گره',
        'info' => [
            'additional_ports_hint' => 'اگر فعال است، لطفاً پیکربندی سرور <span class="red-700"><a href="javascript:showTnc();">additional_ports</a></span> را انجام دهید',
            'basic' => 'اطلاعات پایه',
            'data_rate_hint' => 'مثال: 0.1 به معنای 100M به عنوان 10M محاسبه می‌شود؛ 5 به معنای 100M به عنوان 500M محاسبه می‌شود',
            'ddns_hint' => 'گره‌های داینامیک IP نیاز به <a href="https://github.com/NewFuture/DDNS" target="_blank">پیکربندی DDNS</a> دارند. برای این نوع گره، تست اتصال از طریق نام دامنه انجام می‌شود.',
            'detection' => [
                'all' => 'هر دو',
                'hint' => 'بررسی تصادفی هر 30-60 دقیقه',
                'icmp' => 'فقط ICMP',
                'tcp' => 'فقط TCP',
            ],
            'display' => [
                'all' => 'کاملاً قابل مشاهده',
                'hint' => 'آیا در لیست اشتراک/گره قابل مشاهده است',
                'invisible' => 'کاملاً نامرئی',
                'node' => 'فقط در صفحه گره‌ها قابل مشاهده است',
                'sub' => 'فقط در اشتراک‌ها قابل مشاهده است',
            ],
            'domain_hint' => 'پس از فعال‌سازی DDNS در تنظیمات سیستم، نام دامنه و IPها به‌طور خودکار به‌روزرسانی می‌شوند! دیگر نیازی به ویرایش این اطلاعات در وب‌سایت ثبت دامنه نیست.',
            'domain_placeholder' => 'دامنه سرور، در صورت پر شدن ابتدا استفاده می‌شود',
            'extend' => 'اطلاعات اضافی',
            'hint' => '<strong>توجه:</strong> <code>ID</code> به‌طور خودکار تولید شده، <code>node_id</code> برای بک‌اند ShadowsocksR و <code>nodeId</code> برای بک‌اند V2Ray است',
            'ipv4_hint' => 'چندین IP باید با کاما انگلیسی جدا شوند، برای مثال: 1.1.1.1,8.8.8.8',
            'ipv4_placeholder' => 'آدرس IPv4 سرور',
            'ipv6_hint' => 'چندین IP باید با کاما انگلیسی جدا شوند، برای مثال: 1.1.1.1,8.8.8.8',
            'ipv6_placeholder' => 'آدرس IPv6 سرور',
            'level_hint' => 'سطح: 0 - بدون محدودیت سطح، همه قابل مشاهده هستند.',
            'obfs_param_hint' => 'اگر obfs [plain] نیست، پارامترها را برای پنهان‌سازی ترافیک وارد کنید؛ &#13;&#10;پورت 80 را پیشنهاد می‌کنیم اگر obfs [http_simple] است؛ &#13;&#10;پورت 443 را پیشنهاد می‌کنیم اگر obfs [tls] است؛',
            'push_port_hint' => 'الزامی است. مطمئن شوید که این پورت در فایروال سرور باز است، در غیر این صورت ارسال پیام‌ها غیرعادی خواهد بود.',
            'single_hint' => 'پورت 80/443 را پیشنهاد می‌کنیم. بک‌اند نیاز به پیکربندی حالت سختگیرانه دارد: فقط از طریق پورت‌های مشخص شده متصل شوید. (<a href="javascript:showPortsOnlyConfig();">چگونه پیکربندی کنیم</a>)',
            'v2_cover' => [
                'dtls' => 'DTLS 1.2',
                'http' => 'HTTP',
                'none' => 'بدون پنهان‌سازی',
                'srtp' => 'SRTP',
                'utp' => 'uTP',
                'wechat' => 'تماس ویدیویی WeChat',
                'wireguard' => 'WireGuard',
            ],
            'v2_host_hint' => 'هنگام استفاده از پنهان‌سازی HTTP، چندین دامنه باید با کاما جدا شوند، در حالی که WebSocket فقط یک دامنه را مجاز می‌داند.',
            'v2_method_hint' => 'پروتکل انتقال WebSocket نباید از روش رمزنگاری \'none\' استفاده کند.',
            'v2_net_hint' => 'لطفاً TLS را برای WebSocket فعال کنید',
            'v2_tls_provider_hint' => 'پیکربندی‌های مختلف برای بک‌اندهای مختلف:',
        ],
        'proxy_info' => '*سازگار با Shadowsocks',
        'proxy_info_hint' => 'برای سازگاری، لطفاً <span class="red-700">_compatible</span> را به پروتکل و obfuscation در پیکربندی سرور اضافه کنید',
        'refresh_geo' => 'تازه‌سازی جغرافیا',
        'refresh_geo_all' => 'تازه‌سازی داده‌های جغرافیا',
        'reload' => 'بارگذاری مجدد بک‌اند',
        'reload_all' => 'بارگذاری مجدد همه سرورها',
        'reload_confirm' => 'آیا می‌خواهید سرور را بارگذاری مجدد کنید؟',
        'traffic_monitor' => 'آمار ترافیک',
    ],
    'oauth' => [
        'counts' => 'مجموع <code>:num</code> رکورد مجوز',
        'title' => 'مجوزهای شخص ثالث',
    ],
    'optional' => 'اختیاری',
    'permission' => [
        'counts' => 'مجموع <code>:num</code> دسترسی',
        'description_hint' => 'توضیحات، برای مثال: [سیستم X] ویرایش A',
        'name_hint' => 'نام مسیر، برای مثال: admin.user.update',
        'title' => 'دسترسی‌ها',
    ],
    'query' => 'جستجو',
    'report' => [
        'annually_accounting' => 'تراکنش‌های سالانه',
        'annually_site_flow' => 'مصرف سالانه ترافیک',
        'avg_traffic_30d' => 'میانگین ترافیک روزانه در 30 روز',
        'current_month' => 'این ماه',
        'current_year' => 'امسال',
        'daily_accounting' => 'تراکنش‌های روزانه',
        'daily_distribution' => 'توزیع روزانه',
        'daily_site_flow' => 'مصرف روزانه ترافیک',
        'daily_traffic' => 'ترافیک روزانه',
        'hourly_traffic' => 'ترافیک ساعتی',
        'last_month' => 'ماه گذشته',
        'last_year' => 'سال گذشته',
        'monthly_accounting' => 'تراکنش‌های ماهانه',
        'monthly_site_flow' => 'مصرف ماهانه ترافیک',
        'select_hourly_date' => 'انتخاب تاریخ ساعتی',
        'sum_traffic_30d' => 'نسبت ترافیک 30 روزه',
        'today' => 'امروز',
    ],
    'require' => 'ضروری',
    'role' => [
        'counts' => 'مجموع <code>:num</code> نقش',
        'description_hint' => 'نام نمایشی، برای مثال: مدیر',
        'modify_admin_error' => 'لطفاً سرپرست ارشد را تغییر ندهید!',
        'name_hint' => 'شناسه منحصر به فرد، برای مثال: admin',
        'permissions_all' => 'همه دسترسی‌ها',
        'title' => 'نقش‌ها',
    ],
    'rule' => [
        'counts' => 'مجموع <code>:num</code> قانون',
        'group' => [
            'counts' => 'مجموع <code>:num</code> گروه',
            'title' => 'گروه‌های قوانین',
            'type' => [
                'off' => 'مسدود',
                'on' => 'مجاز',
            ],
        ],
        'title' => 'قوانین',
        'type' => [
            'domain' => 'دامنه',
            'ip' => 'IP',
            'protocol' => 'پروتکل',
            'reg' => 'عبارت با قاعده',
        ],
    ],
    'select_all' => 'انتخاب همه',
    'selected_hint' => 'قوانین تخصیص داده شده، اینجا قابل جستجو هستند',
    'set_to' => 'تنظیم به :attribute',
    'setting' => [
        'common' => [
            'connect_nodes' => 'تعداد گره‌های متصل',
            'set_default' => 'تنظیم به عنوان پیش‌فرض',
            'title' => 'تنظیمات عمومی',
        ],
        'email' => [
            'black' => 'لیست سیاه',
            'rule' => 'قانون',
            'tail' => 'پسوند ایمیل',
            'tail_placeholder' => 'لطفاً پسوند ایمیل را وارد کنید',
            'title' => 'لیست فیلتر ایمیل <small>(برای جلوگیری از ثبت‌نام با پسوندهای خاص ایمیل)</small>',
            'white' => 'لیست سفید',
        ],
        'no_permission' => 'شما اجازه تغییر پارامترها را ندارید!',
        'system' => [
            'account' => 'تنظیمات حساب',
            'auto_job' => 'وظایف خودکار',
            'check_in' => 'سیستم چک‌این',
            'extend' => 'ویژگی‌های اضافی',
            'menu' => 'منو',
            'node' => 'تنظیمات گره',
            'notify' => 'سیستم اطلاع‌رسانی',
            'other' => 'لوگو | خدمات مشتری | آمار',
            'payment' => 'سیستم پرداخت',
            'promotion' => 'سیستم معرفی',
            'title' => 'تنظیمات سیستم',
            'web' => 'تنظیمات سایت',
        ],
    ],
    'sort_asc' => 'مقدار مرتب‌سازی بزرگتر اولویت بالاتری دارد',
    'start_time' => 'شروع',
    'system' => [
        'AppStore_id' => 'حساب اپل',
        'AppStore_password' => 'رمز عبور اپل',
        'account_expire_notification' => 'اطلاع‌رسانی انقضای حساب',
        'active_account' => [
            'after' => 'فعال‌سازی پس از ثبت‌نام',
            'before' => 'فعال‌سازی قبل از ثبت‌نام',
        ],
        'active_times' => 'تعداد فعال‌سازی حساب',
        'admin_invite_days' => 'مدت اعتبار دعوت‌نامه مدیر',
        'aff_salt' => 'رمزنگاری اطلاعات کاربر در لینک معرفی',
        'alipay_qrcode' => 'کد QR علی‌پی',
        'auto_release_port' => 'مکانیزم بازیابی پورت',
        'bark_key' => 'کلید دستگاه Bark',
        'captcha' => [
            'geetest' => 'Geetest',
            'hcaptcha' => 'hCaptcha',
            'recaptcha' => 'Google reCaptcha',
            'standard' => 'کد امنیتی استاندارد',
            'turnstile' => 'Turnstile',
        ],
        'captcha_key' => 'کلید کد امنیتی',
        'captcha_secret' => 'رمز/شناسه کد امنیتی',
        'codepay_id' => 'شناسه CodePay',
        'codepay_key' => 'کلید ارتباطی',
        'codepay_url' => 'URL درخواست',
        'data_anomaly_notification' => 'اطلاع‌رسانی ناهنجاری داده',
        'data_exhaust_notification' => 'اطلاع‌رسانی اتمام داده',
        'ddns_key' => 'کلید DNS',
        'ddns_mode' => 'حالت DDNS',
        'ddns_secret' => 'رمز DNS',
        'default_days' => 'مدت اعتبار پیش‌فرض',
        'default_traffic' => 'داده اولیه پیش‌فرض',
        'demo_restriction' => 'در محیط نمایشی، تغییر این پیکربندی ممنوع است!',
        'detection_check_times' => 'اطلاع‌رسانی تشخیص انسداد',
        'dingTalk_access_token' => 'توکن دسترسی DingTalk',
        'dingTalk_secret' => 'رمز DingTalk',
        'epay_key' => 'کلید ePay',
        'epay_mch_id' => 'شناسه بازرگان ePay',
        'epay_url' => 'URL ePay',
        'expire_days' => 'هشدار انقضا',
        'f2fpay_app_id' => 'شناسه برنامه Alipay',
        'f2fpay_private_key' => 'کلید خصوصی Alipay',
        'f2fpay_public_key' => 'کلید عمومی Alipay',
        'forbid' => [
            'china' => 'مسدودسازی دسترسی از چین',
            'mainland' => 'مسدودسازی دسترسی از سرزمین اصلی چین',
            'oversea' => 'مسدودسازی دسترسی از خارج از کشور',
        ],
        'forbid_mode' => 'حالت مسدودسازی',
        'hint' => [
            'AppStore_id' => 'حساب اپل استفاده شده در آموزش‌ها',
            'AppStore_password' => 'رمز عبور اپل استفاده شده در آموزش‌ها',
            'account_expire_notification' => 'اطلاع‌رسانی انقضای حساب',
            'active_times' => 'تعداد فعال‌سازی حساب از طریق ایمیل در 24 ساعت',
            'admin_invite_days' => 'مدت اعتبار کدهای دعوت ایجاد شده توسط مدیر',
            'aff_salt' => 'رمزنگاری لینک دعوت با استفاده از متن مخفی',
            'auto_release_port' => 'پورت‌های مسدود شده/منقضی شده پس از <code>'.config('tasks.release_port').'</code> روز به‌صورت خودکار آزاد می‌شوند',
            'bark_key' => 'کلید دستگاه برای ارسال پیام به iOS',
            'captcha_key' => 'راهنمای تنظیمات <a href="https://proxypanel.gitbook.io/wiki/captcha" target="_blank">اینجا</a>',
            'data_anomaly_notification' => 'اطلاع‌رسانی به مدیر در صورت استفاده غیرعادی از داده در یک ساعت',
            'data_exhaust_notification' => 'اطلاع‌رسانی در صورت اتمام داده',
            'ddns_key' => 'راهنمای تنظیمات <a href="https://proxypanel.gitbook.io/wiki/ddns" target="_blank">اینجا</a>',
            'ddns_mode' => 'به‌روزرسانی خودکار تغییرات دامنه و IP به DNS',
            'default_days' => 'مدت اعتبار پیش‌فرض حساب‌های جدید، 0 به‌معنای انقضا در همان روز',
            'default_traffic' => 'داده پیش‌فرض برای حساب‌های جدید',
            'detection_check_times' => 'تعداد اطلاع‌رسانی‌های انسداد گره، 0 برای نامحدود، حداکثر 12',
            'dingTalk_access_token' => 'توکن دسترسی ربات سفارشی <a href=https://open.dingtalk.com/document/group/custom-robot-access#title-jfe-yo9-jl2 target=_blank>اینجا</a>',
            'dingTalk_secret' => 'رمز ربات سفارشی در صورت فعال‌سازی امضا',
            'expire_days' => 'شروع اطلاع‌رسانی انقضای حساب',
            'f2fpay_app_id' => 'شناسه برنامه Alipay',
            'f2fpay_private_key' => 'کلید خصوصی Alipay از ابزار تولید کلید',
            'f2fpay_public_key' => 'توجه: این کلید عمومی برنامه نیست!',
            'forbid_mode' => 'مسدودسازی دسترسی از مناطق مشخص',
            'iYuu_token' => 'پر کردن <a href=https://iyuu.cn target=_blank>توکن IYUU</a> قبل از فعال‌سازی',
            'invite_num' => 'تعداد دعوت‌نامه‌های پیش‌فرض برای هر کاربر',
            'is_activate_account' => 'نیاز به فعال‌سازی حساب از طریق ایمیل',
            'is_ban_status' => '(احتیاط) مسدودسازی کل حساب باعث بازنشانی تمام داده‌های کاربر می‌شود',
            'is_captcha' => 'نیاز به کد امنیتی برای ورود/ثبت‌نام در صورت فعال‌سازی',
            'is_checkin' => 'پاداش تصادفی در زمان چک‌این',
            'is_clear_log' => '(توصیه می‌شود) پاکسازی خودکار لاگ‌های بی‌استفاده/قدیمی در صورت فعال‌سازی',
            'is_custom_subscribe' => 'نمایش تاریخ انقضا و داده باقی‌مانده در لیست اشتراک در صورت فعال‌سازی',
            'is_email_filtering' => 'لیست سیاه: کاربران می‌توانند با پسوندهای ایمیلی که در لیست سیاه نیستند ثبت‌نام کنند؛ لیست سفید: کاربران باید با پسوندهای ایمیلی که در لیست سفید هستند ثبت‌نام کنند',
            'is_forbid_robot' => 'بازگشت خطای 404 در صورت دسترسی ربات‌ها/پراکسی‌ها',
            'is_free_code' => 'پنهان کردن کدهای دعوت رایگان در صورت غیرفعال‌سازی',
            'is_rand_port' => 'پورت تصادفی در زمان افزودن/ثبت‌نام کاربر',
            'is_register' => 'غیرفعال‌سازی ثبت‌نام در صورت عدم انتخاب',
            'is_subscribe_ban' => 'مسدودسازی خودکار در صورت درخواست‌های اشتراک بیش از حد',
            'is_traffic_ban' => 'غیرفعال‌سازی خودکار سرویس در صورت استفاده غیرعادی از داده در یک ساعت',
            'maintenance_content' => 'اطلاع‌رسانی سفارشی نگهداری',
            'maintenance_mode' => 'انتقال کاربران عادی به صفحه نگهداری در صورت فعال‌سازی | مدیر می‌تواند از طریق <a href=\'javascript:(0)\'>:url</a> وارد شود',
            'maintenance_time' => 'برای شمارش معکوس صفحه نگهداری',
            'min_port' => 'محدوده پورت 1000 - 65535',
            'node_blocked_notification' => 'تشخیص انسداد گره ساعتی و اطلاع‌رسانی به مدیران',
            'node_daily_notification' => 'گزارش روزانه استفاده از گره',
            'node_offline_notification' => 'تشخیص آفلاین شدن هر 10 دقیقه و اطلاع‌رسانی در صورت آفلاین بودن گره',
            'node_renewal_notification' => '7 روز، 3 روز و 1 روز قبل از انقضا به مدیر یادآوری کنید که گره را تمدید کند.',
            'oauth_path' => 'لطفاً ابتدا پلتفرم‌ها را در .ENV فعال کنید',
            'offline_check_times' => 'توقف اطلاع‌رسانی پس از N هشدار در 24 ساعت',
            'password_reset_notification' => 'اجازه بازنشانی رمز عبور از طریق ایمیل در صورت فعال‌سازی',
            'paybeaver_app_id' => '<a href="https://merchant.paybeaver.com/" target="_blank">مرکز بازرگان</a> -> توسعه‌دهنده -> شناسه برنامه',
            'paybeaver_app_secret' => '<a href="https://merchant.paybeaver.com/" target="_blank">مرکز بازرگان</a> -> توسعه‌دهنده -> رمز برنامه',
            'payjs_mch_id' => 'دریافت از <a href="https://payjs.cn/dashboard/member" target="_blank">صفحه عضو</a>',
            'payment_confirm_notification' => 'اطلاع‌رسانی به مدیر برای پردازش سفارش‌های پرداخت دستی',
            'payment_received_notification' => 'اطلاع‌رسانی به کاربر در صورت دریافت پرداخت',
            'pushDeer_key' => 'پر کردن <a href=https://www.pushdeer.com/official.html target=_blank>کلید PushDeer</a> قبل از فعال‌سازی',
            'pushplus_token' => 'پر کردن <a href=https://www.pushplus.plus/push1.html target=_blank>توکن PushPlus</a> قبل از فعال‌سازی',
            'rand_subscribe' => 'ترتیب تصادفی در صورت فعال‌سازی، در غیر این صورت بر اساس ترتیب لیست گره‌ها',
            'redirect_url' => 'تغییر مسیر درخواست‌های مسدود شده به این URL در صورت فعال‌سازی قوانین',
            'referral_money' => 'حداقل مبلغ برداشت',
            'referral_percent' => 'درصد بازگشت وجه از مبلغ سفارش',
            'referral_status' => 'بستن سیستم معرفی بدون تأثیر بر داده‌های موجود',
            'referral_traffic' => 'هدیه داده برای ثبت‌نام با لینک معرفی',
            'referral_type' => 'محاسبه بازگشت وجه جدید بر اساس حالت جدید پس از تغییر',
            'register_ip_limit' => 'تعداد ثبت‌نام‌های مجاز در هر IP در 24 ساعت، 0 برای نامحدود',
            'reset_password_times' => 'تعداد مجاز بازنشانی رمز عبور از طریق ایمیل در 24 ساعت',
            'reset_traffic' => 'بازنشانی خودکار داده بر اساس چرخه طرح کاربر',
            'server_chan_key' => 'پر کردن <a href="https://sct.ftqq.com/r/2626" target="_blank">کلید ServerChan</a> قبل از فعال‌سازی',
            'standard_currency' => 'واحد پول اصلی مورد استفاده در پنل',
            'subject_name' => 'نام محصول سفارشی در درگاه‌های پرداخت',
            'subscribe_ban_times' => 'حداکثر تعداد درخواست‌های اشتراک در 24 ساعت',
            'subscribe_domain' => 'شروع با http:// یا https:// برای جلوگیری از شکست DNS poisoning',
            'subscribe_max' => 'حداکثر تعداد گره‌های بازگشتی در لیست اشتراک، 0 برای همه',
            'telegram_token' => 'دریافت <a href=https://t.me/BotFather target=_blank>توکن ربات</a> از @BotFather',
            'tg_chat_token' => 'پر کردن <a href=https://t.me/realtgchat_bot target=_blank>توکن TG Chat</a> قبل از فعال‌سازی',
            'ticket_closed_notification' => 'اطلاع‌رسانی به کاربر هنگام بسته شدن تیکت',
            'ticket_created_notification' => 'اطلاع‌رسانی به مدیر یا کاربر بسته به ایجادکننده تیکت',
            'ticket_replied_notification' => 'اطلاع‌رسانی به طرف دیگر هنگام پاسخ به تیکت',
            'traffic_ban_time' => 'مدت زمان مسدودسازی خودکار برای موارد استثنا',
            'traffic_ban_value' => 'مسدودسازی خودکار حساب در صورت تجاوز از این مقدار در یک ساعت',
            'traffic_limit_time' => 'فاصله زمانی بین چک‌این‌ها',
            'traffic_warning_percent' => 'ارسال اطلاع‌رسانی اتمام داده هنگامی که استفاده روزانه به این درصد برسد',
            'user_invite_days' => 'مدت اعتبار کدهای دعوت ایجاد شده توسط کاربر',
            'username_type' => 'نوع نام کاربری پیش‌فرض برای کاربران',
            'v2ray_tls_provider' => 'تنظیمات گره این پیکربندی TLS را نادیده می‌گیرد',
            'web_api_url' => 'مثال: '.config('app.url'),
            'webmaster_email' => 'ایمیل تماس نمایش داده شده در برخی از پیام‌های خطا',
            'website_analytics' => 'کد جاوا اسکریپت تحلیل وب‌سایت',
            'website_callback_url' => 'جلوگیری از شکست بازگشت پرداخت به دلیل DNS poisoning',
            'website_customer_service' => 'کد جاوا اسکریپت خدمات مشتری',
            'website_name' => 'نام وب‌سایت در ایمیل‌ها',
            'website_security_code' => 'نیاز به کد امنیتی برای دسترسی به سایت در صورت تنظیم',
            'website_url' => 'دامنه اصلی مورد استفاده برای لینک‌ها',
            'wechat_aid' => '<a href="https://work.weixin.qq.com/wework_admin/frame#apps" target="_blank">مدیریت برنامه</a> -> AgentId',
            'wechat_cid' => 'دریافت از <a href="https://work.weixin.qq.com/wework_admin/frame#profile" target="_blank">اطلاعات شرکت</a>',
            'wechat_encodingAESKey' => 'مدیریت برنامه -> تنظیمات برنامه -> EncodingAESKey',
            'wechat_secret' => 'رمز برنامه (ممکن است نیاز به دانلود WeChat Enterprise باشد)',
            'wechat_token' => 'تنظیمات برنامه -> TOKEN، آدرس بازگشت: :url',
        ],
        'iYuu_token' => 'توکن IYUU',
        'invite_num' => 'تعداد دعوت‌نامه‌های پیش‌فرض',
        'is_AliPay' => 'پرداخت علی‌پی',
        'is_QQPay' => 'پرداخت QQ',
        'is_WeChatPay' => 'پرداخت WeChat',
        'is_activate_account' => 'فعال‌سازی حساب',
        'is_ban_status' => 'مسدودسازی خودکار در صورت انقضا',
        'is_captcha' => 'حالت کد امنیتی',
        'is_checkin' => 'افزایش داده با چک‌این',
        'is_clear_log' => 'پاکسازی خودکار لاگ‌ها',
        'is_custom_subscribe' => 'اشتراک پیشرفته',
        'is_email_filtering' => 'فیلتر ایمیل',
        'is_forbid_robot' => 'مسدودسازی ربات‌ها',
        'is_free_code' => 'کد دعوت رایگان',
        'is_invite_register' => 'ثبت‌نام با دعوت',
        'is_otherPay' => 'پرداخت خاص',
        'is_rand_port' => 'پورت تصادفی',
        'is_register' => 'ثبت‌نام کاربران',
        'is_subscribe_ban' => 'مسدودسازی خودکار درخواست‌های اشتراک غیرعادی',
        'is_traffic_ban' => 'مسدودسازی خودکار در صورت استفاده غیرعادی از داده',
        'maintenance_content' => 'محتوای معرفی نگهداری',
        'maintenance_mode' => 'حالت نگهداری',
        'maintenance_time' => 'زمان پایان نگهداری',
        'min_port' => 'محدوده پورت',
        'min_rand_traffic' => 'محدوده داده',
        'node_blocked_notification' => 'اطلاع‌رسانی انسداد گره',
        'node_daily_notification' => 'گزارش روزانه مصرف گره',
        'node_offline_notification' => 'اطلاع‌رسانی آفلاین شدن گره',
        'node_renewal_notification' => 'اطلاعیه تمدید گره',
        'notification' => [
            'channel' => [
                'bark' => 'Bark',
                'dingtalk' => 'DingTalk',
                'email' => 'ایمیل',
                'iyuu' => 'IYUU',
                'pushdeer' => 'PushDeer',
                'pushplus' => 'PushPlus',
                'serverchan' => 'ServerChan',
                'site' => 'اعلان درون سایت',
                'telegram' => 'تلگرام',
                'tg_chat' => 'TG Chat',
                'wechat' => 'WeChat Enterprise',
            ],
            'send_test' => 'ارسال پیام آزمایشی',
            'test' => [
                'content' => 'محتوای آزمون',
                'success' => 'ارسال با موفقیت انجام شد. لطفاً تلفن خود را برای دریافت اعلان پوش بررسی کنید.',
                'title' => 'این یک عنوان آزمایشی است',
                'unknown_channel' => 'کانال ناشناخته',
            ],
        ],
        'oauth_path' => 'پلتفرم‌های ورود شخص ثالث',
        'offline_check_times' => 'تعداد اطلاع‌رسانی‌های آفلاین',
        'params_required' => 'لطفاً ابتدا پارامترهای ضروری برای این :attribute را کامل کنید!',
        'password_reset_notification' => 'اطلاع‌رسانی بازنشانی رمز عبور',
        'paybeaver_app_id' => 'شناسه برنامه PayBeaver',
        'paybeaver_app_secret' => 'رمز برنامه PayBeaver',
        'payjs_key' => 'کلید PayJs',
        'payjs_mch_id' => 'شناسه بازرگان PayJs',
        'payment' => [
            'attribute' => 'درگاه پرداخت',
            'channel' => [
                'alipay' => 'Alipay F2F',
                'codepay' => 'CodePay',
                'epay' => 'ePay',
                'manual' => 'پرداخت دستی',
                'paybeaver' => 'PayBeaver',
                'payjs' => 'PayJs',
                'paypal' => 'PayPal',
                'stripe' => 'Stripe',
                'theadpay' => 'THeadPay',
            ],
            'hint' => [
                'alipay' => 'این ویژگی نیاز به رفتن به <a href="https://open.alipay.com/platform/appManage.htm?#/create/" target="_blank">پلتفرم باز خدمات مالی Ant</a> برای درخواست مجوز و برنامه دارد',
                'codepay' => 'لطفاً به <a href="https://codepay.fateqq.com/i/377289" target="_blank">CodePay</a> بروید و یک حساب کاربری درخواست دهید، سپس نرم‌افزار آن را دانلود و تنظیم کنید',
                'manual' => 'پس از تنظیم و انتخاب درگاه پرداخت، در سمت کاربر نمایش داده می‌شود',
                'paybeaver' => 'لطفاً به <a href="https://merchant.paybeaver.com/?aff_code=iK4GNuX8" target="_blank">PayBeaver</a> بروید و یک حساب کاربری درخواست دهید',
                'payjs' => 'لطفاً به <a href="https://payjs.cn/ref/zgxjnb" target="_blank">PayJs</a> بروید و یک حساب کاربری درخواست دهید',
                'paypal' => 'با حساب بازرگانی خود وارد <a href="https://www.paypal.com/businessprofile/mytools/apiaccess/firstparty" target="_blank">صفحه درخواست اعتبار API</a> شوید، موافقت کنید و اطلاعات تنظیمات را دریافت کنید',
                'theadpay' => 'لطفاً به <a href="https://theadpay.com/" target="_blank">THeadPay</a> بروید و یک حساب کاربری درخواست دهید',
            ],
        ],
        'payment_confirm_notification' => 'اطلاع‌رسانی تأیید پرداخت دستی',
        'payment_received_notification' => 'اطلاع‌رسانی موفقیت پرداخت',
        'paypal_app_id' => 'شناسه برنامه PayPal',
        'paypal_client_id' => 'شناسه مشتری PayPal',
        'paypal_client_secret' => 'کلید مخفی PayPal',
        'placeholder' => [
            'bark_key' => 'پر کردن کلید دستگاه Bark سپس کلیک بر روی به‌روزرسانی',
            'codepay_url' => 'https://codepay.fatq.com/create_order/?',
            'default_url' => 'پیش‌فرض به عنوان :url',
            'dingTalk_access_token' => 'توکن دسترسی ربات سفارشی',
            'dingTalk_secret' => 'رمز ربات سفارشی پس از امضا',
            'iYuu_token' => 'پر کردن توکن IYUU سپس کلیک بر روی به‌روزرسانی',
            'pushDeer_key' => 'پر کردن کلید PushDeer سپس کلیک بر روی به‌روزرسانی',
            'pushplus_token' => 'لطفاً در ServerChan درخواست دهید',
            'server_chan_key' => 'پر کردن SCKEY ServerChan سپس کلیک بر روی به‌روزرسانی',
            'telegram_token' => 'پر کردن توکن Telegram سپس کلیک بر روی به‌روزرسانی',
            'tg_chat_token' => 'لطفاً در Telegram درخواست دهید',
            'wechat_aid' => 'شناسه برنامه WeChat Enterprise',
            'wechat_cid' => 'پر کردن CID WeChat سپس کلیک بر روی به‌روزرسانی',
            'wechat_secret' => 'رمز برنامه WeChat Enterprise',
        ],
        'pushDeer_key' => 'کلید PushDeer',
        'pushplus_token' => 'توکن PushPlus',
        'rand_subscribe' => 'اشتراک تصادفی',
        'redirect_url' => 'URL تغییر مسیر',
        'referral' => [
            'loop' => 'بازگشت وجه دائمی',
            'once' => 'بازگشت وجه اولین خرید',
        ],
        'referral_money' => 'حداقل مبلغ برداشت',
        'referral_percent' => 'درصد بازگشت وجه',
        'referral_status' => 'وضعیت معرفی',
        'referral_traffic' => 'هدیه داده برای ثبت‌نام با لینک معرفی',
        'referral_type' => 'نوع بازگشت وجه',
        'register_ip_limit' => 'محدودیت ثبت‌نام با IP مشابه',
        'reset_password_times' => 'تعداد بازنشانی رمز عبور',
        'reset_traffic' => 'بازنشانی خودکار داده',
        'server_chan_key' => 'کلید ServerChan',
        'standard_currency' => 'واحد پول اصلی',
        'stripe_public_key' => 'کلید عمومی Stripe',
        'stripe_secret_key' => 'کلید مخفی Stripe',
        'stripe_signing_secret' => 'رمز امضای WebHook',
        'subject_name' => 'نام محصول سفارشی',
        'subscribe_ban_times' => 'حداکثر تعداد درخواست‌های اشتراک',
        'subscribe_domain' => 'آدرس اشتراک',
        'subscribe_max' => 'حداکثر تعداد گره‌های اشتراک',
        'telegram_token' => 'توکن Telegram',
        'tg_chat_token' => 'توکن TG Chat',
        'theadpay_key' => 'کلید THeadPay',
        'theadpay_mchid' => 'شناسه بازرگان THeadPay',
        'theadpay_url' => 'URL THeadPay',
        'ticket_closed_notification' => 'اطلاع‌رسانی بسته شدن تیکت',
        'ticket_created_notification' => 'اطلاع‌رسانی ایجاد تیکت جدید',
        'ticket_replied_notification' => 'اطلاع‌رسانی پاسخ به تیکت',
        'traffic_ban_time' => 'مدت زمان مسدودسازی',
        'traffic_ban_value' => 'آستانه استفاده غیرعادی از داده',
        'traffic_limit_time' => 'فاصله زمانی بین چک‌این‌ها',
        'traffic_warning_percent' => 'آستانه هشدار استفاده از داده',
        'trojan_license' => 'مجوز Trojan',
        'user_invite_days' => 'مدت اعتبار دعوت‌نامه کاربر',
        'username' => [
            'any' => 'هر نام کاربری',
            'email' => 'ایمیل',
            'mobile' => 'شماره تلفن',
        ],
        'username_type' => 'نوع نام کاربری',
        'v2ray_license' => 'مجوز V2Ray',
        'v2ray_tls_provider' => 'تنظیمات TLS برای V2Ray',
        'web_api_url' => 'آدرس API',
        'webmaster_email' => 'ایمیل مدیر سایت',
        'website_analytics' => 'کد آمار وب‌سایت',
        'website_callback_url' => 'آدرس بازگشت پرداخت',
        'website_customer_service' => 'کد خدمات مشتری',
        'website_home_logo' => 'لوگو صفحه اصلی',
        'website_logo' => 'لوگو سایت',
        'website_name' => 'نام وب‌سایت',
        'website_security_code' => 'کد امنیتی وب‌سایت',
        'website_url' => 'آدرس وب‌سایت',
        'wechat_aid' => 'شناسه برنامه WeChat',
        'wechat_cid' => 'شناسه شرکت WeChat',
        'wechat_encodingAESKey' => 'کلید رمزنگاری AES WeChat',
        'wechat_qrcode' => 'کد QR WeChat',
        'wechat_secret' => 'رمز WeChat',
        'wechat_token' => 'توکن WeChat',
    ],
    'system_generate' => 'تولید شده توسط سیستم',
    'ticket' => [
        'close_confirm' => 'آیا می‌خواهید این تیکت را ببندید؟',
        'counts' => 'مجموع <code>:num</code> تیکت',
        'error' => 'خطای ناشناخته! لطفاً لاگ‌ها را بررسی کنید',
        'inviter_info' => 'اطلاعات دعوت‌کننده',
        'self_send' => 'نمی‌توانید برای خودتان تیکت ایجاد کنید!',
        'send_to' => 'لطفاً جزئیات کاربر هدف را وارد کنید',
        'title' => 'تیکت‌ها',
        'user_info' => 'اطلاعات کاربر',
    ],
    'times' => 'بار',
    'tools' => [
        'analysis' => [
            'file_missing' => ':file_name وجود ندارد. لطفاً ابتدا فایل را ایجاد کنید.',
            'not_enough' => 'کمتر از 15000 رکورد، قادر به تحلیل نیست',
            'req_url' => 'سوابق URL درخواست‌های اخیر',
            'title' => 'تحلیل لاگ SSR <small>فقط برای یک گره</small>',
        ],
        'convert' => [
            'content_placeholder' => 'لطفاً اطلاعات پیکربندی که نیاز به تبدیل دارند را وارد کنید.',
            'file_missing' => 'فایل پیدا نشد. لطفاً مجوزهای دایرکتوری را بررسی کنید.',
            'missing_error' => 'تبدیل ناموفق: اطلاعات پیکربندی فاقد فیلد [port_password] است یا این فیلد خالی است.',
            'params_unknown' => 'استثنای پارامتر',
            'title' => 'تبدیل فرمت <small>SS به SSR</small>',
        ],
        'decompile' => [
            'attribute' => 'لینک پیکربندی دی‌کامپایل',
            'content_placeholder' => 'لطفاً لینک‌های ShadowsocksR که نیاز به دی‌کامپایل دارند را وارد کنید، با خط جدا شوند.',
            'title' => 'دی‌کامپایل <small>اطلاعات پیکربندی</small>',
        ],
        'import' => [
            'file_error' => 'خطای ناشناخته‌ای رخ داده است. لطفاً دوباره بارگذاری کنید.',
            'file_required' => 'لطفاً فایلی را برای بارگذاری انتخاب کنید',
            'file_type_error' => 'فقط فایل‌های نوع :type برای بارگذاری مجاز هستند.',
            'format_error' => 'خطای تجزیه فرمت محتوا. لطفاً فایلی از نوع :type که با فرمت مشخص شده مطابقت دارد بارگذاری کنید.',
        ],
    ],
    'unselected_hint' => 'قوانینی که باید تخصیص داده شوند، اینجا قابل جستجو هستند',
    'user' => [
        'admin_deletion' => 'مدیران سیستم را نمی‌توان حذف کرد',
        'bulk_account_quantity' => 'تعداد حساب‌های تولید شده به‌صورت عمده',
        'connection_test' => 'تست اتصال',
        'counts' => 'مجموع <code>:num</code> حساب',
        'group' => [
            'counts' => 'مجموع <code>:num</code> گروه',
            'name' => 'نام گروه',
            'title' => 'کنترل گروه‌های کاربری<small> (یک گره می‌تواند در چندین گروه باشد، اما کاربر فقط می‌تواند در یک گروه باشد؛ برای گره‌های قابل مشاهده/قابل استفاده برای کاربران، گروه اولویت بیشتری نسبت به سطح دارد)</small>',
        ],
        'info' => [
            'account' => 'اطلاعات حساب',
            'expired_date_hint' => 'اگر خالی بماند، پیش‌فرض یک سال اعتبار دارد',
            'proxy' => 'اطلاعات پروکسی',
            'recharge_placeholder' => 'اگر منفی باشد، موجودی کسر می‌شود',
            'reset_date_hint' => 'تاریخ بازنشانی بعدی ترافیک',
            'switch' => 'تغییر هویت',
            'uuid_hint' => 'UUID برای V2Ray',
        ],
        'online_monitor' => 'نظارت آنلاین',
        'proxies_config' => 'اطلاعات اتصال برای :username',
        'proxy_info' => 'اطلاعات پیکربندی',
        'reset_confirm' => [0 => 'آیا می‌خواهید ترافیک [', 1 => '] را بازنشانی کنید؟'],
        'reset_traffic' => 'بازنشانی ترافیک',
        'traffic_monitor' => 'آمار ترافیک',
        'update_help' => 'به‌روزرسانی موفقیت‌آمیز بود، بازگردید؟',
        'user_view' => 'تغییر به نمای کاربر',
    ],
    'user_dashboard' => 'مرکز کاربری',
    'yes' => 'بله',
    'zero_unlimited_hint' => '0 یا خالی برای نامحدود',
];
