<?php

declare(strict_types=1);

return [
    'account' => [
        'connect_password' => 'Proxy Connection Password',
        'credit' => 'Account Balance',
        'group' => 'Group',
        'last_login' => 'Last Login',
        'level' => 'Account Level',
        'reason' => [
            'expired' => 'Your plan has expired',
            'normal' => 'Account is normal',
            'overused' => 'You have exceeded the <code>:data</code> GB limit for this period<br/> Limit will be lifted in <code id="banedTime">:min</code> minutes',
            'traffic_exhausted' => 'Data has been exhausted',
            'unknown' => 'Unknown reason, please try refreshing the browser! If the problem persists, contact support.',
        ],
        'remain' => 'Remaining Data',
        'reset' => '{0} Data will reset in <code id="restTime">:days</code> |{1} :days day left to reset data |[2,*] :days days left to reset data',
        'speed_limit' => 'Speed Limit',
        'status' => 'Account Status',
        'time' => 'Plan Duration',
    ],
    'attribute' => [
        'address' => 'Location',
        'data' => 'Data',
        'ip' => 'IP Address',
        'isp' => 'ISP',
        'node' => 'Node',
    ],
    'bought_at' => 'Purchase Date',
    'clients' => 'Clients',
    'contact' => 'Contact',
    'coupon' => [
        'discount' => 'Discount',
        'error' => [
            'expired' => 'Coupon expired',
            'inactive' => 'Coupon not active',
            'minimum' => 'Minimum amount is :amount',
            'overused' => 'Can only be used :times times',
            'run_out' => 'Coupon exhausted',
            'services' => 'Goods not eligible for discount, check promotional terms',
            'unknown' => 'Invalid coupon',
            'unmet' => 'Conditions not met',
            'used' => 'Coupon already used',
            'users' => 'Account not eligible for promotion',
            'wait' => 'Will be active at :time, please wait!',
        ],
        'input' => 'Please enter the recharge coupon code',
    ],
    'current_role' => 'Current Role as',
    'error_response' => 'An error occurred, please try again later.',
    'home' => [
        'announcement' => 'Announcements',
        'attendance' => [
            'attribute' => 'Check In',
            'disable' => 'Check-in disabled',
            'done' => 'You have already checked in. Come back tomorrow!',
            'failed' => 'System error',
            'success' => 'You received <strong>:data $</strong> for checking in today!',
        ],
        'chat_group' => 'Chat Group',
        'empty_announcement' => 'No announcements',
        'traffic_logs' => 'Data Records',
        'wechat_push' => 'WeChat Notifications',
    ],
    'invite' => [
        'attribute' => 'Invitation Code',
        'counts' => 'Total of <code>:num</code> invitation codes',
        'generate_failed' => 'Failed to generate: Quota exceeded',
        'logs' => 'Invitation Logs',
        'promotion' => 'Both you and the invitee will receive <mark>:traffic</mark> data when they register with your code; You will earn <mark>:referral_percent%</mark> commission when they make a purchase.',
        'tips' => '<strong>:num</strong> invitations remaining, codes expire :days days after creation',
    ],
    'invitee' => 'Invitee',
    'inviter' => 'Inviter',
    'invoice' => [
        'active_prepaid_question' => 'Activate prepaid package early?',
        'active_prepaid_tips' => 'After activation:<br>Your current plan will immediately expire<br>The new plan\'s expiration date will be recalculated from today',
        'amount' => 'Amount',
        'attribute' => 'Order',
        'detail' => 'Order Details',
    ],
    'knowledge' => [
        'basic' => 'Basic',
        'title' => 'Knowledge Base',
    ],
    'menu' => [
        'admin_dashboard' => 'Dashboard',
        'help' => 'Help',
        'home' => 'Home',
        'invites' => 'Invite',
        'invoices' => 'Invoice',
        'nodes' => 'Nodes',
        'profile' => 'Profile',
        'promotion' => 'Referral',
        'shop' => 'Shop',
        'tickets' => 'Tickets',
    ],
    'node' => [
        'info' => 'Configuration Info',
        'rate' => ':ratio times data consumption',
        'setting' => 'Proxy Settings',
        'unstable' => 'Unstable/Maintenance',
    ],
    'oauth' => [
        'bind' => 'Link',
        'bind_title' => 'Link Your Social Account',
        'not_bind' => 'Not Linked',
        'rebind' => 'Re-link',
        'unbind' => 'Unlink',
    ],
    'pay' => 'Pay',
    'payment' => [
        'title' => 'Payment',
        'close_tips' => 'Complete the payment within <code>:minutes</code> minutes, or the order will close automatically',
        'creating' => 'Creating payment...',
        'error' => 'Invalid recharge amount',
        'insufficient_balance' => 'Your balance is insufficient. Please recharge first.',
        'manual' => [
            'hint' => 'After scanning the QR code to pay, please follow the steps until you click Submit to complete the payment.',
            'next' => 'Next',
            'payment_tips' => 'When making the payment, please pay the exact amount (no refunds for overpayment, additional payment required if underpaid).',
            'pre' => 'Previous',
            'red_packet' => 'Alipay Red Packet',
            'steps' => [
                'complete' => [
                    'description' => 'Waiting for manual payment verification',
                    'title' => 'Completion',
                ],
                'notice' => [
                    'description' => 'How to make a manual payment',
                    'title' => 'Notes',
                ],
                'payment' => [
                    'description' => 'Get the payment QR code and pay',
                    'title' => 'Payment',
                ],
                'remark' => [
                    'description' => 'Enter your login account for manual verification',
                    'title' => 'Add a note',
                ],
            ],
        ],
        'method' => 'Payment Method',
        'mobile_tips' => '<strong>Mobile Users:</strong> Long press the QR code -> Save image -> Open payment app -> Scan image to pay',
        'order_creation' => [
            'failed' => 'Order creation failed. Please try a different payment method!',
            'info' => 'We will review your purchase/recharge within [24 hours]! Please be patient.',
            'order_limit' => 'This item is limited to :limit_num purchases. You have already bought :count times.',
            'order_timeout' => 'The order timed out and was automatically closed due to non-payment.',
            'payment_disabled' => 'Order creation failed: Online payment feature is not enabled.',
            'pending_order' => 'Order creation failed: There are pending orders. Please complete those payments first.',
            'plan_required' => 'Please purchase a plan before buying the recharge package.',
            'price_issue' => 'Order creation failed: Abnormal total order price',
            'price_zero' => 'Order creation failed: The total order price is 0; online payment is not required.',
            'product_unavailable' => 'Order creation failed: The item has been removed from sale.',
            'success' => 'Order created successfully!',
            'unknown_order' => 'Unknown order',
            'unknown_payment' => 'Unknown payment method',
        ],
        'qrcode_tips' => 'Please scan with <strong class="red-600">:software</strong>',
        'redirect_stripe' => 'Redirecting to Stripe',
        'default_order_info' => 'Payment for transaction :trade_no',
        'redirecting_to_gateway' => 'Redirecting to payment gateway...',
        'momo_api_error' => 'Momo API error, please try again later.',
        'try_manual_payment' => 'If the payment fails, please try manual payment.',
        'momo_connection_error' => 'Failed to connect to Momo API, please try again later.',
        'system_error_gateway' => 'System error, please try again later.',
        'momo_amount_mismatch_detail' => 'The amount you entered does not match the order amount. Please check and try again.',
        'momo_failed_ipn' => 'Failed to process Momo IPN, please try again later.',
        'processing_payment_for_order' => 'Processing payment for order #:trade_no',
        'payment_successful' => 'Payment successful',
        'thank_you_for_your_payment' => 'Thank you for your payment',
        'credit_added_to_account' => 'Credit added to your account',
        'back_to_home' => 'Home',
        'order_processed_successfully' => 'Order processed successfully',
        'view_order_details' => 'View order details',
        'payment_pending_confirmation' => 'Payment pending confirmation',
        'pending_confirmation_message' => 'Your payment is pending confirmation. Please wait while we process it.',
        'view_order_status' => 'View order status',
        'order_not_found_return' => 'Order not found, return to homepage',
        'order_payment_desc_default' => 'Payment for order #:trade_no',
        'general_payment_desc' => 'Payment for order #:trade_no',
        'error_processing_payment' => 'Error processing payment, please try again later.',
        'log_credit_payment_generic' => 'User credit payment for order #:trade_no',
        'log_purchase_item_credit' => 'User purchased item with credit, order #:order_sn',
        'error_finalizing_order' => 'Error finalizing order, please contact support.',
        'method_not_specified' => 'Payment method not specified',
        'order_not_found' => 'Order not found',
        'order_already_processed_or_cancelled' => 'Order already processed or cancelled',
        'order_payment_desc_goods' => 'Payment for goods order #:order_sn, item: :goods_name',
        'invalid_request_missing_order' => 'Invalid request: Missing order ID',
        'invalid_amount' => 'Invalid amount',
        'return_error_missing_trade_no' => 'Return error: Missing trade number in request',
    ],
    'purchase' => [
        'completed' => 'Purchase completed!',
        'promotion' => 'Don\'t miss out—buy our services today!',
        'required' => 'This feature is available to paid users only. Please',
        'to_unlock' => 'Unlock with Purchase',
    ],
    'recharge' => 'Recharge',
    'recharge_credit' => 'Credit Recharge',
    'recharging' => 'Recharging...',
    'referral' => [
        'link' => 'Referral Link',
        'logs' => 'Commission Logs',
        'msg' => [
            'account' => 'Account expired, please purchase a plan first',
            'applied' => 'Existing request, please wait for processing',
            'error' => 'Error creating order, try again later or contact support',
            'unfulfilled' => 'Need :amount to withdraw, keep going!',
            'wait' => 'Please wait for admin approval',
        ],
        'total' => 'Total commission: :amount (:total times), can withdraw when over :money',
    ],
    'registered_at' => 'Registration Date',
    'reset_data' => [
        'action' => 'Reset Data',
        'cost' => 'Cost: <code>:amount</code>',
        'cost_tips' => 'The reset will deduct :amount!',
    ],
    'scan_qrcode' => 'Scan QR code with client',
    'service' => [
        'country_count' => 'Covers <code>:num</code> countries or regions',
        'node_count' => '<code>:num</code> high-quality nodes',
        'unlimited' => 'Unlimited speed',
    ],
    'shop' => [
        'buy' => 'Buy',
        'call4help' => 'Contact support if you have any questions',
        'change_amount' => 'Recharge Amount',
        'change_amount_help' => 'Enter recharge amount',
        'conflict' => 'Conflict',
        'conflict_tips' => '<p>The current purchase will be set as a <code>prepaid plan</code></p><ol><li>Prepaid plan will automatically activate after current plan expires</li><li>You can manually activate it after payment</li></ol>',
        'description' => 'Description',
        'hot' => 'Hot',
        'limited' => 'Limited',
        'pay_credit' => 'Pay with Credit',
        'pay_online' => 'Pay Online',
        'price' => 'Price',
        'quantity' => 'Quantity',
        'service' => 'Service',
        'subtotal' => 'Subtotal',
        'total' => 'Total',
    ],
    'subscribe' => [
        'custom' => 'Custom Subscription',
        'error' => 'Error changing subscription link',
        'exchange_warning' => 'Changing the subscription link will:\n1. Revoke the current link immediately\n2. Change the connection password',
        'info' => [
            'download' => 'Download',
            'title' => 'Account Summary [Non-Realtime]',
            'total' => 'Plan Data',
            'upload' => 'Upload',
        ],
        'link' => 'Subscription Link',
        'ss_only' => 'Subscribe SS only',
        'ssr_only' => 'Subscribe SSR (incl. SS) only',
        'tips' => 'Warning: This link is for personal use only. Do not share it, or your account may be banned for abnormal usage.',
        'trojan_only' => 'Subscribe Trojan only',
        'v2ray_only' => 'Subscribe V2Ray only',
    ],
    'telegram' => [
        'bind_exists' => 'This account is already linked to a Telegram account.',
        'bind_missing' => 'No user information found. Please link your account first.',
        'command' => [
            'bind' => 'Link your :web_name account',
            'intro' => 'You can use the following commands',
            'traffic' => 'Check data usage',
            'unbind' => 'Unlink',
            'web_url' => 'Get the latest :web_name URL',
        ],
        'get_url' => 'The latest URL for :web_name is',
        'params_missing' => 'Invalid parameters. Please include your email address and resend.',
        'ticket_missing' => 'Ticket does not exist',
        'ticket_reply' => 'Reply to ticket #`:id` was successful',
        'traffic_query' => 'Data usage query',
        'user_missing' => 'User does not exist',
    ],
    'ticket' => [
        'attribute' => 'Ticket',
        'close_msg' => 'Ticket ID :id closed by user',
        'close_tips' => 'Confirm close ticket?',
        'content_placeholder' => 'Provide detailed description of your issue to help us assist you better',
        'error' => 'Unknown error! Please contact support',
        'new' => 'Create New Ticket',
        'online_hour' => 'Online Hours',
        'reply' => 'Reply',
        'reply_confirm' => 'Confirm reply ticket?',
        'reply_placeholder' => 'Write something...',
        'service_hours' => 'Customer Service Hours',
        'service_tips' => 'Please use only <code>one</code> contact method to reach support! Repeated requests will delay response time.',
        'submit_tips' => 'Confirm submit ticket?',
        'title_placeholder' => 'Briefly describe your issue',
    ],
    'traffic_logs' => [
        'daily' => 'This Month\'s Data Usage',
        'hourly' => 'Today\'s Data Usage',
        'tips' => 'Note: There is a delay in data statistics updates.',
    ],
    'tutorials' => 'Tutorials',
    'withdraw' => 'Withdraw',
    'withdraw_at' => 'Withdrawal Date',
    'withdraw_commission' => 'Withdraw Commission',
    'withdraw_logs' => 'Withdrawal Logs',
    'tasks' => 'Tasks',
    'get_tasks' => 'Get Tasks',
    'check_in' => 'Check In',
    'check_in_success' => 'Check-in successful',
    'check_in_failed' => 'Check-in failed! Please try again later.',
    'check_in_already' => 'You have already checked in today! Come back tomorrow.',
    'check_in_disabled' => 'Check-in feature is disabled.',
    'check_in_tips' => 'Check in daily to earn rewards!',
    'task' => [
        'unauthorized' => 'Unauthorized access to this task.',
        'daily_limit_reached' => 'You have reached the daily limit of tasks.',
        'no_available_tasks' => 'No available tasks at the moment.',
        'no_available_tasks_try_later' => 'No tasks available. Please try again later.',
        'task_unavailable_or_assigned' => 'Task unavailable or already assigned.',
        'accepted_successfully' => 'Task accepted successfully!',
        'cannot_access_task' => 'You cannot access this task.',
        'deadline_passed' => 'Deadline has passed.',
        'deadline_passed_cannot_submit' => 'Deadline has passed. You cannot submit a report.',
        'report_submitted_successfully' => 'Report submitted successfully!',
        'perform_task_title' => 'Perform Task',
        'task_details' => 'Task Details',
        'gmap_link' => 'Link Google Maps',
        'description' => 'Description',
        'quantity' => 'Quantity',
        'drive_link' => 'Link Drive',
        'reward' => 'Reward',
        'assigned_at' => 'Assigned At',
        'deadline_at' => 'Deadline At',
        'time_remaining' => 'Time Remaining',
        'submit_report' => 'Submit Report',
        'report_notes_label' => 'Report Notes',
        'report_notes_placeholder' => 'Please provide details about the task',
        'submit_report_button' => 'Submit Report',
        'expired' => 'Expired',
        'fetching_task' => 'Fetching task...',
        'new_task_available' => 'New task available!',
        'accept_task' => 'Accept Task',
        'no_task_info' => 'No task information available',
        'no_available_tasks_try_later' => 'No available tasks at the moment. Please try again later.',
        'deadline_was' => 'Deadline was',
        'cannot_submit_report' => 'You cannot submit a report for this task.',
        'task_unavailable_or_fully_assigned' => 'Task unavailable or fully assigned.',
        'already_assigned_or_completed_this_task' => 'You have already been assigned or completed this task.',
        'assignment_status' => [
            'in_progress' => 'In Progress',
            'reported'    => 'Reported',
            'completed'   => 'Completed',
            'rejected'    => 'Rejected',
        ],
        'title' => 'My Tasks History',
        'task_id' => 'Task ID',
        'submitted_at' => 'Submitted At',
        'status' => 'Status',
        'actions' => 'Actions',
        'perform_task' => 'Perform Task',
        'view_report' => 'View Report',
        'no_tasks' => 'You have not been assigned any tasks yet or have not performed any.',
        'get_tasks_cta' => 'Click here to find new tasks!', // Call to action if no tasks
        'report_notes_label' => 'Report Notes',
        'report_notes_placeholder' => 'Please provide details about the task',
    ],
    'status' => [
        'pending_admin_approval' => 'Pending Approval',
        'approved' => 'Approved',
        'distributing' => 'Distributing',
        'in_progress' => 'In Progress',
        'reported' => 'Reported',
        'completed' => 'Completed',
        'rejected' => 'Rejected',
        'expired' => 'Expired',
        'cancelled' => 'Cancelled',
        'unknown' => 'Unknown',
        'pending' => 'Pending',
        'active' => 'Active',
        'inactive' => 'Inactive',
        'suspended' => 'suspended',
        'banned' => 'Banned',
        'disabled' => 'Disabled',
    ],
    'currency' => 'USD',
    'withdraw' => [
        'menu_title' => 'Withdraw',
        'history_title' => 'Withdrawal History',
        'request_new_title' => 'Request New Withdrawal',
        'request_new' => 'New Request',
        'amount' => 'Amount',
        'amount_to_withdraw' => 'Amount to Withdraw',
        'enter_amount' => 'Enter amount',
        'payment_method' => 'Payment Method',
        'payment_method_select' => 'Payment Method',
        'select_method' => 'Select Method',
        'payment_details_short' => 'Details',
        'payment_details_title' => 'Payment Details',
        'details_heading' => 'Account Details',
        'status' => [
            'title' => 'Status',
            'pending' => 'Pending',
            'approved' => 'Approved',
            'rejected' => 'Rejected',
            'paid' => 'Paid',
        ],
        'requested_at' => 'Requested At',
        'processed_at' => 'Processed At',
        'admin_notes' => 'Admin Notes',
        'user_notes' => 'Your Notes',
        'user_notes_label' => 'Notes',
        'bank_transfer' => 'Bank Transfer',
        'momo' => 'Momo E-Wallet',
        'crypto' => 'Crypto Wallet',
        'crypto_details_title' => 'Crypto Wallet Details',
        'crypto_wallet' => 'Crypto Wallet Address',
        'crypto_network' => 'Network (Blockchain)',
        'bank_details_title' => 'Bank Account Details',
        'bank_name' => 'Bank Name',
        'account_number' => 'Account Number',
        'account_number_or_phone' => 'Account Number or Phone Number',
        'account_holder' => 'Account Holder Name',
        'momo_details_title' => 'Momo Account Details',
        'momo_phone' => 'Momo Phone Number',
        'momo_name' => 'Momo Account Name',
        'submit_request' => 'Submit Request',
        'insufficient_credit' => 'Insufficient credit to make this withdrawal.',
        'insufficient_credit_for_min' => 'Your credit is less than the minimum withdrawal amount of :min_amount.',
        'insufficient_credit_for_min_short' => 'Credit less than :min_amount to withdraw.',
        'request_successful' => 'Withdrawal request submitted successfully. Please wait for admin approval.',
        'request_failed' => 'Failed to submit withdrawal request. Please try again.',
        'request_failed_credit_update' => 'Failed to update credit. Please try again.',
        'log_request_created' => 'Withdrawal request created for :amount.',
        'log_request_rejected' => 'Withdrawal request #ID rejected, :amount credit refunded.',
        'amount_min_validation' => 'The withdrawal amount must be at least :min_amount.',
        'amount_max_validation' => 'The withdrawal amount cannot exceed your current credit of :max_credit.',
        'no_requests_yet' => 'You have not made any withdrawal requests yet.',
        'create_one_now' => 'Create one now!',
        'current_credit' => 'Your current credit',
        'min_amount_display' => 'Minimum withdrawal amount',
        'max_amount_display' => 'Maximum withdrawal amount',
    ],
    'product' => [
        'title' => 'Product',
        'name' => 'Product Name',
        'price' => 'Price',
        'description' => 'Description',
        'status' => 'Status',
        'action' => 'Action',
        'active' => 'Active',
        'inactive' => 'Inactive',
        'edit' => 'Edit Product',
        'delete' => 'Delete Product',
        'create' => 'Create Product',
        'update' => 'Update Product',
        'create_success' => 'Product created successfully!',
        'update_success' => 'Product updated successfully!',
        'delete_success' => 'Product deleted successfully!',
        'delete_failed' => 'Failed to delete product. Please try again.',
        'product_not_found' => 'Product not found.',
        'product_exists' => 'Product already exists.',
        'product_created' => 'Product created successfully.',
        'product_updated' => 'Product updated successfully.',
        'product_deleted' => 'Product deleted successfully.',
        'product_create_failed' => 'Failed to create product. Please try again.',
        'product_update_failed' => 'Failed to update product. Please try again.',
        'product_delete_failed' => 'Failed to delete product. Please try again.',
        'product_name_required' => 'Product name is required.', 
    ],
    'deposit' => [
        'title' => 'Deposit',
        'history_title' => 'Deposit History',
        'no_history' => 'No deposit history found.',
        'amount' => 'Deposit Amount',
        'method' => 'Payment Method',
        'status' => 'Status',
        'action' => 'Action',
        'pending' => 'Pending',
        'completed' => 'Completed',
        'failed' => 'Failed',
        'initiate_deposit' => 'Initiate Deposit',
        'deposit_successful' => 'Deposit successful!',
        'deposit_failed' => 'Deposit failed. Please try again.',
        'create_success' => 'Deposit successful!',
        'update_success' => 'Deposit update successful!',
        'delete_success' => 'Deposit deletion successful!',
        'no_methods_available' => 'No deposit methods available.',
        'method_not_found' => 'Deposit method not found.',
        'method_exists' => 'Deposit method already exists.',
        'method_created' => 'Deposit method created successfully.',
        'method_updated' => 'Deposit method updated successfully.',
        'method_deleted' => 'Deposit method deleted successfully.',
        'method_create_failed' => 'Failed to create deposit method. Please try again.',
        'method_update_failed' => 'Failed to update deposit method. Please try again.',
        'method_delete_failed' => 'Failed to delete deposit method. Please try again.',
        'method_name_required' => 'Deposit method name is required.',
        'method_amount_required' => 'Deposit amount is required.',
        'method_status_required' => 'Deposit method status is required.',
        'method_action_required' => 'Deposit method action is required.',
        'method_pending' => 'Pending',
        'method_completed' => 'Completed',
        'method_failed' => 'Failed',
        'method_pending_description' => 'Deposit is pending processing.',
        'method_completed_description' => 'Deposit completed.',
        'method_failed_description' => 'Deposit failed.',
        'amount_to_deposit' => 'Amount to deposit',
        'enter_amount' => 'Enter amount',
        'payment_method' => 'Payment method',
        'select_payment_method' => 'Select payment method',
        'select_method' => 'Select method',
        'payment_details_short' => 'Payment details',
        'payment_details_title' => 'Payment Details',
        'details_heading' => 'Account Information',
        'manual_instructions_scan' => 'Manual payment instructions',
        'manual_instructions' => 'Manual payment instructions',
        'manual_instructions_description' => 'After making the payment, please enter the transaction code and click submit to complete.',
        'manual_instructions_placeholder' => 'Enter your transaction code here...',
        'manual_instructions_button' => 'Submit transaction code',
        'manual_instructions_success' => 'Transaction code submitted successfully. Please wait for admin approval.',
        'after_payment_contact_support' => 'If you encounter any issues during the payment process, please contact support.',
        'after_payment_success' => 'Deposit successful! Please check your account balance.',
        'after_payment_failed' => 'Deposit failed. Please try again.',
        'after_payment_pending' => 'Deposit is pending processing. Please check again later.',
        'min_amount' => 'Minimum amount',
        'max_amount' => 'Maximum amount',
        'min_amount_required' => 'Minimum amount is required.',
        'max_amount_required' => 'Maximum amount is required.',
        'min_amount_is' => 'The minimum amount is :min_amount.',
        'max_amount_is' => 'The maximum amount is :max_amount.',
        'min_amount_alert_js' => 'Minimum amount',
        'description_user_deposit' => 'User: :user, Amount: :amount',
        'log_credit_added' => 'Credit added to user account: :amount',
        'amount_min_validation' => 'The deposit amount must be at least :min_amount.',
        'created_at' => 'Created At',
        'updated_at' => 'Updated At',
        'payment_method_required' => 'Payment method is required.',
    ],
    'orders' => [
        'title' => 'Orders',
        'history_title' => 'Order History',
        'no_history' => 'No order history found.',
        'order_id' => 'Order ID',
        'amount' => 'Amount',
        'status' => 'Status',
        'created_at' => 'Created At',
        'updated_at' => 'Updated At',
        'action' => 'Action',
        'view_details' => 'View Details',
        'details' => [
            'title' => 'Order Details',
            'product_name' => 'Product Name',
            'quantity' => 'Quantity',
            'price' => 'Price',
            'total' => 'Total',
            'status_pending' => 'Pending',
            'status_completed' => 'Completed',
            'status_failed' => 'Failed',
            'status_cancelled' => 'Cancelled',
            'status_refunded' => 'Refunded',
        ],
    ],
    'cart' => [
        'title' => 'Cart',
        'empty' => 'Your cart is empty.',
        'product_id' => 'Product ID',
        'product_title' => 'Product Title',
        'product_image' => 'Product Image',
        'product_name' => 'Product Name',
        'quantity' => 'Quantity',
        'price' => 'Price',
        'total' => 'Total',
        'checkout' => 'Checkout',
        'update_cart' => 'Update Cart',
        'remove_item' => 'Remove Item',
        'continue_shopping' => 'Continue Shopping',
        'checkout_success' => 'Checkout successful! Thank you for your purchase.',
        'checkout_failed' => 'Checkout failed. Please try again.',
    ],
];