<?php

declare(strict_types=1);

return [
    'action' => [
        'add_item' => 'Add :attribute',
        'edit_item' => 'Edit :attribute',
    ],
    'aff' => [
        'apply_counts' => 'Total <code>:num</code> Withdrawal Requests',
        'commission_counts' => 'This application involves a total of <code>:num</code> orders',
        'commission_title' => 'Request Details',
        'counts' => 'Total <code>:num</code> Records',
        'rebate_title' => 'Rebate History',
        'referral' => 'Referral Rebates',
        'title' => 'Withdraw Requests',
    ],
    'article' => [
        'category_hint' => 'Same category will be grouped together',
        'counts' => 'Total <code>:num</code> Articles',
        'logo_placeholder' => 'Or enter logo URL',
        'title' => 'Articles',
        'type' => [
            'announcement' => 'Announcement',
            'knowledge' => 'Article',
        ],
    ],
    'clear' => 'Clear',
    'clone' => 'Clone',
    'confirm' => [
        'continues' => 'Do you want to continue this action?',
        'delete' => [0 => 'Do you want to delete :attributes', 1 => ']?'],
        'export' => 'Do you want to export all?',
    ],
    'coupon' => [
        'counts' => 'Total <code>:num</code> Coupons',
        'created_days_hint' => '<code>:day</code> days after registration',
        'discount' => 'Discount',
        'export_title' => 'Export',
        'groups_hint' => 'Only usable for selected user groups',
        'info_title' => 'Info',
        'levels_hint' => 'Only usable for selected user levels',
        'limit_hint' => 'Rules have <strong>AND</strong> relation, use properly',
        'minimum_hint' => 'Only usable when payment exceeds <strong>:num</strong>',
        'name_hint' => 'For display',
        'newbie' => [
            'created_days' => 'Account Age',
            'first_discount' => 'First-time Discount',
            'first_order' => 'First Order',
        ],
        'priority_hint' => 'Highest eligible priority coupon used first. Max 255',
        'services_blacklist_hint' => 'Not usable for blacklisted products, leave blank if unused',
        'services_placeholder' => 'Enter product ID, press Enter',
        'services_whitelist_hint' => 'Only usable for whitelisted products, leave blank if unused',
        'single_use' => 'One-time Use',
        'sn_hint' => 'Leave blank for 8-digit random code',
        'title' => 'Coupons',
        'type' => [
            'charge' => 'Recharge',
            'discount' => 'Discount',
            'voucher' => 'Voucher',
        ],
        'type_hint' => 'Reduction: deduct amount; Discount: percentage off; Recharge: add amount to balance',
        'used_hint' => 'Each user can use this <strong>:num</strong> times max',
        'user_whitelist_hint' => 'Whitelisted users can use, leave blank if unused',
        'users_blacklist_hint' => 'Blacklisted users cannot use, leave blank if unused',
        'users_placeholder' => 'Enter user ID, press Enter',
        'value' => '{1} ➖ :num|{2} :num% off|{3} ➕ :num',
        'value_hint' => 'Range is 1% to 99%',
    ],
    'creating' => 'Adding...',
    'dashboard' => [
        'abnormal_users' => 'Abnormal Traffic in the Last Hour',
        'active_days_users' => 'Active Users in the Last :days Days',
        'available_users' => 'Active Users',
        'credit' => 'Total Credit',
        'current_month_traffic_consumed' => 'Traffic Used This Month',
        'days_traffic_consumed' => 'Traffic Used in the Last :days Days',
        'expiring_users' => 'Expiring Soon',
        'inactive_days_users' => 'Inactive Users over :days Days',
        'maintaining_nodes' => 'Nodes in Maintenance Mode',
        'nodes' => 'Nodes',
        'online_orders' => 'Online Payment Orders',
        'online_users' => 'Online Now',
        'orders' => 'Total Orders',
        'overuse_users' => 'Data Overuse [≥90%] Users',
        'paid_users' => 'Paying Users',
        'succeed_orders' => 'Paid Orders',
        'users' => 'Total Users',
        'withdrawing_commissions' => 'Pending Commissions',
        'withdrawn_commissions' => 'Withdrawn Commissions',
    ],
    'end_time' => 'End',
    'goods' => [
        'counts' => 'Total <code>:num</code> Items',
        'info' => [
            'available_date_hint' => 'Auto deduct data from total when due',
            'desc_placeholder' => 'Brief description',
            'limit_num_hint' => 'Max number of purchases per user, 0 for unlimited',
            'list_hint' => 'Start each line with <code><li></code> and end with <code></li></code>',
            'list_placeholder' => 'Add custom content',
            'period_hint' => 'Data allowance resets every N days for plans',
            'type_hint' => 'Plan affects account expiration, Package only deducts data, does not affect expiration',
        ],
        'sell_and_used' => 'Used / Sold',
        'status' => [
            'no' => 'Off Sale',
            'yes' => 'On Sale',
        ],
        'title' => 'Products',
        'type' => [
            'package' => 'Data Package',
            'plan' => 'Subscription Plan',
            'top_up' => 'Top Up',
        ],
    ],
    'hint' => 'Hint',
    'logs' => [
        'ban' => [
            'ban_time' => 'Banned On',
            'last_connect_at' => 'Last Login Time',
            'reason' => 'Reason',
            'time' => 'Duration',
            'title' => 'User Bans',
        ],
        'callback' => 'Callback Logs <small>(Payment)</small>',
        'counts' => 'Total <code>:num</code> Records',
        'credit_title' => 'Balance Change Logs',
        'ip_monitor' => 'Online IPs <small>Real-time 2 mins</small>',
        'notification' => 'Email Logs',
        'order' => [
            'is_coupon' => 'Used Coupon',
            'is_expired' => 'Expired',
            'title' => 'Orders',
            'update_conflict' => 'Update failed: Order conflict',
        ],
        'rule' => [
            'clear_all' => 'Clear all records',
            'clear_confirm' => 'Do you want to clear all trigger records?',
            'created_at' => 'Trigger Time',
            'name' => 'Triggered Rule Name',
            'reason' => 'Trigger Reason',
            'tag' => '✅ Accessing Unauthorized Content',
            'title' => 'Rule Trigger Records',
        ],
        'subscribe' => 'Subscriptions',
        'user_data_modify_title' => 'Data Change Records',
        'user_ip' => [
            'connect' => 'Connected IP',
            'title' => 'Online IPs <small>Last 10 mins</small>',
        ],
        'user_traffic' => [
            'choose_node' => 'Select Node',
            'title' => 'Data Usage Records',
        ],
    ],
    'marketing' => [
        'counts' => 'Total <code>:num</code> Messages',
        'email' => [
            'ever_paid' => 'Ever Paid',
            'expired_date' => 'Expired Date',
            'filters' => 'Filters',
            'loading_statistics' => 'Loading Statistics...',
            'never_paid' => 'Never Paid',
            'paid_servicing' => 'Paid Servicing',
            'previously_paid' => 'Used to Pay',
            'recent_traffic_abnormal' => 'Traffic Abnormal in Last Hour',
            'recently_active' => 'Recently Active',
            'targeted_users_count' => 'Targeted Users Count',
            'traffic_usage_over' => 'Traffic Usage Over N%',
            'will_expire_date' => 'Will Expire Date',
        ],
        'email_send' => 'Send Email',
        'error_message' => 'Error Messages',
        'processed' => 'Request Processed',
        'push_send' => 'Send Notification',
        'send_status' => 'Send Status',
        'send_time' => 'Sent On',
        'targeted_users_not_found' => 'Targeted Users Not Found',
        'unknown_sending_type' => 'Unknown Sending Type',
    ],
    'massive_export' => 'Batch Export',
    'menu' => [
        'analysis' => [
            'accounting' => 'Accounting',
            'attribute' => 'Analytics',
            'node_flow' => 'Node Traffic Analysis',
            'site_flow' => 'Site Traffic Analysis',
            'user_flow' => 'User Traffic Analysis',
        ],
        'customer_service' => [
            'article' => 'Knowledge Base',
            'attribute' => 'Helpdesk',
            'marketing' => 'Message Broadcasting',
            'ticket' => 'Support Tickets',
        ],
        'dashboard' => 'Dashboard',
        'log' => [
            'attribute' => 'Logs',
            'notify' => 'Notifications',
            'online_logs' => 'Online Logs',
            'online_monitor' => 'Online Monitoring',
            'payment_callback' => 'Payment Callback',
            'service_ban' => 'Ban Records',
            'system' => 'System Logs',
            'traffic' => 'Data Usage',
            'traffic_flow' => 'Data Flow',
        ],
        'node' => [
            'attribute' => 'Nodes',
            'auth' => 'API Authorization',
            'cert' => 'Certificates',
            'list' => 'Node Management',
        ],
        'promotion' => [
            'attribute' => 'Promote',
            'invite' => 'Referrals',
            'rebate_flow' => 'Rebate History',
            'withdraw' => 'Withdraws',
        ],
        'rbac' => [
            'attribute' => 'RBAC',
            'permission' => 'Permissions',
            'role' => 'Roles',
        ],
        'rule' => [
            'attribute' => 'Audit Rules',
            'group' => 'Rule Groups',
            'list' => 'Rules',
            'trigger' => 'Trigger Records',
        ],
        'setting' => [
            'attribute' => 'Settings',
            'email_suffix' => 'Email Filters',
            'system' => 'System',
            'universal' => 'General',
        ],
        'shop' => [
            'attribute' => 'Shop',
            'coupon' => 'Coupons',
            'goods' => 'Products',
            'order' => 'Orders',
        ],
        'tools' => [
            'analysis' => 'Log Analysis',
            'attribute' => 'Toolkit',
            'convert' => 'Convert',
            'decompile' => 'Decompile',
            'import' => 'Import',
        ],
        'user' => [
            'attribute' => 'Users',
            'credit_log' => 'Credit History',
            'group' => 'User Groups',
            'list' => 'User Management',
            'oauth' => 'OAuth',
            'subscribe' => 'Subscriptions',
        ],
    ],
    'minute' => 'minutes',
    'monitor' => [
        'daily_chart' => 'Daily Traffic Usage',
        'hint' => '<strong>Hint:</strong> Check scheduled tasks if no data',
        'monthly_chart' => 'Monthly Traffic Usage',
        'node' => 'Node Traffic',
        'user' => 'User Traffic',
    ],
    'no' => 'No',
    'node' => [
        'auth' => [
            'counts' => 'Total <code>:num</code> Licenses',
            'deploy' => [
                'attribute' => 'Backend Deployment',
                'command' => 'Instructions',
                'real_time_logs' => 'Real-time Logs',
                'recent_logs' => 'Recent Logs',
                'restart' => 'Restart',
                'same' => 'Same Above',
                'start' => 'Start',
                'status' => 'Status',
                'stop' => 'Stop',
                'title' => 'Deploy :type_label Backend',
                'trojan_hint' => 'Please fill in </a>the node name<a href=":url" target="_blank">and parse to the corresponding IP',
                'uninstall' => 'Uninstall',
                'update' => 'Update',
            ],
            'empty' => 'No nodes need authorization generation',
            'generating_all' => 'Confirm to generate authorization keys for all nodes?',
            'reset_auth' => 'Reset Authorization Key',
            'title' => 'API Authorizations <small>WEBAPI</small>',
        ],
        'cert' => [
            'counts' => 'Total <code>:num</code> Domain Certificates',
            'key_placeholder' => 'The KEY value of the certificate can be left empty. VNET-V2Ray backend supports auto-issue',
            'pem_placeholder' => 'VNET-V2Ray backend supports auto-issuer',
            'title' => 'Domain Certs <small>(For V2Ray node spoofing)</small>',
        ],
        'connection_test' => 'Connectivity Test',
        'counts' => 'Total <code> :num </code> Nodes',
        'info' => [
            'additional_ports_hint' => 'If enabled, please configure server <span class="red-700"><a href="javascript:showTnc();">additional_ports</a></span>',
            'basic' => 'Basic Information',
            'data_rate_hint' => 'E. g. 0.1 means 100M will be count as 10M; 5 means 100M will be count as 500M',
            'ddns_hint' => 'Dynamic IP nodes require <a href="https://github.com/NewFuture/DDNS" target="_blank">DDNS configuration</a>. For this type of node, Connectivity Test will be conducted through domain names.',
            'detection' => [
                'all' => 'Both',
                'hint' => 'Random check every 30-60 mins',
                'icmp' => 'Only ICMP',
                'tcp' => 'Only TCP',
            ],
            'display' => [
                'all' => 'Fully Visible',
                'hint' => 'Whether visible in subscription/node list',
                'invisible' => 'Invisible',
                'node' => 'Visible only in Node Page',
                'sub' => 'Visible only in Subscriptions',
            ],
            'domain_hint' => 'After enabling the DDNS in system settings, the domain name and the IPs will automatically update! You no longer need to edit this information at the domain registrar website.',
            'domain_placeholder' => 'Server domain, will use first if filled',
            'extend' => 'Extended Info',
            'hint' => '<strong>Note:</strong> The auto-generated <code>ID</code> is the <code>node_id</code> for ShadowsocksR backend and <code>nodeId</code> for V2Ray backend',
            'ipv4_hint' => 'Multiple IPs should be separated by commas in English, for example: 1.1.1.1,8.8.8.8',
            'ipv4_placeholder' => 'Server IPv4 Address',
            'ipv6_hint' => 'Multiple IPs should be separated by commas in English, for example: 1.1.1.1,8.8.8.8',
            'ipv6_placeholder' => 'Server IPv6 Address',
            'level_hint' => 'Level: 0 - No level restriction, all visible.',
            'obfs_param_hint' => 'Fill in parameters for traffic masquerading if obfs is not [plain]; &#13;&#10;Suggest port 80 if obfs is [http_simple]; &#13;&#10;Suggest port 443 if obfs is [tls];',
            'push_port_hint' => 'Required. Make sure this port is opened in the server firewall, otherwise message push will be abnormal.',
            'single_hint' => 'Recommended port 80/443. Backend needs <br> strict mode config: only connect via specified ports. (<a href="javascript:showPortsOnlyConfig();">How to configure</a>)',
            'v2_cover' => [
                'dtls' => 'DTLS 1.2',
                'http' => 'HTTP',
                'none' => 'None',
                'srtp' => 'SRTP',
                'utp' => 'uTP',
                'wechat' => 'WeChat Video',
                'wireguard' => 'WireGuard',
            ],
            'v2_host_hint' => 'When using HTTP camouflage, multiple domains should be separated by commas, while WebSocket only allows a single domain.',
            'v2_method_hint' => 'WebSocket transmission protocol should not use \'none\' encryption method.',
            'v2_net_hint' => 'Please enable TLS for WebSocket',
            'v2_tls_provider_hint' => 'Different backends have different configs:',
        ],
        'proxy_info' => '*Compatible with the Shadowsocks',
        'proxy_info_hint' => 'For compatibility, please add <span class="red-700">_compatible</span> to protocol and obfuscation in server config',
        'refresh_geo' => 'Refresh Geography',
        'refresh_geo_all' => 'Refresh Geo Data',
        'reload' => 'Reload Backend',
        'reload_all' => 'Reload All Backends',
        'reload_confirm' => 'Do you want to reload the server backend?',
        'traffic_monitor' => 'Traffic Stats',
    ],
    'oauth' => [
        'counts' => 'Total <code>:num</code> Authorization Records',
        'title' => 'OAuth',
    ],
    'optional' => 'Optional',
    'permission' => [
        'counts' => 'Total <code>:num</code> Permissions',
        'description_hint' => 'Description, e.g. [X system] Edit A',
        'name_hint' => 'Route name, e.g. admin.user.update',
        'title' => 'Permissions',
    ],
    'query' => 'Query',
    'report' => [
        'annually_accounting' => 'Annual Transactions',
        'annually_site_flow' => 'Annual Traffic Consumption',
        'avg_traffic_30d' => 'Avg Daily Traffic Over 30 Days',
        'current_month' => 'This Month',
        'current_year' => 'This Year',
        'daily_accounting' => 'Daily Transactions',
        'daily_distribution' => 'Daily distribution',
        'daily_site_flow' => 'Daily Traffic Consumption',
        'daily_traffic' => 'Daily Traffic',
        'hourly_traffic' => 'Hourly Traffic',
        'last_month' => 'Last Month',
        'last_year' => 'Last Year',
        'monthly_accounting' => 'Monthly Transactions',
        'monthly_site_flow' => 'Monthly Traffic Consumption',
        'select_hourly_date' => 'Select Hourly Date',
        'sum_traffic_30d' => '30-Day Traffic Ratio',
        'today' => 'Today',
    ],
    'require' => 'Required',
    'role' => [
        'counts' => 'Total <code>:num</code> Roles',
        'description_hint' => 'Display name, e.g. Administrator',
        'modify_admin_error' => 'Do not modify the super admin!',
        'name_hint' => 'Unique identifier, e.g. admin',
        'permissions_all' => 'All Permissions',
        'title' => 'Roles',
    ],
    'rule' => [
        'counts' => 'Total <code>:num</code> Rules',
        'group' => [
            'counts' => 'Total <code>:num</code> Groups',
            'title' => 'Rule Groups',
            'type' => [
                'off' => 'Block',
                'on' => 'Allow',
            ],
        ],
        'title' => 'Rules',
        'type' => [
            'domain' => 'Domain',
            'ip' => 'IP',
            'protocol' => 'Protocol',
            'reg' => 'Regex',
        ],
    ],
    'select_all' => 'Select All',
    'selected_hint' => 'The allocated rules can be searched here',
    'set_to' => 'Set as :attribute',
    'setting' => [
        'common' => [
            'connect_nodes' => '# of Nodes',
            'set_default' => 'Set as Default',
            'title' => 'General Config',
        ],
        'email' => [
            'black' => 'Blacklist',
            'rule' => 'Restriction Type',
            'tail' => 'Email Suffix',
            'tail_placeholder' => 'Enter email suffix',
            'title' => 'Email Filters <small>(for registration)</small>',
            'white' => 'Whitelist',
        ],
        'no_permission' => 'No permission to change settings!',
        'system' => [
            'account' => 'Account',
            'auto_job' => 'Automation',
            'check_in' => 'Check-in',
            'extend' => 'Advanced',
            'menu' => 'Menu',
            'node' => 'Node',
            'notify' => 'Notification',
            'other' => 'Logo|CS|Analytics',
            'payment' => 'Payment',
            'promotion' => 'Affiliate',
            'title' => 'System Settings',
            'web' => 'General',
            'task_settings' => 'Task Settings',
        ],
    ],
    'sort_asc' => 'Larger sort value has higher priority',
    'start_time' => 'Start',
    'system' => [
        'contact_telegram' => 'Contact Telegram Link', 
        'task_limit_new_user' => 'Task Limit (New User)', // TV: Giới hạn NV (Người dùng mới)
        'task_limit_intermediate_user' => 'Task Limit (Intermediate User)', // TV: Giới hạn NV (Người dùng trung gian)
        'task_limit_veteran_user' => 'Task Limit (Veteran User)', // TV: Giới hạn NV (Người dùng kỳ cựu)
        'tasks_unit' => 'tasks/day', // TV: nhiệm vụ/ngày
        'task_countdown_hours' => 'Task Countdown Hours', // TV: Thời gian hoàn thành NV (giờ)
        'product_price' => 'Default Product Price', // TV: Giá sản phẩm mặc định
        'member_reward' => 'Default Member Reward', // TV: Thưởng thành viên mặc định
        'AppStore_id' => '[Apple] Account',
        'AppStore_password' => '[Apple] Password',
        'account_expire_notification' => 'Account Expiration Notice',
        'active_account' => [
            'after' => 'Activate after registration',
            'before' => 'Pre-registration activation',
        ],
        'active_times' => 'Max Account Activations',
        'admin_invite_days' => '[Admin] Invitation Expiration',
        'aff_salt' => '[Referral URL] Encrypt User ID',
        'alipay_qrcode' => 'Alipay QR Code',
        'auto_release_port' => 'Port Recycle',
        'bark_key' => '[Bark] Device Key',
        'captcha' => [
            'geetest' => 'Geetest',
            'hcaptcha' => 'hCaptcha',
            'recaptcha' => 'Google ReCaptcha',
            'standard' => 'Standard',
            'turnstile' => 'Turnstile',
        ],
        'captcha_key' => 'Captcha Key',
        'captcha_secret' => 'Captcha Secret/ID',
        'codepay_id' => '[CodePay] ID',
        'codepay_key' => '[CodePay] Key',
        'codepay_url' => '[CodePay] URL',
        'data_anomaly_notification' => 'Data Anomaly Notice',
        'data_exhaust_notification' => 'Data Exhaustion Notice',
        'ddns_key' => '[DNS] Key',
        'ddns_mode' => 'DNS Sync',
        'ddns_secret' => '[DNS] Secret',
        'default_days' => 'Default Account Time',
        'default_traffic' => 'Default Initial Data',
        'demo_restriction' => 'Modification of this configuration is prohibited in the demo environment!',
        'detection_check_times' => 'Node Block Alerts',
        'dingTalk_access_token' => '[DingTalk] Access Token',
        'dingTalk_secret' => '[DingTalk] Secret',
        'epay_key' => '[ePay] Key',
        'epay_mch_id' => '[ePay] Merchant ID',
        'epay_url' => '[ePay] URL',
        'expire_days' => 'Expiration Warning',
        'f2fpay_app_id' => '[Alipay] APP ID',
        'f2fpay_private_key' => '[Alipay] Private Key',
        'f2fpay_public_key' => '[Alipay] Public Key',
        'forbid' => [
            'china' => 'Forbid China Access',
            'mainland' => 'Forbid Chinese Mainland Access',
            'oversea' => 'Forbid Oversea Access',
        ],
        'forbid_mode' => 'Access Restriction',
        'hint' => [
            'AppStore_id' => 'Used in articles',
            'AppStore_password' => 'Used in articles',
            'account_expire_notification' => 'Notify expiration',
            'active_times' => 'Via email in 24 hours',
            'admin_invite_days' => 'Admin invitation expiration',
            'aff_salt' => 'Encryption salt for referral URL',
            'auto_release_port' => 'Auto release port after being banned/expired for <code>'.config('tasks.release_port').'</code> days',
            'bark_key' => 'Device key for iOS push',
            'captcha_key' => 'Browse <a href="https://proxypanel.gitbook.io/wiki/captcha" target="_blank">setup guide</a>',
            'data_anomaly_notification' => 'Notify admin when hourly data exceeds threshold',
            'data_exhaust_notification' => 'Notify when data is running out',
            'ddns_key' => 'Browse<a href="https://proxypanel.gitbook.io/wiki/ddns" target="_blank">Setup Guide</a>to set up',
            'ddns_mode' => 'Sync domain & IP changes to DNS provider',
            'default_days' => 'Default expiration for new accounts, 0 means expire today',
            'default_traffic' => 'Default data for new accounts',
            'detection_check_times' => 'Auto offline node after N alerts, 0 for unlimited, max 12',
            'dingTalk_access_token' => 'Custom bot <a href=https://open.dingtalk.com/document/group/custom-robot-access#title-jfe-yo9-jl2 target=_blank>access token</a>',
            'dingTalk_secret' => 'Custom bot secret when enabled sign',
            'expire_days' => 'Start account expiration notice',
            'f2fpay_app_id' => 'Alipay APPID',
            'f2fpay_private_key' => 'Alipay private key from secret key tool',
            'f2fpay_public_key' => 'Not the APP public key!',
            'forbid_mode' => 'Block access from specified regions',
            'iYuu_token' => 'Fill <a href=https://iyuu.cn target=_blank>IYUU token</a> before enabling',
            'invite_num' => 'Default number of invitations per user',
            'is_activate_account' => 'Require activation via email',
            'is_ban_status' => '(Caution) Ban account will reset all user data',
            'is_captcha' => 'Require captcha to login/register if enabled',
            'is_checkin' => 'Random reward when check-in',
            'is_clear_log' => '(Recommended) Auto clean useless/outdated logs when enabled',
            'is_custom_subscribe' => 'Show expiration & data left on subscription list when enabled',
            'is_email_filtering' => 'Blacklist: Users can register with email suffixes not in the blacklist; Whitelist: Users must register with email suffixes in the whitelist',
            'is_forbid_robot' => 'Return 404 error if accessed by bots/proxies',
            'is_free_code' => 'Hide free invite codes if disabled',
            'is_rand_port' => 'Random port when add/register user',
            'is_register' => 'Disable registration if unchecked',
            'is_subscribe_ban' => 'Auto ban if subscription requests exceed threshold',
            'is_traffic_ban' => 'Auto disable service if data exceeds threshold in 1 hour',
            'maintenance_content' => 'Custom maintenance announcement',
            'maintenance_mode' => 'Redirect normal users to maintenance page if enabled| Admin can login via <a href=\'javascript:(0)\'>:url</a>',
            'maintenance_time' => 'For maintenance page countdown',
            'min_port' => 'Port range 1000 - 65535',
            'node_blocked_notification' => 'Detect node block hourly, notify admins',
            'node_daily_notification' => 'Daily node usage report',
            'node_offline_notification' => 'Detect offline every 10 mins, notify if any node is offline',
            'node_renewal_notification' => 'Remind the administrator to renew the node 7 days, 3 days, and 1 day before expiration',
            'oauth_path' => 'Please enable platforms in .ENV first',
            'offline_check_times' => 'Stop notification after N alerts in 24 hours',
            'password_reset_notification' => 'Allow password reset via email if enabled',
            'paybeaver_app_id' => '<a href="https://merchant.paybeaver.com/" target="_blank">Merchant Center</a> -> Developer -> App ID',
            'paybeaver_app_secret' => '<a href="https://merchant.paybeaver.com/" target="_blank">Merchant Center</a> -> Developer -> App Secret',
            'payjs_mch_id' => 'Get from <a href="https://payjs.cn/dashboard/member" target="_blank">member page</a>',
            'payment_confirm_notification' => 'Notify admin to process manual payment orders',
            'payment_received_notification' => 'Notify user when payment received',
            'pushDeer_key' => 'Fill <a href=https://www.pushdeer.com/official.html target=_blank>PushDeer Push Key</a> before enabling',
            'pushplus_token' => 'Fill <a href=https://www.pushplus.plus/push1.html target=_blank>PushPlus Token</a> before enabling',
            'rand_subscribe' => 'Random order if enabled, otherwise by node list order',
            'redirect_url' => 'Redirect blocked requests to this URL when rules triggered',
            'referral_money' => 'The minimum amount that can be withdrawn',
            'referral_percent' => 'The percentage of order amount the referrer gets',
            'referral_status' => 'Close referral system without affecting existing data',
            'referral_traffic' => 'Give free data traffic when registered via referral',
            'referral_type' => 'New rebates calculated by new mode after switching',
            'register_ip_limit' => 'Number of registrations allowed per IP in 24 hours, 0 for unlimited',
            'reset_password_times' => 'Number of password resets allowed via email in 24 hours',
            'reset_traffic' => 'Automatically reset data based on user plan cycle',
            'server_chan_key' => 'Fill in <a href="https://sct.ftqq.com/r/2626" target="_blank">ServerChan SCKEY</a> before enabling',
            'standard_currency' => 'Primary currency used in panel',
            'subject_name' => 'Custom product name in payment gateways',
            'subscribe_ban_times' => 'Maximum subscription requests allowed per user in 24 hours',
            'subscribe_domain' => 'Start with http:// or https:// to avoid DNS poisoning failure',
            'subscribe_max' => 'Max number of nodes returned in subscription list, 0 for all',
            'telegram_token' => 'Get robot <a href=https://t.me/BotFather target=_blank>TOKEN</a> from @BotFather',
            'tg_chat_token' => 'Fill <a href=https://t.me/realtgchat_bot target=_blank>TG Chat token</a> before enabling',
            'ticket_closed_notification' => 'Notify user when ticket is closed',
            'ticket_created_notification' => 'Notify manager/user depending on creator',
            'ticket_replied_notification' => 'Notify the other party when ticket replied',
            'traffic_ban_time' => 'Duration of auto ban for exceptions',
            'traffic_ban_value' => 'Trigger auto account ban if exceeds this value in 1 hour',
            'traffic_limit_time' => 'Time interval between check-ins',
            'traffic_warning_percent' => 'Send traffic exhaustion notice when daily usage reaches this percentage',
            'user_invite_days' => 'Expiration of user-generated invitation codes',
            'username_type' => 'Default username type for users',
            'v2ray_tls_provider' => 'Node settings override this TLS config',
            'web_api_url' => 'E.g. '.config('app.url'),
            'webmaster_email' => 'Contact email shown in some error messages',
            'website_analytics' => 'Analytics JavaScript code',
            'website_callback_url' => 'Prevent payment callback failure due to DNS poisoning',
            'website_customer_service' => 'Customer service JavaScript code',
            'website_name' => 'Website name in emails',
            'website_security_code' => 'Require security code to access site if set',
            'website_url' => 'Main domain used for links',
            'wechat_aid' => '<a href="https://work.weixin.qq.com/wework_admin/frame#apps" target="_blank">App Management</a> -> AgentId',
            'wechat_cid' => 'Get from <a href="https://work.weixin.qq.com/wework_admin/frame#profile" target="_blank">Enterprise Info</a>',
            'wechat_encodingAESKey' => 'App Management -> App Settings -> EncodingAESKey',
            'wechat_secret' => 'App secret (need enterprise WeChat to view)',
            'wechat_token' => 'App Settings -> TOKEN, callback URL: :url',
            'contact_telegram' => 'Enter the full Telegram contact link (e.g., https://t.me/yourgroup).', // TV: Nhập link Telegram liên hệ đầy đủ.
            'task_limit_new_user' => 'Maximum daily tasks for new users (e.g., registered less than 7 days).', // TV: Số nhiệm vụ tối đa mỗi ngày cho người dùng mới (ví dụ: đăng ký dưới 7 ngày).
            'task_limit_intermediate_user' => 'Maximum daily tasks for intermediate users (e.g., registered 7-30 days).', // TV: Số nhiệm vụ tối đa mỗi ngày cho người dùng trung gian (ví dụ: đăng ký 7-30 ngày).
            'task_limit_veteran_user' => 'Maximum daily tasks for veteran users (e.g., registered more than 30 days).', // TV: Số nhiệm vụ tối đa mỗi ngày cho người dùng kỳ cựu (ví dụ: đăng ký trên 30 ngày).
            'task_countdown_hours' => 'Number of hours a user has to complete an assigned task.', // TV: Số giờ người dùng có để hoàn thành một nhiệm vụ được giao.
            'product_price' => 'Default price for a new product/task posting by business users.', // TV: Giá mặc định cho một đăng sản phẩm/nhiệm vụ mới bởi người dùng doanh nghiệp.
            'member_reward' => 'Default reward amount for a member completing one task.', // TV: Phần thưởng mặc định cho thành viên hoàn thành một nhiệm vụ.
        ],
        'iYuu_token' => '[IYUU] Token',
        'invite_num' => 'Default Invitations',
        'is_AliPay' => 'Alipay',
        'is_QQPay' => 'QQ Pay',
        'is_WeChatPay' => 'WeChat Pay',
        'is_activate_account' => 'Account Activation',
        'is_ban_status' => 'Expiration Ban',
        'is_captcha' => 'Captcha',
        'is_checkin' => 'Check-in Reward',
        'is_clear_log' => 'Clean Logs',
        'is_custom_subscribe' => 'Advanced Subscription',
        'is_email_filtering' => 'Email Filtering for User Registration',
        'is_forbid_robot' => 'Forbid Bots',
        'is_free_code' => 'Free Invitation Codes',
        'is_invite_register' => 'Invitation to Register',
        'is_otherPay' => 'Custom Payment',
        'is_rand_port' => 'Random Port',
        'is_register' => 'Registration',
        'is_subscribe_ban' => 'Subscription Ban',
        'is_traffic_ban' => 'Data Abuse Ban',
        'is_MoMo' => 'Momo',
        'momo_partner_code' => 'Partner Code',
        'momo_public_key' => 'Public Key',
        'momo_secret_key' => 'Secret Key',
        'momo_access_key' => 'Access Key',
        'momo_api_endpoint' => 'API Endpoint',
        'momo_account_number' => 'Account Number',
        'momo_account_name' => 'Account Name',
        'momo_min_amount' => 'Minimum Amount',
        'momo_max_amount' => 'Maximum Amount',
        'momo_qr_code_url' => 'QR Code URL',
        'is_HoodPay' => 'HoodPay',
        'hoodpay_api_key' => '[HoodPay] API Key',
        'hoodpay_api_secret' => '[HoodPay] API Secret',
        'hoodpay_merchant_id' => '[HoodPay] Merchant ID',
        'hoodpay_webhook_url' => '[HoodPay] Webhook URL',
        'hoodpay_callback_url' => '[HoodPay] Callback URL',
        'hoodpay_payment_url' => '[HoodPay] Payment URL',
        'hoodpay_min_amount' => '[HoodPay] Minimum Amount',
        'hoodpay_max_amount' => '[HoodPay] Maximum Amount',
        'hoodpay_business_id' => '[HoodPay] Business ID',
        'hoodpay_api_url' => '[HoodPay] API URL',
        'hoodpay_logo' => '[HoodPay] Logo URL',
        'maintenance_content' => 'Maintenance Notice',
        'maintenance_mode' => 'Maintenance Mode',
        'maintenance_time' => 'Maintenance End',
        'min_port' => 'Port Range',
        'min_rand_traffic' => 'Data Range',
        'node_blocked_notification' => 'Node Blocked Notice',
        'node_daily_notification' => 'Daily Node Report',
        'node_offline_notification' => 'Node Offline Notice',
        'node_renewal_notification' => 'Node Renewal Notice',
        'notification' => [
            'channel' => [
                'bark' => 'Bark',
                'dingtalk' => 'DingTalk',
                'email' => 'Email',
                'iyuu' => 'IYUU',
                'pushdeer' => 'PushDeer',
                'pushplus' => 'PushPlus',
                'serverchan' => 'ServerChan',
                'site' => 'Site Popup',
                'telegram' => 'Telegram',
                'tg_chat' => 'TG Chat',
                'wechat' => 'Enterprise WeChat',
            ],
            'send_test' => 'Send Test Message',
            'test' => [
                'content' => 'Test content',
                'success' => 'Sent successfully. Please check your phone for the push notification.',
                'title' => 'This is a test title',
                'unknown_channel' => 'Unknown channel',
            ],
        ],
        'oauth_path' => 'OAuth Platforms',
        'offline_check_times' => 'Offline Notifications',
        'params_required' => 'Please complete the necessary parameters for this :attribute first!',
        'password_reset_notification' => 'Reset Password Notice',
        'paybeaver_app_id' => '[PayBeaver] App ID',
        'paybeaver_app_secret' => '[PayBeaver] App Secret',
        'payjs_key' => '[PayJs] Key',
        'payjs_mch_id' => '[PayJs] Merchant ID',
        'payment' => [
            'attribute' => 'Payment Gateway',
            'channel' => [
                'alipay' => 'Alipay F2F',
                'codepay' => 'CodePay',
                'epay' => 'ePay',
                'manual' => 'Manual Pay',
                'paybeaver' => 'PayBeaver',
                'payjs' => 'PayJs',
                'paypal' => 'PayPal',
                'stripe' => 'Stripe',
                'theadpay' => 'THeadPay',
                'momo' => 'Momo',
                'wechat' => 'WeChat Pay',
                'hoodpay' => 'HoodPay',        
            ],
            'hint' => [
                'alipay' => 'This feature requires going to <a href="https://open.alipay.com/platform/appManage.htm?#/create/" target="_blank">Ant Financial Services Open Platform</a> to apply for permission and application',
                'codepay' => 'Please go to <a href="https://codepay.fateqq.com/i/377289" target="_blank">CodePay</a>. Apply for an account, download and set up its software',
                'manual' => 'After the gateway is set and selected, it will be displayed on the user-end',
                'paybeaver' => 'Please go to <a href="https://merchant.paybeaver.com/?aff_code=iK4GNuX8" target="_blank"> PayBeaver</a> to apply an account',
                'payjs' => 'Please go to <a href="https://payjs.cn/ref/zgxjnb" target="_blank">PayJs</a> to apply an account',
                'paypal' => 'Login to the <a href="https://www.paypal.com/businessprofile/mytools/apiaccess/firstparty" target="_blank">API credentials application page</a> with your merchant account, agree and get setup information',
                'theadpay' => 'Please go to <a href="https://theadpay.com/" target="_blank">THeadPay</a> to request an account',
                'momo' => 'Please go to <a href="https://momo.vn/" target="_blank">Momo</a> to apply for an account',
                'stripe' => 'Please go to <a href="https://dashboard.stripe.com/" target="_blank">Stripe</a> to apply for an account',
                'wechat' => 'Please go to <a href="https://mp.weixin.qq.com/" target="_blank">WeChat Official Account</a> to apply for an account',
                'hoodpay' => 'Please go to <a href="https://hoodpay.com/" target="_blank">HoodPay</a> to apply for an account',
            ],
            'notes' => [
            'credit_update_failed' => 'Credit update failed. Manual check required.',
            'user_not_found_deposit' => 'User not found for deposit. Manual check required.',
            'order_not_pending' => 'Order :sn was not in pending state. Manual check required.',
            'associated_order_not_found' => 'Associated order not found. Manual check required.',
            ],
            'epay_info_title' => 'EPay Information (For reference only)',
            'epay_merchant_status' => 'Merchant Status: ',
            'epay_account_balance' => ' | Account Balance: ',
            'epay_settlement_account' => ' | Settlement Account: ',
            'epay_channel_fee_alipay' => '<br/><br/>Channel Fee: 【Alipay - ',
            'epay_channel_fee_wechat' => '% | WeChat - ',
            'epay_channel_fee_qq' => '% | QQ Wallet - ',
            'epay_info_disclaimer' => '%】<br/><br/> Please refer to the payment platform for accurate details. This information is retrieved via API and is for reference only.',        
        ],
        'payment_confirm_notification' => 'Manual Payment Confirmation',
        'payment_received_notification' => 'Payment Success Notice',
        'paypal_app_id' => 'App ID',
        'paypal_client_id' => 'Client ID',
        'paypal_client_secret' => 'Client Secret',
        'placeholder' => [
            'bark_key' => 'Fill Bark device key then click Update',
            'codepay_url' => 'https://codepay.fatq.com/create_order/?',
            'default_url' => 'Default as :url',
            'dingTalk_access_token' => 'Custom bot access token',
            'dingTalk_secret' => 'Custom bot secret after signing',
            'iYuu_token' => 'Fill IYUU token then click Update',
            'pushDeer_key' => 'Fill PushDeer Push Key then click Update',
            'pushplus_token' => 'Please apply at ServerChan',
            'server_chan_key' => 'Fill ServerChan SCKEY then click Update',
            'telegram_token' => 'Fill Telegram token then click Update',
            'tg_chat_token' => 'Please apply at Telegram',
            'wechat_aid' => 'WeChat Enterprise App AID',
            'wechat_cid' => 'Fill WeChat CID then click Update',
            'wechat_secret' => 'WeChat Enterprise App secret',
        ],
        'pushDeer_key' => '[PushDeer] Key',
        'pushplus_token' => '[PushPlus] Token',
        'rand_subscribe' => 'Random Subscription',
        'redirect_url' => 'Redirect URL',
        'referral' => [
            'loop' => 'Always Rebate',
            'once' => 'First Purchase Rebate',
        ],
        'referral_money' => 'Min Withdrawal Limit',
        'referral_percent' => 'Rebate Percentage',
        'referral_status' => 'Affiliate',
        'referral_traffic' => 'Registration Bonus',
        'referral_type' => 'Rebate Type',
        'register_ip_limit' => 'Registration IP Limit',
        'reset_password_times' => 'Reset Limit',
        'reset_traffic' => 'Auto Reset Data',
        'server_chan_key' => '[ServerChan] SCKEY',
        'standard_currency' => 'Primary Currency',
        'stripe_public_key' => 'Public Key',
        'stripe_secret_key' => 'Secret Key',
        'stripe_signing_secret' => 'Webhook Secret',
        'subject_name' => 'Custom Product Name',
        'subscribe_ban_times' => 'Subscription Limit',
        'subscribe_domain' => 'Subscription URL',
        'subscribe_max' => 'Max Subscription Nodes',
        'telegram_token' => 'Telegram Token',
        'tg_chat_token' => 'TG Chat Token',
        'theadpay_key' => '[THeadPay] Key',
        'theadpay_mchid' => '[THeadPay] Merchant ID',
        'theadpay_url' => '[THeadPay] URL',
        'ticket_closed_notification' => 'Ticket Closed Notice',
        'ticket_created_notification' => 'Ticket Creation Notice',
        'ticket_replied_notification' => 'Ticket Reply Notice',
        'traffic_ban_time' => 'Ban Duration',
        'traffic_ban_value' => 'Data Abuse Threshold',
        'traffic_limit_time' => 'Check-in Interval',
        'traffic_warning_percent' => 'Data Usage Warning',
        'trojan_license' => 'Trojan License',
        'user_invite_days' => '[User] Invitation Expiry',
        'username' => [
            'any' => 'Any Username',
            'email' => 'Email',
            'mobile' => 'Phone number',
        ],
        'username_type' => 'Account Username Type',
        'v2ray_license' => 'V2Ray License',
        'v2ray_tls_provider' => 'V2Ray TLS Config',
        'web_api_url' => 'API Domain',
        'webmaster_email' => 'Admin Email',
        'website_analytics' => 'Analytics Code',
        'website_callback_url' => 'Payment Callback Domain',
        'website_customer_service' => 'CS Code',
        'website_home_logo' => 'Homepage Logo',
        'website_logo' => 'Inner Page Logo',
        'website_name' => 'Site Name',
        'website_security_code' => 'Security Code',
        'website_url' => 'Site Domain',
        'wechat_aid' => 'WeChat AID',
        'wechat_cid' => 'WeChat CID',
        'wechat_encodingAESKey' => 'WeChat Encoding Key',
        'wechat_qrcode' => 'WeChat QR Code',
        'wechat_secret' => 'WeChat Secret',
        'wechat_token' => 'WeChat Token',
        'admin_fee_percent' => 'Admin Fee Percentage',
        'min_withdraw_amount' => 'Min Withdrawal Limit',
    ],
    'system_generate' => 'System Generated',
    'ticket' => [
        'close_confirm' => 'Do you want to close this ticket?',
        'counts' => 'Total <code>:num</code> Tickets',
        'error' => 'Unknown error! Please check logs',
        'inviter_info' => 'Inviter Info',
        'self_send' => 'You cannot create a ticket for yourself!',
        'send_to' => 'Please fill in target user details',
        'title' => 'Tickets',
        'user_info' => 'User Info',
    ],
    'times' => 'Times',
    'tools' => [
        'analysis' => [
            'file_missing' => ':file_name does not exist. Please create the file first.',
            'not_enough' => 'Less than 15,000 records, unable to analyze',
            'req_url' => 'Recent Request URL Records',
            'title' => 'SSR Log Analysis <small>For single node</small>',
        ],
        'convert' => [
            'content_placeholder' => 'Please fill in the configuration information that needs to be converted.',
            'file_missing' => 'File not found. Please check directory permissions.',
            'missing_error' => 'Conversion failed: The configuration information is missing the [port_password] field, or this field is empty.',
            'params_unknown' => 'Parameter exception',
            'title' => 'Format Conversion <small>SS to SSR</small>',
        ],
        'decompile' => [
            'attribute' => 'Reverse Parsing Configuration Link',
            'content_placeholder' => 'Please fill in the ShadowsocksR links that need to be reverse-parsed, separated by line breaks.',
            'title' => 'Decompile <small>Config Info</small>',
        ],
        'import' => [
            'file_error' => 'An unknown error occurred. Please re-upload.',
            'file_required' => 'Please select a file to upload',
            'file_type_error' => 'Only :type files are allowed for upload.',
            'format_error' => 'Content format parsing error. Please upload a :type file that meets the specified format.',
        ],
    ],
    'unselected_hint' => 'Rules to be allocated can be searched here',
    'user' => [
        'admin_deletion' => 'System administrators cannot be deleted',
        'bulk_account_quantity' => 'Number of accounts generated in bulk',
        'connection_test' => 'Connection Test',
        'counts' => 'Total <code>:num</code> Accounts',
        'group' => [
            'counts' => 'Total <code>:num</code> Groups',
            'name' => 'Group Name',
            'title' => 'User Group Control<small> (A node can be in multiple groups, but the user can only belong to one group; for nodes visible/available to users, group has more priority than level)</small>',
        ],
        'info' => [
            'account' => 'Account Info',
            'expired_date_hint' => 'Leave blank for a default validity of one year',
            'proxy' => 'Proxy Info',
            'recharge_placeholder' => 'If negative, deducts balance',
            'reset_date_hint' => 'Next data reset date',
            'switch' => 'Switch Identity',
            'uuid_hint' => 'UUID for V2Ray',
        ],
        'online_monitor' => 'Online Monitoring',
        'proxies_config' => 'Connection Info for :username',
        'proxy_info' => 'Config Info',
        'reset_confirm' => [0 => 'Do you want to reset [', 1 => ']\'s traffic?'],
        'reset_traffic' => 'Reset Data',
        'traffic_monitor' => 'Traffic Stats',
        'update_help' => 'Update successful, go back?',
        'user_view' => 'Switch to User View',
        'reset_password' => 'Reset Password',
        'reset_password_for' => 'Reset Password for :username',
        'password_reset_success' => 'Password for :username has been reset successfully.',
        'deleted_success' => 'User :username has been deleted successfully.',
        'switch_to_user' => 'Switch to User View',
        'switch_confirm' => 'Are you sure you want to switch to user :username\'s view?',
        'switched_to_user' => 'Successfully switched to user :username\'s view.',
        'switched_back_to_admin' => 'Successfully switched back to your admin account.',
        'impersonating_user' => 'You are currently viewing as <strong>:username</strong> (Impersonated by :admin_name).',
        'switch_back_to_admin_short' => 'Switch Back',
    ],
    'user_dashboard' => 'User Dashboard',
    'yes' => 'Yes',
    'zero_unlimited_hint' => '0 or empty for unlimited',
    'products' => [
        'manage_title' => 'Products',
        'product_list' => 'Product List',
        'id' => 'ID',
        'gmap_link' => 'Link Google Map',
        'creator' => 'Creator',
        'amount' => 'Amount',
        'price' => 'Price',
        'status' => 'Status',
        'created_at' => 'Created At',
        'actions' => 'Actions',
        'review' => 'Review',
        'edit_product_status' => 'Edit Product Status',
        'product_details' => 'Product Details',
        'view_details' => 'Details',
        'description' => 'Description',
        'link_drive' => 'Link Drive',
        'current_status' => 'Current Status',
        'new_status' => 'New Status',
        'update_status' => 'Update Status',
        'select_status' => 'Select Status',
        'product_management' => 'Product Management',
        'approve' => 'Approve',
        'reject' => 'Reject',
        'pending_approval' => 'Awaiting Approval',
        'approved_by_admin' => 'Approved',
        'rejected_by_admin' => 'Rejected',
        'status_updated_successfully' => 'Status updated successfully.',
        'refund_processed' => 'Refund processed successfully.',
        'status_update_failed' => 'Failed to update status.',
        'product_not_found' => 'Product not found.',
        'user_not_found_for_refund' => 'User not found for refund.',
        'fail_to_refund' => 'Failed to process refund.',
        'cannot_change_status_for_current_state' => 'Cannot change status for current state.',
        'admin_notes' => 'Admin Notes',
        'enter_admin_notes_placeholder' => 'Admin notes here...',
        'create_new' => 'Create New Product',
    ],
    'user_tasks' => [
        'menu_title' => 'Tasks',
        'filter_status' => 'Filter by Status',
        'filter_user_id' => 'Filter by User ID',
        'filter_product_id' => 'Filter by Product ID',
        'id' => 'ID',
        'user' => 'User',
        'product' => 'Product',
        'reward' => 'Reward',
        'assigned_at' => 'Assigned At',
        'deadline_at' => 'Deadline At',
        'submitted_at' => 'Submitted At',
        'status' => 'Status',
        'admin_notes' => 'Admin Notes',
        'actions' => 'Actions',
        'admin_notes_for_task' => 'Admin Notes for Task #:id',
        'report_notes_for_task' => 'Report Notes for Task #:id',
        'update_status' => 'Update Status',
        'update_status_for_task' => 'Update Status for Task #:id',
        'new_status' => 'New Status',
        'error_updating_user_credit' => 'Error updating user credit.',
        'report_notes' => 'Report Notes',
    ],
    'user_management' => [
        'title' => 'User Management',
        'user_list' => 'User List',
        'menu_title' => 'User Management',
        'edit_user_title' => 'Edit User: :name',
        'edit_user' => 'Edit User',
        'max_daily_tasks' => 'Max Daily Tasks',
        'max_daily_tasks_placeholder' => 'Leave empty for default',
        'max_daily_tasks_desc' => 'If set, this overrides the default daily task limit for this user.',
        'account_status' => 'Account Status',
        'change_password_section' => 'Change Password',
        'change_password_desc' => 'Leave blank if you do not want to change the password.',
    ],
    'withdraw_requests' => [
        'menu_title' => 'Withdrawals',
        'manage_title' => 'Manage Withdrawal Requests',
        'list_title' => 'Withdrawal Request List',
        'details_title' => 'Withdrawal Request Details',
        'user' => 'User',
        'amount' => 'Amount',
        'payment_method' => 'Payment Method',
        'payment_details' => 'Payment Details',
        'status' => [
            'title' => 'Status',
            // Các status đã có trong user.php, có thể dùng chung hoặc định nghĩa lại nếu cần
        ],
        'requested_at' => 'Requested At',
        'processed_at' => 'Processed At',
        'admin_notes' => 'Admin Notes',
        'actions' => 'Actions',
        'update_status_short' => 'Update Status',
        'update_status_for' => 'Update Status for Request',
        'current_status' => 'Current Status',
        'new_status' => 'New Status',
        'approve' => 'Approve',
        'reject' => 'Reject',
        'mark_as_paid' => 'Mark as Paid',
        'transaction_id' => 'Transaction ID',
        'status_updated_successfully' => 'Withdrawal request status updated successfully.',
        'status_not_changed' => 'Status was not changed.',
        'refund_failed_credit_update' => 'Failed to refund credit to user.',
        'user_not_found' => 'User associated with this request not found.',
        'no_requests_found' => 'No withdrawal requests found.',
        'user_current_credit' => 'User Current Credit',
        'cannot_change_from_paid' => 'Cannot change status from "Paid". Create a new adjustment if needed.',
        'cannot_approve_rejected' => 'Cannot directly approve a previously rejected request. Please review carefully.',
        'cannot_change_from_approved' => 'Cannot change status from "Approved". Create a new adjustment if needed.',
    ],
    'validation' => [
        'value_less_than' => 'Value cannot be less than :value',
        'value_greater_than' => 'Value cannot be greater than :value',
        'value_equal_to' => 'Value must be equal to :value',
        'value_not_equal_to' => 'Value must not be equal to :value',
        'value_between' => 'Value must be between :min and :max',
        'value_not_between' => 'Value must not be between :min and :max',
        'value_required' => 'Value is required',
        'value_not_required' => 'Value is not required',
        'value_invalid' => 'Value is invalid',
        'value_must_be_integer' => 'Value must be an integer',
        'value_must_be_string' => 'Value must be a string',
        'value_must_be_boolean' => 'Value must be a boolean',
        'value_must_be_array' => 'Value must be an array',
        'value_must_be_object' => 'Value must be an object',
        'value_must_be_email' => 'Value must be a valid email address',
        'value_must_be_url' => 'Value must be a valid URL',
        'value_must_be_date' => 'Value must be a valid date',
        'value_must_be_datetime' => 'Value must be a valid date and time',
        'value_must_be_time' => 'Value must be a valid time',
        'value_must_be_ip' => 'Value must be a valid IP address',
    ],
    'category' => [
        'title' => 'Category',
        'name' => 'Name',
        'description' => 'Description',
        'status' => 'Status',
        'created_at' => 'Created At',
        'updated_at' => 'Updated At',
        'actions' => 'Actions',
        'create_category' => 'Create Category',
        'edit_category' => 'Edit Category',
        'delete_category_confirm' => 'Are you sure you want to delete this category?',
        'category_deleted_successfully' => 'Category deleted successfully.',
    ],
];