<?php

declare(strict_types=1);

return [
    'action' => [
        'add_item' => 'Hinzufügen :attribute',
        'edit_item' => 'Bearbeiten :attribute',
    ],
    'aff' => [
        'apply_counts' => 'Insgesamt <code>:num</code> Auszahlungsanfragen',
        'commission_counts' => 'Diese Anwendung beinhaltet insgesamt <code>:num</code> Bestellungen',
        'commission_title' => 'Anfragedetails',
        'counts' => 'Insgesamt <code>:num</code> Aufzeichnungen',
        'rebate_title' => 'Rabattverlauf',
        'referral' => 'Empfehlungsrabatte',
        'title' => 'Auszahlungsanfragen',
    ],
    'article' => [
        'category_hint' => 'Gleiche Kategorie wird zusammengefasst',
        'counts' => 'Insgesamt <code>:num</code> Artikel',
        'logo_placeholder' => 'Oder Logo-URL eingeben',
        'title' => 'Artikel',
        'type' => [
            'announcement' => 'Ankündigung',
            'knowledge' => 'Artikel',
        ],
    ],
    'clear' => 'Löschen',
    'clone' => 'Klonen',
    'confirm' => [
        'continues' => 'Möchten Sie diese Aktion fortsetzen?',
        'delete' => [0 => 'Möchten Sie :attribute löschen', 1 => ']?'],
        'export' => 'Möchten Sie alles exportieren?',
    ],
    'coupon' => [
        'counts' => 'Insgesamt <code>:num</code> Gutscheine',
        'created_days_hint' => '<code>:day</code> Tage nach der Registrierung',
        'discount' => 'Rabatt',
        'export_title' => 'Exportieren',
        'groups_hint' => 'Nur für ausgewählte Benutzergruppen verwendbar',
        'info_title' => 'Informationen',
        'levels_hint' => 'Nur für ausgewählte Benutzerebenen verwendbar',
        'limit_hint' => 'Regeln haben eine <strong>UND</strong>-Beziehung, bitte richtig verwenden',
        'minimum_hint' => 'Nur verwendbar, wenn die Zahlung <strong>:num</strong> übersteigt',
        'name_hint' => 'Zur Anzeige',
        'newbie' => [
            'created_days' => 'Kontodauer',
            'first_discount' => 'Erster Rabatt',
            'first_order' => 'Erste Bestellung',
        ],
        'priority_hint' => 'Der höchste berechtigte Gutschein wird zuerst verwendet. Maximal 255',
        'services_blacklist_hint' => 'Nicht für Blacklist-Produkte verwendbar, leer lassen, wenn nicht verwendet',
        'services_placeholder' => 'Produkt-ID eingeben, Enter drücken',
        'services_whitelist_hint' => 'Nur für Whitelist-Produkte verwendbar, leer lassen, wenn nicht verwendet',
        'single_use' => 'Einmalige Verwendung',
        'sn_hint' => 'Leer lassen für 8-stelligen Zufallscode',
        'title' => 'Gutscheine',
        'type' => [
            'charge' => 'Aufladen',
            'discount' => 'Rabatt',
            'voucher' => 'Gutschein',
        ],
        'type_hint' => 'Reduktion: Betrag abziehen; Rabatt: Prozentsatz abziehen; Aufladen: Betrag zum Guthaben hinzufügen',
        'used_hint' => 'Jeder Benutzer kann diesen Gutschein maximal <strong>:num</strong> Mal verwenden',
        'user_whitelist_hint' => 'Whitelist-Benutzer können verwenden, leer lassen, wenn nicht verwendet',
        'users_blacklist_hint' => 'Blacklist-Benutzer können nicht verwenden, leer lassen, wenn nicht verwendet',
        'users_placeholder' => 'Benutzer-ID eingeben, Enter drücken',
        'value' => '{1} ➖ :num|{2} :num% Rabatt|{3} ➕ :num',
        'value_hint' => 'Bereich liegt zwischen 1% und 99%',
    ],
    'creating' => 'Hinzufügen...',
    'dashboard' => [
        'abnormal_users' => 'Abnormaler Datenverkehr in der letzten Stunde',
        'active_days_users' => 'Aktive Benutzer in den letzten :days Tagen',
        'available_users' => 'Aktive Benutzer',
        'credit' => 'Gesamtkredit',
        'current_month_traffic_consumed' => 'In diesem Monat verbrauchter Datenverkehr',
        'days_traffic_consumed' => 'In den letzten :days Tagen verbrauchter Datenverkehr',
        'expiring_users' => 'Bald ablaufende Benutzer',
        'inactive_days_users' => 'Inaktive Benutzer seit über :days Tagen',
        'maintaining_nodes' => 'Knoten im Wartungsmodus',
        'nodes' => 'Knoten',
        'online_orders' => 'Online-Zahlungsbestellungen',
        'online_users' => 'Aktuell online',
        'orders' => 'Gesamtanzahl der Bestellungen',
        'overuse_users' => 'Benutzer mit Datenübernutzung [≥90%]',
        'paid_users' => 'Zahlende Benutzer',
        'succeed_orders' => 'Bezahlte Bestellungen',
        'users' => 'Gesamtanzahl der Benutzer',
        'withdrawing_commissions' => 'Ausstehende Provisionen',
        'withdrawn_commissions' => 'Ausgezahlte Provisionen',
    ],
    'end_time' => 'Ende',
    'goods' => [
        'counts' => 'Insgesamt <code>:num</code> Artikel',
        'info' => [
            'available_date_hint' => 'Daten werden automatisch vom Gesamtvolumen abgezogen, wenn fällig',
            'desc_placeholder' => 'Kurzbeschreibung',
            'limit_num_hint' => 'Maximale Anzahl von Käufen pro Benutzer, 0 für unbegrenzt',
            'list_hint' => 'Beginnen Sie jede Zeile mit <code><li></code> und enden Sie mit <code></li></code>',
            'list_placeholder' => 'Benutzerdefinierte Inhalte hinzufügen',
            'period_hint' => 'Datenvolumen wird alle N Tage für Pläne zurückgesetzt',
            'type_hint' => 'Plan beeinflusst die Kontoablaufzeit, Paket zieht nur Daten ab, beeinflusst nicht die Ablaufzeit',
        ],
        'sell_and_used' => 'Verwendet / Verkauft',
        'status' => [
            'no' => 'Nicht zum Verkauf',
            'yes' => 'Zum Verkauf',
        ],
        'title' => 'Produkte',
        'type' => [
            'package' => 'Datenpaket',
            'plan' => 'Abonnementplan',
            'top_up' => 'Aufladen',
        ],
    ],
    'hint' => 'Hinweis',
    'logs' => [
        'ban' => [
            'ban_time' => 'Gesperrt am',
            'last_connect_at' => 'Letzte Anmeldung',
            'reason' => 'Grund',
            'time' => 'Dauer',
            'title' => 'Benutzersperren',
        ],
        'callback' => 'Callback-Protokolle <small>(Zahlung)</small>',
        'counts' => 'Insgesamt <code>:num</code> Aufzeichnungen',
        'credit_title' => 'Guthabenänderungsprotokolle',
        'ip_monitor' => 'Online-IPs <small>Echtzeit 2 Minuten</small>',
        'notification' => 'E-Mail-Protokolle',
        'order' => [
            'is_coupon' => 'Gutschein verwendet',
            'is_expired' => 'Abgelaufen',
            'title' => 'Bestellungen',
            'update_conflict' => 'Aktualisierung fehlgeschlagen: Bestellkonflikt',
        ],
        'rule' => [
            'clear_all' => 'Alle Aufzeichnungen löschen',
            'clear_confirm' => 'Möchten Sie alle Auslöser-Aufzeichnungen löschen?',
            'created_at' => 'Auslösezeit',
            'name' => 'Name der ausgelösten Regel',
            'reason' => 'Auslösegrund',
            'tag' => '✅ Zugriff auf nicht autorisierte Inhalte',
            'title' => 'Regelauslöser-Aufzeichnungen',
        ],
        'subscribe' => 'Abonnements',
        'user_data_modify_title' => 'Datenänderungsaufzeichnungen',
        'user_ip' => [
            'connect' => 'Verbunden IP',
            'title' => 'Online-IPs <small>Letzte 10 Minuten</small>',
        ],
        'user_traffic' => [
            'choose_node' => 'Knoten auswählen',
            'title' => 'Datenverbrauchsaufzeichnungen',
        ],
    ],
    'marketing' => [
        'counts' => 'Insgesamt <code>:num</code> E-Mails',
        'email' => [
            'ever_paid' => 'Je Bezahlt',
            'expired_date' => 'Abgelaufene Datum',
            'filters' => 'Filter',
            'loading_statistics' => 'Lade Statistiken...',
            'never_paid' => 'Nie Bezahlt',
            'paid_servicing' => 'Bezahlte Dienste',
            'previously_paid' => 'Früher Bezahlt',
            'recent_traffic_abnormal' => 'Verkehr Abnormal in Letzter Stunde',
            'recently_active' => 'Kürzlich Aktiv',
            'targeted_users_count' => 'Zielgerichtete Benutzeranzahl',
            'traffic_usage_over' => 'Verkehrsnutzung Über N%',
            'will_expire_date' => 'Wird Ablaufen Datum',
        ],
        'email_send' => 'E-Mail senden',
        'error_message' => 'Fehlermeldungen',
        'processed' => 'Anfrage Bearbeitet',
        'push_send' => 'Benachrichtigung senden',
        'send_status' => 'Sende-Status',
        'send_time' => 'Gesendet am',
        'targeted_users_not_found' => 'Zielgerichtete Benutzer Nicht Gefunden',
        'unknown_sending_type' => 'Unbekannter Sendetyp',
    ],
    'massive_export' => 'Massenexport',
    'menu' => [
        'analysis' => [
            'accounting' => 'Buchhaltung',
            'attribute' => 'Analytik',
            'node_flow' => 'Knotenverkehrsanalyse',
            'site_flow' => 'Seitenverkehrsanalyse',
            'user_flow' => 'Benutzerverkehrsanalyse',
        ],
        'customer_service' => [
            'article' => 'Wissensdatenbank',
            'attribute' => 'Helpdesk',
            'marketing' => 'Nachrichtenübermittlung',
            'ticket' => 'Support-Tickets',
        ],
        'dashboard' => 'Dashboard',
        'log' => [
            'attribute' => 'Protokolle',
            'notify' => 'Benachrichtigungen',
            'online_logs' => 'Online-Protokolle',
            'online_monitor' => 'Online-Überwachung',
            'payment_callback' => 'Zahlungs-Callback',
            'service_ban' => 'Sperrprotokolle',
            'system' => 'Systemprotokolle',
            'traffic' => 'Datenverbrauch',
            'traffic_flow' => 'Datenfluss',
        ],
        'node' => [
            'attribute' => 'Knoten',
            'auth' => 'API-Autorisierung',
            'cert' => 'Zertifikate',
            'list' => 'Knotenverwaltung',
        ],
        'promotion' => [
            'attribute' => 'Promotion',
            'invite' => 'Empfehlungen',
            'rebate_flow' => 'Rabattverlauf',
            'withdraw' => 'Auszahlungen',
        ],
        'rbac' => [
            'attribute' => 'RBAC',
            'permission' => 'Berechtigungen',
            'role' => 'Rollen',
        ],
        'rule' => [
            'attribute' => 'Auditrichtlinien',
            'group' => 'Regelgruppen',
            'list' => 'Regeln',
            'trigger' => 'Trigger-Aufzeichnungen',
        ],
        'setting' => [
            'attribute' => 'Einstellungen',
            'email_suffix' => 'E-Mail-Filter',
            'system' => 'System',
            'universal' => 'Allgemein',
        ],
        'shop' => [
            'attribute' => 'Shop',
            'coupon' => 'Gutscheine',
            'goods' => 'Produkte',
            'order' => 'Bestellungen',
        ],
        'tools' => [
            'analysis' => 'Protokollanalyse',
            'attribute' => 'Werkzeuge',
            'convert' => 'Konvertieren',
            'decompile' => 'Dekompilieren',
            'import' => 'Importieren',
        ],
        'user' => [
            'attribute' => 'Benutzer',
            'credit_log' => 'Kreditverlauf',
            'group' => 'Benutzergruppen',
            'list' => 'Benutzerverwaltung',
            'oauth' => 'OAuth',
            'subscribe' => 'Abonnements',
        ],
    ],
    'minute' => 'Minuten',
    'monitor' => [
        'daily_chart' => 'Tägliche Datenverbrauch',
        'hint' => '<strong>Hinweis:</strong> Überprüfen Sie geplante Aufgaben, wenn keine Daten vorhanden sind',
        'monthly_chart' => 'Monatliche Datenverbrauch',
        'node' => 'Knotenverkehr',
        'user' => 'Benutzerverkehr',
    ],
    'no' => 'Nein',
    'node' => [
        'auth' => [
            'counts' => 'Insgesamt <code>:num</code> Lizenzen',
            'deploy' => [
                'attribute' => 'Backend-Bereitstellung',
                'command' => 'Anweisungen',
                'real_time_logs' => 'Echtzeitprotokolle',
                'recent_logs' => 'Aktuelle Protokolle',
                'restart' => 'Neustarten',
                'same' => 'Gleiche wie oben',
                'start' => 'Starten',
                'status' => 'Status',
                'stop' => 'Stoppen',
                'title' => 'Bereitstellen :type_label Backend',
                'trojan_hint' => 'Bitte füllen Sie </a>den Knotennamen<a href=":url" target="_blank">und analysieren Sie die entsprechende IP',
                'uninstall' => 'Deinstallieren',
                'update' => 'Aktualisieren',
            ],
            'empty' => 'Es gibt keine Knoten, die eine Autorisierungsgenerierung benötigen',
            'generating_all' => 'Bestätigen Sie die Generierung von Autorisierungsschlüsseln für alle Knoten?',
            'reset_auth' => 'Autorisierungsschlüssel zurücksetzen',
            'title' => 'API-Autorisierungen <small>WEBAPI</small>',
        ],
        'cert' => [
            'counts' => 'Insgesamt <code>:num</code> Domainzertifikate',
            'key_placeholder' => 'Der Schlüsselwert des Zertifikats kann leer gelassen werden. Das VNET-V2Ray-Backend unterstützt die automatische Ausstellung',
            'pem_placeholder' => 'Das VNET-V2Ray-Backend unterstützt die automatische Ausstellung',
            'title' => 'Domainzertifikate <small>(Für V2Ray-Knotentarnung)</small>',
        ],
        'connection_test' => 'Konnektivitätstest',
        'counts' => 'Insgesamt <code>:num</code> Knoten',
        'info' => [
            'additional_ports_hint' => 'Wenn aktiviert, bitte Server <span class="red-700"><a href="javascript:showTnc();">additional_ports</a></span> konfigurieren',
            'basic' => 'Grundinformationen',
            'data_rate_hint' => 'Zum Beispiel: 0.1 bedeutet, dass 100M als 10M gezählt werden; 5 bedeutet, dass 100M als 500M gezählt werden',
            'ddns_hint' => 'Dynamische IP-Knoten erfordern eine <a href="https://github.com/NewFuture/DDNS" target="_blank">DDNS-Konfiguration</a>. Für diesen Knotentyp wird der Konnektivitätstest über Domainnamen durchgeführt.',
            'detection' => [
                'all' => 'Beides',
                'hint' => 'Zufällige Überprüfung alle 30-60 Minuten',
                'icmp' => 'Nur ICMP',
                'tcp' => 'Nur TCP',
            ],
            'display' => [
                'all' => 'Vollständig sichtbar',
                'hint' => 'Ob im Abonnement/Knotenliste sichtbar',
                'invisible' => 'Unsichtbar',
                'node' => 'Nur auf der Knoten-Seite sichtbar',
                'sub' => 'Nur in Abonnements sichtbar',
            ],
            'domain_hint' => 'Nach Aktivierung des DDNS in den Systemeinstellungen wird der Domainname und die IPs automatisch aktualisiert! Sie müssen diese Informationen nicht mehr auf der Website des Domain-Registrars bearbeiten.',
            'domain_placeholder' => 'Server-Domain, wird zuerst verwendet, wenn ausgefüllt',
            'extend' => 'Erweiterte Informationen',
            'hint' => '<strong>Hinweis:</strong> Die automatisch generierte <code>ID</code> ist die <code>node_id</code> für das ShadowsocksR-Backend und die <code>nodeId</code> für das V2Ray-Backend',
            'ipv4_hint' => 'Mehrere IPs sollten durch Kommata getrennt werden, z.B.: 1.1.1.1,8.8.8.8',
            'ipv4_placeholder' => 'Server IPv4-Adresse',
            'ipv6_hint' => 'Mehrere IPs sollten durch Kommata getrennt werden, z.B.: 1.1.1.1,8.8.8.8',
            'ipv6_placeholder' => 'Server IPv6-Adresse',
            'level_hint' => 'Ebene: 0 - Keine Ebenenbeschränkung, alle sichtbar.',
            'obfs_param_hint' => 'Parameter für die Datenverschleierung ausfüllen, wenn obfs nicht [plain] ist; &#13;&#10;Empfohlener Port 80, wenn obfs [http_simple] ist; &#13;&#10;Empfohlener Port 443, wenn obfs [tls] ist;',
            'push_port_hint' => 'Erforderlich. Stellen Sie sicher, dass dieser Port in der Server-Firewall geöffnet ist, andernfalls wird die Nachrichtenübermittlung abnormal sein.',
            'single_hint' => 'Empfohlene Ports 80/443. Backend benötigt <br> strikte Moduskonfiguration: nur über angegebene Ports verbinden. (<a href="javascript:showPortsOnlyConfig();">Wie konfigurieren</a>)',
            'v2_cover' => [
                'dtls' => 'DTLS 1.2',
                'http' => 'HTTP',
                'none' => 'Keine',
                'srtp' => 'SRTP',
                'utp' => 'uTP',
                'wechat' => 'WeChat Video',
                'wireguard' => 'WireGuard',
            ],
            'v2_host_hint' => 'Bei Verwendung von HTTP-Tarnung sollten mehrere Domains durch Kommata getrennt werden, während WebSocket nur eine einzelne Domain zulässt.',
            'v2_method_hint' => 'WebSocket-Übertragungsprotokoll sollte keine \'none\' Verschlüsselungsmethode verwenden.',
            'v2_net_hint' => 'Bitte aktivieren Sie TLS für WebSocket',
            'v2_tls_provider_hint' => 'Unterschiedliche Backends haben unterschiedliche Konfigurationen:',
        ],
        'proxy_info' => '*Kompatibel mit Shadowsocks',
        'proxy_info_hint' => 'Zur Kompatibilität bitte <span class="red-700">_compatible</span> zu Protokoll und Verschleierung in der Server-Konfiguration hinzufügen',
        'refresh_geo' => 'Geografie aktualisieren',
        'refresh_geo_all' => 'Geodaten aktualisieren',
        'reload' => 'Backend neu laden',
        'reload_all' => 'Alle Backends neu laden',
        'reload_confirm' => 'Möchten Sie das Server-Backend neu laden?',
        'traffic_monitor' => 'Datenverkehrsstatistik',
    ],
    'oauth' => [
        'counts' => 'Insgesamt <code>:num</code> Autorisierungsaufzeichnungen',
        'title' => 'OAuth',
    ],
    'optional' => 'Optional',
    'permission' => [
        'counts' => 'Insgesamt <code>:num</code> Berechtigungen',
        'description_hint' => 'Beschreibung, z.B. [X-System] A bearbeiten',
        'name_hint' => 'Routenname, z.B. admin.user.update',
        'title' => 'Berechtigungen',
    ],
    'query' => 'Abfrage',
    'report' => [
        'annually_accounting' => 'Jährliche Transaktionen',
        'annually_site_flow' => 'Jährlicher Datenverbrauch',
        'avg_traffic_30d' => 'Durchschnittlicher täglicher Datenverkehr über 30 Tage',
        'current_month' => 'Dieser Monat',
        'current_year' => 'Dieses Jahr',
        'daily_accounting' => 'Tägliche Transaktionen',
        'daily_distribution' => 'Tägliche Verteilung',
        'daily_site_flow' => 'Täglicher Datenverbrauch',
        'daily_traffic' => 'Täglicher Datenverkehr',
        'hourly_traffic' => 'Stündlicher Datenverkehr',
        'last_month' => 'Letzter Monat',
        'last_year' => 'Letztes Jahr',
        'monthly_accounting' => 'Monatliche Transaktionen',
        'monthly_site_flow' => 'Monatlicher Datenverbrauch',
        'select_hourly_date' => 'Wählen Sie das Stunden-Datum',
        'sum_traffic_30d' => '30-Tage-Datenverkehrsverhältnis',
        'today' => 'Heute',
    ],
    'require' => 'Erforderlich',
    'role' => [
        'counts' => 'Insgesamt <code>:num</code> Rollen',
        'description_hint' => 'Anzeigename, z.B. Administrator',
        'modify_admin_error' => 'Bitte ändern Sie den Superadministrator nicht!',
        'name_hint' => 'Eindeutiger Bezeichner, z.B. admin',
        'permissions_all' => 'Alle Berechtigungen',
        'title' => 'Rollen',
    ],
    'rule' => [
        'counts' => 'Insgesamt <code>:num</code> Regeln',
        'group' => [
            'counts' => 'Insgesamt <code>:num</code> Gruppen',
            'title' => 'Regelgruppen',
            'type' => [
                'off' => 'Blockieren',
                'on' => 'Erlauben',
            ],
        ],
        'title' => 'Regeln',
        'type' => [
            'domain' => 'Domain',
            'ip' => 'IP',
            'protocol' => 'Protokoll',
            'reg' => 'Regex',
        ],
    ],
    'select_all' => 'Alle auswählen',
    'selected_hint' => 'Die verteilten Regeln können hier durchsucht werden',
    'set_to' => 'Setze als :attribute',
    'setting' => [
        'common' => [
            'connect_nodes' => '# der Knoten',
            'set_default' => 'Als Standard festlegen',
            'title' => 'Allgemeine Konfiguration',
        ],
        'email' => [
            'black' => 'Blacklist',
            'rule' => 'Einschränkungsart',
            'tail' => 'E-Mail-Suffix',
            'tail_placeholder' => 'E-Mail-Suffix eingeben',
            'title' => 'E-Mail-Filter <small>(für Registrierung)</small>',
            'white' => 'Whitelist',
        ],
        'no_permission' => 'Keine Berechtigung, Einstellungen zu ändern!',
        'system' => [
            'account' => 'Konto',
            'auto_job' => 'Automatisierung',
            'check_in' => 'Einchecken',
            'extend' => 'Erweitert',
            'menu' => 'Menü',
            'node' => 'Knoten',
            'notify' => 'Benachrichtigung',
            'other' => 'Logo|CS|Analytics',
            'payment' => 'Zahlung',
            'promotion' => 'Affiliate',
            'title' => 'Systemeinstellungen',
            'web' => 'Allgemein',
        ],
    ],
    'sort_asc' => 'Größerer Sortierwert hat höhere Priorität',
    'start_time' => 'Start',
    'system' => [
        'AppStore_id' => '[Apple] Konto',
        'AppStore_password' => '[Apple] Passwort',
        'account_expire_notification' => 'Benachrichtigung über Kontoablauf',
        'active_account' => [
            'after' => 'Aktivierung nach der Registrierung',
            'before' => 'Aktivierung vor der Registrierung',
        ],
        'active_times' => 'Maximale Kontoaktivierungen',
        'admin_invite_days' => '[Admin] Einladungslaufzeit',
        'aff_salt' => '[Empfehlungs-URL] Benutzer-ID verschlüsseln',
        'alipay_qrcode' => 'Alipay QR-Code',
        'auto_release_port' => 'Port-Recycling',
        'bark_key' => '[Bark] Geräteschlüssel',
        'captcha' => [
            'geetest' => 'Geetest',
            'hcaptcha' => 'hCaptcha',
            'recaptcha' => 'Google ReCaptcha',
            'standard' => 'Standard',
            'turnstile' => 'Turnstile',
        ],
        'captcha_key' => 'Captcha-Schlüssel',
        'captcha_secret' => 'Captcha-Geheimnis/ID',
        'codepay_id' => '[CodePay] ID',
        'codepay_key' => '[CodePay] Schlüssel',
        'codepay_url' => '[CodePay] URL',
        'data_anomaly_notification' => 'Benachrichtigung über Datenanomalie',
        'data_exhaust_notification' => 'Benachrichtigung über Datenerschöpfung',
        'ddns_key' => '[DNS] Schlüssel',
        'ddns_mode' => 'DNS-Synchronisierung',
        'ddns_secret' => '[DNS] Geheimnis',
        'default_days' => 'Standard-Kontodauer',
        'default_traffic' => 'Standard-Anfangsdaten',
        'demo_restriction' => 'In der Demo-Umgebung ist das Ändern dieser Konfiguration untersagt!',
        'detection_check_times' => 'Knotenblockierungswarnungen',
        'dingTalk_access_token' => '[DingTalk] Zugriffstoken',
        'dingTalk_secret' => '[DingTalk] Geheimnis',
        'epay_key' => '[ePay] Schlüssel',
        'epay_mch_id' => '[ePay] Händler-ID',
        'epay_url' => '[ePay] URL',
        'expire_days' => 'Ablaufwarnung',
        'f2fpay_app_id' => '[Alipay] APP ID',
        'f2fpay_private_key' => '[Alipay] Privatschlüssel',
        'f2fpay_public_key' => '[Alipay] Öffentlicher Schlüssel',
        'forbid' => [
            'china' => 'Zugriff aus China verbieten',
            'mainland' => 'Zugriff aus dem chinesischen Festland verbieten',
            'oversea' => 'Übersee-Zugriff verbieten',
        ],
        'forbid_mode' => 'Zugriffsbeschränkung',
        'hint' => [
            'AppStore_id' => 'Verwendet in Artikeln',
            'AppStore_password' => 'Verwendet in Artikeln',
            'account_expire_notification' => 'Benachrichtigung über Ablauf',
            'active_times' => 'Über E-Mail in 24 Stunden',
            'admin_invite_days' => 'Admin-Einladungslaufzeit',
            'aff_salt' => 'Verschlüsselungssalt für Empfehlungs-URL',
            'auto_release_port' => 'Automatische Freigabe des Ports nach <code>'.config('tasks.release_port').'</code> Tagen Sperre/Ablauf',
            'bark_key' => 'Geräteschlüssel für iOS-Push',
            'captcha_key' => 'Anleitung <a href="https://proxypanel.gitbook.io/wiki/captcha" target="_blank">hier</a>',
            'data_anomaly_notification' => 'Benachrichtige Admin, wenn stündliche Daten den Schwellenwert überschreiten',
            'data_exhaust_notification' => 'Benachrichtige, wenn Daten fast aufgebraucht sind',
            'ddns_key' => 'Anleitung <a href="https://proxypanel.gitbook.io/wiki/ddns" target="_blank">hier</a>',
            'ddns_mode' => 'Synchronisiere Domain- und IP-Änderungen mit DNS-Anbieter',
            'default_days' => 'Standard-Ablaufzeit für neue Konten, 0 bedeutet heute ablaufen',
            'default_traffic' => 'Standard-Daten für neue Konten',
            'detection_check_times' => 'Automatisches Offline-Schalten des Knotens nach N Warnungen, 0 für unbegrenzt, max 12',
            'dingTalk_access_token' => 'Benutzerdefinierter Bot <a href=https://open.dingtalk.com/document/group/custom-robot-access#title-jfe-yo9-jl2 target=_blank>Zugriffstoken</a>',
            'dingTalk_secret' => 'Geheimnis des benutzerdefinierten Bots bei aktiviertem Sign',
            'expire_days' => 'Beginne Benachrichtigung über Kontoablauf',
            'f2fpay_app_id' => 'Alipay APPID',
            'f2fpay_private_key' => 'Alipay Privatschlüssel vom Geheimschlüssel-Tool',
            'f2fpay_public_key' => 'Nicht der öffentliche APP-Schlüssel!',
            'forbid_mode' => 'Blockiere den Zugriff aus bestimmten Regionen',
            'iYuu_token' => 'Fülle <a href=https://iyuu.cn target=_blank>IYUU Token</a> aus, bevor aktiviert',
            'invite_num' => 'Standardanzahl der Einladungen pro Benutzer',
            'is_activate_account' => 'Aktivierung per E-Mail erforderlich',
            'is_ban_status' => '(Vorsicht) Konto sperren setzt alle Benutzerdaten zurück',
            'is_captcha' => 'Captcha erforderlich zum Einloggen/Registrieren, wenn aktiviert',
            'is_checkin' => 'Zufällige Belohnung beim Einchecken',
            'is_clear_log' => '(Empfohlen) Automatische Bereinigung von nutzlosen/veralteten Protokollen bei Aktivierung',
            'is_custom_subscribe' => 'Zeige Ablauf und verbleibende Daten im Abonnement, wenn aktiviert',
            'is_email_filtering' => 'Schwarze Liste: Benutzer können sich mit E-Mail-Suffixen registrieren, die nicht auf der schwarzen Liste stehen; Weiße Liste: Benutzer müssen sich mit E-Mail-Suffixen registrieren, die auf der weißen Liste stehen',
            'is_forbid_robot' => '404-Fehler zurückgeben, wenn von Bots/Proxies zugegriffen wird',
            'is_free_code' => 'Verstecke kostenlose Einladungscodes, wenn deaktiviert',
            'is_rand_port' => 'Zufälliger Port bei Benutzerregistrierung/-hinzufügung',
            'is_register' => 'Registrierung deaktivieren, wenn nicht ausgewählt',
            'is_subscribe_ban' => 'Automatische Sperre, wenn Abonnementanfragen den Schwellenwert überschreiten',
            'is_traffic_ban' => 'Automatische Deaktivierung des Dienstes, wenn Daten den Schwellenwert in 1 Stunde überschreiten',
            'maintenance_content' => 'Benutzerdefinierte Wartungsmitteilung',
            'maintenance_mode' => 'Leite normale Benutzer auf Wartungsseite um, wenn aktiviert | Admin kann sich über <a href=\'javascript:(0)\'>:url</a> anmelden',
            'maintenance_time' => 'Für Countdown auf der Wartungsseite',
            'min_port' => 'Portrange 1000 - 65535',
            'node_blocked_notification' => 'Stündliche Erkennung von Knotenblockierungen, Benachrichtigung an Admins',
            'node_daily_notification' => 'Täglicher Knotenbenutzungsbericht',
            'node_offline_notification' => 'Alle 10 Minuten Offline-Erkennung, Benachrichtigung bei Offline-Knoten',
            'node_renewal_notification' => 'Erinnern Sie den Administrator 7 Tage, 3 Tage und 1 Tag vor Ablauf daran, den Knoten zu verlängern.',
            'oauth_path' => 'Bitte Plattformen zuerst in .ENV aktivieren',
            'offline_check_times' => 'Beende Benachrichtigung nach N Warnungen in 24 Stunden',
            'password_reset_notification' => 'Erlaube Passwortzurücksetzung per E-Mail, wenn aktiviert',
            'paybeaver_app_id' => '<a href="https://merchant.paybeaver.com/" target="_blank">Händlerzentrum</a> -> Entwickler -> App ID',
            'paybeaver_app_secret' => '<a href="https://merchant.paybeaver.com/" target="_blank">Händlerzentrum</a> -> Entwickler -> App-Geheimnis',
            'payjs_mch_id' => 'Erhalte von <a href="https://payjs.cn/dashboard/member" target="_blank">Mitgliedsseite</a>',
            'payment_confirm_notification' => 'Benachrichtige Admin zur Bearbeitung manueller Zahlungsaufträge',
            'payment_received_notification' => 'Benachrichtige Benutzer bei Zahlungseingang',
            'pushDeer_key' => 'Fülle <a href=https://www.pushdeer.com/official.html target=_blank>PushDeer Push Key</a> aus, bevor aktiviert',
            'pushplus_token' => 'Fülle <a href=https://www.pushplus.plus/push1.html target=_blank>PushPlus Token</a> aus, bevor aktiviert',
            'rand_subscribe' => 'Zufällige Reihenfolge, wenn aktiviert, sonst nach Knotenliste',
            'redirect_url' => 'Leite blockierte Anfragen auf diese URL um, wenn Regeln ausgelöst werden',
            'referral_money' => 'Mindestbetrag für Auszahlungen',
            'referral_percent' => 'Prozentsatz des Bestellbetrags, den der Werber erhält',
            'referral_status' => 'Schließe Empfehlungsprogramm ohne Beeinträchtigung bestehender Daten',
            'referral_traffic' => 'Gib kostenloses Datenvolumen bei Registrierung über Empfehlung',
            'referral_type' => 'Neue Rabatte werden nach dem Wechsel nach neuem Modus berechnet',
            'register_ip_limit' => 'Anzahl der Registrierungen pro IP in 24 Stunden, 0 für unbegrenzt',
            'reset_password_times' => 'Anzahl der Passwortzurücksetzungen per E-Mail in 24 Stunden',
            'reset_traffic' => 'Automatische Datenrücksetzung basierend auf Benutzerplanzyklus',
            'server_chan_key' => 'Fülle <a href="https://sct.ftqq.com/r/2626" target="_blank">ServerChan SCKEY</a> aus, bevor aktiviert',
            'standard_currency' => 'Primärwährung im Panel',
            'subject_name' => 'Benutzerdefinierter Produktname in Zahlungsgateways',
            'subscribe_ban_times' => 'Maximale Abonnementanfragen pro Benutzer in 24 Stunden',
            'subscribe_domain' => 'Beginne mit http:// oder https://, um DNS-Vergiftung zu vermeiden',
            'subscribe_max' => 'Maximale Anzahl der Knoten im Abonnement, 0 für alle',
            'telegram_token' => 'Erhalte Bot <a href=https://t.me/BotFather target=_blank>TOKEN</a> von @BotFather',
            'tg_chat_token' => 'Fülle <a href=https://t.me/realtgchat_bot target=_blank>TG Chat Token</a> aus, bevor aktiviert',
            'ticket_closed_notification' => 'Benachrichtige Benutzer bei Ticket-Schließung',
            'ticket_created_notification' => 'Benachrichtige Admin/Benutzer je nach Ersteller',
            'ticket_replied_notification' => 'Benachrichtige andere Partei bei Ticketantwort',
            'traffic_ban_time' => 'Dauer der automatischen Sperre bei Ausnahmen',
            'traffic_ban_value' => 'Automatische Kontosperre, wenn dieser Wert in 1 Stunde überschritten wird',
            'traffic_limit_time' => 'Zeitintervall zwischen Check-ins',
            'traffic_warning_percent' => 'Sende Datenverbrauchswarnung, wenn tägliche Nutzung diesen Prozentsatz erreicht',
            'user_invite_days' => 'Ablauf von Benutzereinladungscodes',
            'username_type' => 'Standard-Benutzernamensart für Benutzer',
            'v2ray_tls_provider' => 'Knoteneinstellungen überschreiben diese TLS-Konfiguration',
            'web_api_url' => 'Z.B. '.config('app.url'),
            'webmaster_email' => 'Kontakt-E-Mail in einigen Fehlermeldungen',
            'website_analytics' => 'Analytik-JavaScript-Code',
            'website_callback_url' => 'Verhindere Zahlungs-Callback-Fehler durch DNS-Vergiftung',
            'website_customer_service' => 'Kundendienst-JavaScript-Code',
            'website_name' => 'Webseitenname in E-Mails',
            'website_security_code' => 'Erfordere Sicherheitscode zum Zugriff auf die Seite, wenn gesetzt',
            'website_url' => 'Hauptdomäne für Links',
            'wechat_aid' => '<a href="https://work.weixin.qq.com/wework_admin/frame#apps" target="_blank">App-Verwaltung</a> -> AgentId',
            'wechat_cid' => 'Erhalte von <a href="https://work.weixin.qq.com/wework_admin/frame#profile" target="_blank">Unternehmensinfo</a>',
            'wechat_encodingAESKey' => 'App-Verwaltung -> App-Einstellungen -> EncodingAESKey',
            'wechat_secret' => 'App-Geheimnis (möglicherweise muss die Unternehmens-WeChat-App heruntergeladen werden, um es anzuzeigen)',
            'wechat_token' => 'App-Einstellungen -> TOKEN, Callback-URL: :url',
        ],
        'iYuu_token' => '[IYUU] Token',
        'invite_num' => 'Standard-Einladungen',
        'is_AliPay' => 'Alipay',
        'is_QQPay' => 'QQ Pay',
        'is_WeChatPay' => 'WeChat Pay',
        'is_activate_account' => 'Kontoaktivierung',
        'is_ban_status' => 'Ablauf-Sperre',
        'is_captcha' => 'Captcha',
        'is_checkin' => 'Check-in-Belohnung',
        'is_clear_log' => 'Protokolle bereinigen',
        'is_custom_subscribe' => 'Erweitertes Abonnement',
        'is_email_filtering' => 'E-Mail-Filterung für Benutzerregistrierung',
        'is_forbid_robot' => 'Bots verbieten',
        'is_free_code' => 'Kostenlose Einladungscodes',
        'is_invite_register' => 'Einladung zur Registrierung',
        'is_otherPay' => 'Benutzerdefinierte Zahlung',
        'is_rand_port' => 'Zufälliger Port',
        'is_register' => 'Registrierung',
        'is_subscribe_ban' => 'Abonnement-Sperre',
        'is_traffic_ban' => 'Datenmissbrauchs-Sperre',
        'maintenance_content' => 'Wartungsmitteilung',
        'maintenance_mode' => 'Wartungsmodus',
        'maintenance_time' => 'Wartungsende',
        'min_port' => 'Portrange',
        'min_rand_traffic' => 'Datenrange',
        'node_blocked_notification' => 'Benachrichtigung über Knotenblockierung',
        'node_daily_notification' => 'Täglicher Knotenbericht',
        'node_offline_notification' => 'Benachrichtigung über Knotenoffline',
        'node_renewal_notification' => 'Knotenerneuerungsbenachrichtigung',
        'notification' => [
            'channel' => [
                'bark' => 'Bark',
                'dingtalk' => 'DingTalk',
                'email' => 'E-Mail',
                'iyuu' => 'IYUU',
                'pushdeer' => 'PushDeer',
                'pushplus' => 'PushPlus',
                'serverchan' => 'ServerChan',
                'site' => 'Seiten-Popup',
                'telegram' => 'Telegram',
                'tg_chat' => 'TG Chat',
                'wechat' => 'Enterprise WeChat',
            ],
            'send_test' => 'Testnachricht senden',
            'test' => [
                'content' => 'Testinhalt',
                'success' => 'Erfolgreich gesendet. Bitte prüfen Sie, ob die Push-Benachrichtigung auf Ihrem Handy eingegangen ist.',
                'title' => 'Dies ist ein Testtitel',
                'unknown_channel' => 'Unbekannter Kanal',
            ],
        ],
        'oauth_path' => 'OAuth-Plattformen',
        'offline_check_times' => 'Offline-Benachrichtigungen',
        'params_required' => 'Bitte vervollständigen Sie zunächst die erforderlichen Parameter für dieses :attribute!',
        'password_reset_notification' => 'Benachrichtigung über Passwortzurücksetzung',
        'paybeaver_app_id' => '[PayBeaver] App ID',
        'paybeaver_app_secret' => '[PayBeaver] App-Geheimnis',
        'payjs_key' => '[PayJs] Schlüssel',
        'payjs_mch_id' => '[PayJs] Händler-ID',
        'payment' => [
            'attribute' => 'Zahlungsgateway',
            'channel' => [
                'alipay' => 'Alipay F2F',
                'codepay' => 'CodePay',
                'epay' => 'ePay',
                'manual' => 'Manuelle Zahlung',
                'paybeaver' => 'PayBeaver',
                'payjs' => 'PayJs',
                'paypal' => 'PayPal',
                'stripe' => 'Stripe',
                'theadpay' => 'THeadPay',
            ],
            'hint' => [
                'alipay' => 'Diese Funktion erfordert eine Bewerbung auf der <a href="https://open.alipay.com/platform/appManage.htm?#/create/" target="_blank">Ant Financial Services Open Platform</a> für Berechtigungen und Anwendungen',
                'codepay' => 'Bitte bei <a href="https://codepay.fateqq.com/i/377289" target="_blank">CodePay</a> ein Konto beantragen, dann die Software herunterladen und einrichten',
                'manual' => 'Nach dem Setzen und Auswählen des Gateways wird es auf der Benutzerseite angezeigt',
                'paybeaver' => 'Bitte bei <a href="https://merchant.paybeaver.com/?aff_code=iK4GNuX8" target="_blank">PayBeaver</a> ein Konto beantragen',
                'payjs' => 'Bitte bei <a href="https://payjs.cn/ref/zgxjnb" target="_blank">PayJs</a> ein Konto beantragen',
                'paypal' => 'Melden Sie sich mit Ihrem Händlerkonto bei der <a href="https://www.paypal.com/businessprofile/mytools/apiaccess/firstparty" target="_blank">API-Zugangsseite</a> an, stimmen Sie zu und erhalten Sie die Setup-Informationen',
                'theadpay' => 'Bitte bei <a href="https://theadpay.com/" target="_blank">THeadPay</a> ein Konto beantragen',
            ],
        ],
        'payment_confirm_notification' => 'Benachrichtigung über Zahlungsbestätigung',
        'payment_received_notification' => 'Benachrichtigung über Zahlungseingang',
        'paypal_app_id' => 'App ID',
        'paypal_client_id' => 'Client-ID',
        'paypal_client_secret' => 'Client-Geheimnis',
        'placeholder' => [
            'bark_key' => 'Fülle Bark Geräteschlüssel aus und klicke auf Aktualisieren',
            'codepay_url' => 'https://codepay.fateqq.com/creat_order/?',
            'default_url' => 'Standard ist :url',
            'dingTalk_access_token' => 'Zugriffstoken des benutzerdefinierten Bots',
            'dingTalk_secret' => 'Geheimnis des benutzerdefinierten Bots nach Signierung',
            'iYuu_token' => 'Fülle IYUU Token aus und klicke auf Aktualisieren',
            'pushDeer_key' => 'Fülle PushDeer Push Key aus und klicke auf Aktualisieren',
            'pushplus_token' => 'Bitte bei ServerChan beantragen',
            'server_chan_key' => 'Fülle ServerChan SCKEY aus und klicke auf Aktualisieren',
            'telegram_token' => 'Fülle Telegram Token aus und klicke auf Aktualisieren',
            'tg_chat_token' => 'Bitte bei Telegram beantragen',
            'wechat_aid' => 'WeChat Enterprise App AID',
            'wechat_cid' => 'Fülle WeChat CID aus und klicke auf Aktualisieren',
            'wechat_secret' => 'Geheimnis der WeChat Enterprise App',
        ],
        'pushDeer_key' => '[PushDeer] Schlüssel',
        'pushplus_token' => '[PushPlus] Token',
        'rand_subscribe' => 'Zufälliges Abonnement',
        'redirect_url' => 'Weiterleitungs-URL',
        'referral' => [
            'loop' => 'Dauerhafter Rabatt',
            'once' => 'Erstkaufrabatt',
        ],
        'referral_money' => 'Minimale Auszahlungssumme',
        'referral_percent' => 'Rabattprozentsatz',
        'referral_status' => 'Affiliate',
        'referral_traffic' => 'Registrierungsbonus',
        'referral_type' => 'Rabattart',
        'register_ip_limit' => 'Registrierungs-IP-Beschränkung',
        'reset_password_times' => 'Passwortzurücksetzungsversuche',
        'reset_traffic' => 'Datenrücksetzung',
        'server_chan_key' => '[ServerChan] SCKEY',
        'standard_currency' => 'Primärwährung',
        'stripe_public_key' => 'Öffentlicher Schlüssel',
        'stripe_secret_key' => 'Geheimer Schlüssel',
        'stripe_signing_secret' => 'Webhook-Geheimnis',
        'subject_name' => 'Benutzerdefinierter Produktname',
        'subscribe_ban_times' => 'Abonnement-Beschränkung',
        'subscribe_domain' => 'Abonnement-URL',
        'subscribe_max' => 'Maximale Abonnement-Knoten',
        'telegram_token' => 'Telegram-Token',
        'tg_chat_token' => 'TG Chat Token',
        'theadpay_key' => '[THeadPay] Schlüssel',
        'theadpay_mchid' => '[THeadPay] Händler-ID',
        'theadpay_url' => '[THeadPay] URL',
        'ticket_closed_notification' => 'Benachrichtigung über Ticket-Schließung',
        'ticket_created_notification' => 'Benachrichtigung über Ticketerstellung',
        'ticket_replied_notification' => 'Benachrichtigung über Ticketantwort',
        'traffic_ban_time' => 'Sperrdauer',
        'traffic_ban_value' => 'Datenmissbrauchsgrenze',
        'traffic_limit_time' => 'Check-in-Intervall',
        'traffic_warning_percent' => 'Datenverbrauchswarnung',
        'trojan_license' => 'Trojan-Lizenz',
        'user_invite_days' => '[Benutzer] Einladungslaufzeit',
        'username' => [
            'any' => 'Beliebiger Benutzername',
            'email' => 'E-Mail',
            'mobile' => 'Telefonnummer',
        ],
        'username_type' => 'Kontobenutzernamensart',
        'v2ray_license' => 'V2Ray-Lizenz',
        'v2ray_tls_provider' => 'V2Ray TLS-Konfiguration',
        'web_api_url' => 'API-Domäne',
        'webmaster_email' => 'Admin-E-Mail',
        'website_analytics' => 'Analytik-Code',
        'website_callback_url' => 'Zahlungs-Callback-Domain',
        'website_customer_service' => 'Kundendienst-Code',
        'website_home_logo' => 'Startseiten-Logo',
        'website_logo' => 'Internes Seiten-Logo',
        'website_name' => 'Webseitenname',
        'website_security_code' => 'Sicherheitscode',
        'website_url' => 'Webseitendomäne',
        'wechat_aid' => 'WeChat AID',
        'wechat_cid' => 'WeChat CID',
        'wechat_encodingAESKey' => 'WeChat Encoding-Schlüssel',
        'wechat_qrcode' => 'WeChat QR-Code',
        'wechat_secret' => 'WeChat Geheimnis',
        'wechat_token' => 'WeChat Token',
    ],
    'system_generate' => 'Systemgeneriert',
    'ticket' => [
        'close_confirm' => 'Möchten Sie dieses Ticket schließen?',
        'counts' => 'Insgesamt <code>:num</code> Tickets',
        'error' => 'Unbekannter Fehler! Bitte überprüfen Sie die Protokolle',
        'inviter_info' => 'Einlader-Informationen',
        'self_send' => 'Sie können kein Ticket für sich selbst erstellen!',
        'send_to' => 'Bitte füllen Sie die Angaben des Zielbenutzers aus',
        'title' => 'Tickets',
        'user_info' => 'Benutzerinformationen',
    ],
    'times' => 'Zeiten',
    'tools' => [
        'analysis' => [
            'file_missing' => ':file_name existiert nicht. Bitte erstellen Sie die Datei zuerst.',
            'not_enough' => 'Weniger als 15.000 Aufzeichnungen, Analyse nicht möglich',
            'req_url' => 'Zuletzt angeforderte URL-Aufzeichnungen',
            'title' => 'SSR-Protokollanalyse <small>Für einen einzelnen Knoten</small>',
        ],
        'convert' => [
            'content_placeholder' => 'Bitte füllen Sie die zu konvertierenden Konfigurationsinformationen aus.',
            'file_missing' => 'Datei nicht gefunden. Bitte überprüfen Sie die Verzeichnisberechtigungen.',
            'missing_error' => 'Konvertierung fehlgeschlagen: Das Konfigurationsinfo fehlt das Feld [port_password] oder dieses Feld ist leer.',
            'params_unknown' => 'Parameterfehler',
            'title' => 'Formatkonvertierung <small>SS zu SSR</small>',
        ],
        'decompile' => [
            'attribute' => 'Umgekehrte Parsing-Konfigurationslink',
            'content_placeholder' => 'Bitte füllen Sie die zu dekompilierenden ShadowsocksR-Links aus, getrennt durch Zeilenumbrüche.',
            'title' => 'Dekompilieren <small>Konfigurationsinformationen</small>',
        ],
        'import' => [
            'file_error' => 'Ein unbekannter Fehler ist aufgetreten. Bitte laden Sie die Datei erneut hoch.',
            'file_required' => 'Bitte wählen Sie eine Datei zum Hochladen aus',
            'file_type_error' => 'Nur :type-Dateien sind zum Hochladen erlaubt.',
            'format_error' => 'Fehler bei der Formatierung des Inhalts. Bitte laden Sie eine :type-Datei hoch, die dem angegebenen Format entspricht.',
        ],
    ],
    'unselected_hint' => 'Zu verteilende Regeln können hier durchsucht werden',
    'user' => [
        'admin_deletion' => 'Systemadministratoren können nicht gelöscht werden',
        'bulk_account_quantity' => 'Anzahl der in großen Mengen generierten Konten',
        'connection_test' => 'Verbindungstest',
        'counts' => 'Insgesamt <code>:num</code> Konten',
        'group' => [
            'counts' => 'Insgesamt <code>:num</code> Gruppen',
            'name' => 'Gruppenname',
            'title' => 'Benutzergruppensteuerung<small> (Ein Knoten kann in mehreren Gruppen sein, aber der Benutzer kann nur einer Gruppe angehören; für Benutzer sichtbare/verfügbare Knoten hat die Gruppe Vorrang vor der Ebene)</small>',
        ],
        'info' => [
            'account' => 'Kontoinformationen',
            'expired_date_hint' => 'Leer lassen für eine Standardgültigkeit von einem Jahr',
            'proxy' => 'Proxy-Informationen',
            'recharge_placeholder' => 'Wenn negativ, wird das Guthaben abgezogen',
            'reset_date_hint' => 'Nächstes Datum für Datenrücksetzung',
            'switch' => 'Identität wechseln',
            'uuid_hint' => 'UUID für V2Ray',
        ],
        'online_monitor' => 'Online-Überwachung',
        'proxies_config' => 'Verbindungsinformationen für :username',
        'proxy_info' => 'Konfigurationsinformationen',
        'reset_confirm' => [0 => 'Möchten Sie den Datenverkehr von [', 1 => '] zurücksetzen?'],
        'reset_traffic' => 'Daten zurücksetzen',
        'traffic_monitor' => 'Datenverkehrsstatistik',
        'update_help' => 'Aktualisierung erfolgreich, zurückkehren?',
        'user_view' => 'Zur Benutzeransicht wechseln',
    ],
    'user_dashboard' => 'Benutzer-Dashboard',
    'yes' => 'Ja',
    'zero_unlimited_hint' => '0 oder leer für unbegrenzt',
];
