// Tournament Setting JS - sử dụng jQuery & SweetAlert2
$(function () {
    const swalOptions = {
        confirmButtonColor: '#8bc34a',
        cancelButtonColor: '#607d8b',
        confirmButtonText: 'Thực hiện',
        cancelButtonText: 'Hủy',
    };

    const handleAjaxError = (xhr, defaultError) => {
        const error = xhr.responseJSON?.error || defaultError;
        Swal.fire('Lỗi', error, 'error');
    };

    const reloadPage = () => {
        Swal.fire({
            title: 'Thành công!',
            text: 'Đang tải lại trang...',
            icon: 'success',
            timer: 1500,
            showConfirmButton: false,
        }).then(() => location.reload());
    };

    // Thêm bảng đấu
    $('#btnAddGroup').on('click', function () {
        Swal.fire({
            ...swalOptions,
            title: 'Thêm bảng đấu mới',
            input: 'text',
            inputLabel: 'Tên bảng',
            inputPlaceholder: 'Vd: Bảng A, Bảng B...',
            showCancelButton: true,
            inputValidator: (value) => {
                if (!value) {
                    return 'Bạn cần nhập tên bảng!'
                }
            }
        }).then(result => {
            if (result.isConfirmed && result.value) {
                $.post(window.tournamentSettingApi.addGroup, { name: result.value, _token: window.Laravel.csrfToken })
                    .done(reloadPage)
                    .fail(xhr => handleAjaxError(xhr, 'Không thể thêm bảng đấu.'));
            }
        });
    });

    // Xóa bảng đấu
    $(document).on('click', '.btnDeleteGroup', function () {
        var groupId = $(this).data('id');
        Swal.fire({
            ...swalOptions,
            title: 'Bạn chắc chắn muốn xóa?',
            text: "Hành động này sẽ xóa bảng đấu và các cặp đấu bên trong. Không thể hoàn tác!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#e53935',
        }).then(result => {
            if (result.isConfirmed) {
                $.ajax({
                    url: window.tournamentSettingApi.deleteGroup.replace(':id', groupId),
                    type: 'POST',
                    data: { _method: 'DELETE', _token: window.Laravel.csrfToken },
                })
                .done(reloadPage)
                .fail(xhr => handleAjaxError(xhr, 'Không thể xóa bảng đấu.'));
            }
        });
    });

    // Logout
    $('#btnLogout').on('click', function () {
        $.post(window.tournamentSettingApi.logout, { tournamentId: window.tournamentId, _token: window.Laravel.csrfToken })
            .done(() => {
                Swal.fire('Đã đăng xuất', 'Đang chuyển hướng...', 'success').then(() => location.reload());
            })
            .fail(xhr => handleAjaxError(xhr, 'Không thể đăng xuất.'));
    });

    // Thêm cặp đấu
    $(document).on('click', '.btnAddPair', function () {
        var groupId = $(this).data('id');
        $.get(window.tournamentSettingApi.approvedPlayers, { groupId: groupId })
            .done(function (data) {
                if (!data || !data.pairs || data.pairs.filter(p => !p.disabled).length === 0) {
                    Swal.fire('Không có cặp đấu', 'Tất cả các vận động viên đã được xếp vào cặp trong bảng này.', 'info');
                    return;
                }

                let optionsHtml = '';
                data.pairs.forEach(function (pair) {
                    if (!pair.disabled) {
                        const text = `${pair.player1.name} & ${pair.player2.name}`;
                        const value = `${pair.player1.id}-${pair.player2.id}`;
                        optionsHtml += `<option value="${value}">${text}</option>`;
                    }
                });

                Swal.fire({
                    ...swalOptions,
                    title: 'Thêm cặp đấu vào bảng',
                    html: `<select id="pairSelect" class="swal2-input">${optionsHtml}</select>`,
                    showCancelButton: true,
                    preConfirm: () => {
                        const val = $('#pairSelect').val();
                        if (!val) return false;
                        const ids = val.split('-');
                        return [ids[0], ids[1]];
                    },
                }).then(result => {
                    if (result.isConfirmed && result.value) {
                        $.post(window.tournamentSettingApi.addPair.replace(':id', groupId), {
                            player1_id: result.value[0],
                            player2_id: result.value[1],
                            _token: window.Laravel.csrfToken
                        })
                        .done(reloadPage)
                        .fail(xhr => handleAjaxError(xhr, 'Không thể thêm cặp đấu.'));
                    }
                });
            })
            .fail(xhr => handleAjaxError(xhr, 'Không thể tải danh sách vận động viên.'));
    });

    // Xóa cặp đấu
    $(document).on('click', '.btnDeletePair', function () {
        var pairId = $(this).data('id');
        Swal.fire({
            ...swalOptions,
            title: 'Xóa cặp đấu này?',
            text: "Hành động này không thể hoàn tác!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#e53935',
        }).then(result => {
            if (result.isConfirmed) {
                $.ajax({
                    url: window.tournamentSettingApi.deletePair.replace(':id', pairId),
                    type: 'POST',
                    data: { _method: 'DELETE', _token: window.Laravel.csrfToken },
                })
                .done(reloadPage)
                .fail(xhr => handleAjaxError(xhr, 'Không thể xóa cặp đấu.'));
            }
        });
    });

    // Tự động tạo vòng đấu bảng
    $('#btnAutoCreateRounds').on('click', function () {
        Swal.fire({
            ...swalOptions,
            title: 'Tự động tạo vòng đấu?',
            text: 'Hệ thống sẽ tự động tạo các vòng đấu cho các bảng hiện có. Tiếp tục?',
            icon: 'info',
            showCancelButton: true,
        }).then((result) => {
            if (result.isConfirmed) {
                $.post(window.tournamentSettingApi.autoCreateRounds, { _token: window.Laravel.csrfToken })
                    .done(reloadPage)
                    .fail(xhr => handleAjaxError(xhr, 'Không thể tạo vòng đấu.'));
            }
        });
    });

    // Thêm vòng đấu
    $('#btnAddRound').on('click', function () {
        Swal.fire({
            ...swalOptions,
            title: 'Thêm vòng đấu mới',
            html:
                '<input id="roundName" class="swal2-input" placeholder="Tên vòng đấu (vd: Vòng 1, Bán kết...)">' +
                '<select id="roundType" class="swal2-input">' +
                '<option value="normal">Vòng tròn (Normal)</option>' +
                '<option value="round_tree">Loại trực tiếp (Play-off)</option>' +
                '</select>',
            focusConfirm: false,
            showCancelButton: true,
            preConfirm: () => {
                const name = $('#roundName').val();
                if (!name) {
                    Swal.showValidationMessage(`Bạn cần nhập tên vòng đấu!`);
                    return false;
                }
                return [name, $('#roundType').val()];
            },
        }).then(result => {
            if (result.isConfirmed && result.value) {
                $.post(window.tournamentSettingApi.addRound, {
                    name: result.value[0],
                    type: result.value[1],
                    _token: window.Laravel.csrfToken
                })
                .done(reloadPage)
                .fail(xhr => handleAjaxError(xhr, 'Không thể thêm vòng đấu.'));
            }
        });
    });

    // Thêm trận đấu
    $(document).on('click', '.btnAddMatch', function () {
        const roundId = $(this).data('id');
        $.get(window.tournamentSettingApi.getTournamentPairs)
            .done(function (pairs) {
                if (!pairs || pairs.length < 2) {
                    Swal.fire('Không đủ cặp đấu', 'Cần có ít nhất 2 cặp đấu trong giải để tạo một trận đấu.', 'info');
                    return;
                }

                const createSelectHtml = (id, selectedPairId) => {
                    let html = `<select id="${id}" class="swal2-input">`;
                    pairs.forEach(pair => {
                        const text = `${pair.player1.name} & ${pair.player2.name}`;
                        const selected = pair.id === selectedPairId ? 'selected' : '';
                        html += `<option value="${pair.id}" ${selected}>${text}</option>`;
                    });
                    html += '</select>';
                    return html;
                };

                const html = 
                    `<div><label>Đội 1:</label>${createSelectHtml('pair1_id')}</div>` +
                    `<div><label>Đội 2:</label>${createSelectHtml('pair2_id')}</div>`;

                Swal.fire({
                    ...swalOptions,
                    title: 'Thêm trận đấu mới',
                    html: html,
                    showCancelButton: true,
                    preConfirm: () => {
                        const pair1Id = $('#pair1_id').val();
                        const pair2Id = $('#pair2_id').val();
                        if (pair1Id === pair2Id) {
                            Swal.showValidationMessage('Hai đội không được trùng nhau!');
                            return false;
                        }
                        return { pair1_id: pair1Id, pair2_id: pair2Id };
                    }
                }).then(result => {
                    if (result.isConfirmed && result.value) {
                        $.post(window.tournamentSettingApi.addMatch.replace(':id', roundId), {
                            ...result.value,
                            _token: window.Laravel.csrfToken
                        })
                        .done(reloadPage)
                        .fail(xhr => handleAjaxError(xhr, 'Không thể thêm trận đấu.'));
                    }
                });
            })
            .fail(xhr => handleAjaxError(xhr, 'Không thể tải danh sách cặp đấu.'));
    });
});