(function (global, factory) {
    if (typeof define === "function" && define.amd) {
        define("/config/tour", ["Config"], factory);
    } else if (typeof exports !== "undefined") {
        factory(require("Config"));
    } else {
        var mod = {
            exports: {}
        };
        factory(global.Config);
        global.configTour = mod.exports;
    }
})(this, function (_Config) {
    "use strict";

    (0, _Config.set)('tour', {
        steps: [{
            element: "#toggerUsermenu",
            position: 'left',
            intro: "Account settings <p class='content'>You can find the basic settings page for your account here!</p>"
        }, {
            element: "#home",
            position: "right",
            intro: "Personal homepage <p class='content'>Here you can see [Software Setting Tutorial], [Account Basic Information] and other information</p>"
        }, {
            element: "#services",
            position: "right",
            intro: "Purchase services <p class='content'>Here you can purchase the service package of this site, we support it<strong>WeChat, Alipay, QQ online payment</strong>, and you can also use the balance you recharged before to purchase.！</p>"
        }, {
            element: "#nodes",
            position: "right",
            intro: "My line <p class='content'>Here you can see the full range of the lines and information that your account can use.</p>"
        }, {
            element: "#help",
            position: "right",
            intro: "Help Center <p class='content'>If you have problems during use, this will be the first stop you need to come!Here we will continue to improve the problem database encountered by users and provide detailed answers.</p>"
        }, {
            element: "#tickets",
            position: "right",
            intro: "Manual Service <p class='content'>When you find that the Help Center cannot answer your questions, you can create a ticket window to seek help from customer service staff.Before using it, remember to follow the online time of customer service!</p>"
        }, {
            element: "#traffic",
            position: "right",
            intro: "Traffic Recording <p class='content'>Here you can view the traffic information you are using</p>"
        }, {
            element: "#invoices",
            position: "right",
            intro: "My bill <p class='content'>Here you can view historical purchase history</p>"
        }, {
            element: "#howtouse",
            position: "down",
            intro: "Interactive tutorial <p class='content'>Here you look at the client you need to download and how to set them up</p>"
        }, {
            element: "#accountInfo",
            position: "left",
            intro: "Account information <p class='content'>Here you can view the basic information of your account, such as account traffic usage, account validity period, etc.</p>"
        }],
        skipLabel: '<i class=\'wb-close\'></i>',
        doneLabel: '<i class=\'wb-close\'></i>',
        nextLabel: 'Next <i class=\'wb-chevron-right-mini\'></i>',
        prevLabel: '<i class=\'wb-chevron-left-mini\'></i>Previous',
        showBullets: true
    });
});