<?php

return [
    /*
    |--------------------------------------------------------------------------
    | Tournament Performance Configuration
    |--------------------------------------------------------------------------
    |
    | Configuration settings for optimizing tournament operations
    |
    */

    // Job Queue Thresholds
    'job_thresholds' => [
        'groups' => [
            'registration_count' => 50, // Use job queue if > 50 registrations
        ],
        'rounds' => [
            'total_pairs' => 100, // Use job queue if > 100 total pairs
        ],
        'playoffs' => [
            'estimated_teams' => 32, // Use job queue if > 32 teams in playoffs
        ],
    ],

    // Cache Configuration
    'cache' => [
        'standings_ttl' => 300, // 5 minutes
        'tournament_state_ttl' => 180, // 3 minutes
        'advancing_teams_ttl' => 300, // 5 minutes
        'job_status_ttl' => 3600, // 1 hour
    ],

    // Memory Management
    'memory' => [
        'limit' => '512M',
        'gc_threshold' => 50 * 1024 * 1024, // 50MB
        'chunk_size' => 200, // Batch processing chunk size
        'max_matches_warning' => 10000, // Warn if estimating > 10k matches
    ],

    // Database Optimization
    'database' => [
        'transaction_retries' => 3,
        'enable_query_log' => env('DB_QUERY_LOG', false),
        'slow_query_threshold' => 1000, // milliseconds
    ],

    // Performance Monitoring
    'monitoring' => [
        'enabled' => env('PERFORMANCE_MONITORING', true),
        'execution_time_threshold' => 5000, // milliseconds
        'query_count_threshold' => 50,
        'memory_threshold' => 256, // MB
    ],

    // Tournament Generation Limits
    'limits' => [
        'max_groups' => 26, // A-Z
        'max_pairs_per_group' => 20,
        'max_total_pairs' => 500,
        'max_matches_per_round' => 2000,
        'timeout_seconds' => 300, // 5 minutes
    ],

    // Features
    'features' => [
        'enable_caching' => true,
        'enable_job_queue' => true,
        'enable_performance_logging' => env('PERFORMANCE_LOGGING', false),
        'enable_memory_optimization' => true,
    ],
];