<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use App\Services\TournamentGenerationService;
use App\Services\TournamentStateService;
use App\Services\StandingsService;

class TournamentServiceProvider extends ServiceProvider
{
    public function register()
    {
        $this->app->singleton(TournamentGenerationService::class);
        $this->app->singleton(TournamentStateService::class);
        
        // Register singletons for services
        $this->app->singleton(StandingsService::class);
    }

    public function boot()
    {
        //
    }
}