<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use App\Services\ImageOptimizationService;
use App\View\Components\ResponsiveImage;
use Illuminate\Support\Facades\Blade;

class ImageOptimizationServiceProvider extends ServiceProvider
{
    /**
     * Register services.
     */
    public function register(): void
    {
        $this->app->singleton(ImageOptimizationService::class, function ($app) {
            return new ImageOptimizationService();
        });
    }

    /**
     * Bootstrap services.
     */
    public function boot(): void
    {
        // Register Blade component
        Blade::component('responsive-image', ResponsiveImage::class);
        
        // Register Blade directives
        Blade::directive('optimizedImage', function ($expression) {
            return "<?php echo app(App\\Services\\ImageOptimizationService::class)->getOptimalImagePath($expression); ?>";
});

// Register global view composer for image paths
view()->composer('*', function ($view) {
$view->with('imageOptimizer', app(ImageOptimizationService::class));
});

// Load image optimization CSS
if (config('app.env') === 'production') {
view()->share('loadImageOptimizationCSS', true);
}
}
}