<?php

namespace App\Providers;

use Illuminate\Foundation\Support\Providers\AuthServiceProvider as ServiceProvider;
use Illuminate\Support\Facades\Gate;
use App\Models\Matches;
use App\Models\Tournament;
use App\Models\User;
use App\Models\Venue;
use App\Models\Player;
use App\Models\Registration;
use App\Policies\MatchesPolicy;
use App\Policies\TournamentPolicy;
use App\Policies\UserPolicy;
use App\Policies\VenuePolicy;
use App\Policies\PlayerPolicy;
use App\Policies\RegistrationPolicy;

class AuthServiceProvider extends ServiceProvider
{
	/**
	 * The policy mappings for the application.
	 *
	 * @var array<class-string, class-string>
	 */
	protected $policies = [
		Matches::class => MatchesPolicy::class,
		Tournament::class => TournamentPolicy::class,
		User::class => UserPolicy::class,
		Venue::class => VenuePolicy::class,
		Player::class => PlayerPolicy::class,
		Registration::class => RegistrationPolicy::class,
	];

	/**
	 * Register any authentication / authorization services.
	 */
	public function boot()
	{
		$this->registerPolicies();
		// ...other gates if needed...
	}
}