<?php

namespace App\Providers;

use App\Http\Middleware\TournamentPasswordMiddleware;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\ServiceProvider;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        // Đăng ký Tournament Service Provider
        $this->app->register(TournamentServiceProvider::class);
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        if (class_exists(Route::class) && class_exists(TournamentPasswordMiddleware::class)) {
            Route::aliasMiddleware('tournament.password', TournamentPasswordMiddleware::class);
        }
    }
}
