<?php

namespace App\Policies;

use App\Models\User;
use App\Models\Venue;
use Illuminate\Auth\Access\Response;

class VenuePolicy
{
    public function viewAny(User $user): bool
    {
        return true; // Public
    }

    public function create(User $user): bool
    {
    return $user->hasRole('admin') || $user->hasRole('mod');
    }

    public function update(User $user, Venue $venue): bool
    {
    return $user->hasRole('admin') || $user->hasRole('mod');
    }

    public function delete(User $user, Venue $venue): bool
    {
    return $user->hasRole('admin');
    }
}