<?php

namespace App\Policies;

use App\Models\Registration;
use App\Models\User;
use Illuminate\Auth\Access\Response;

class RegistrationPolicy
{
    public function viewAny(User $user): bool
    {
        return true;
    }
    public function create(User $user): bool
    {
        // Ai cũng có thể đăng ký
        return true;
    }
    public function update(User $user, Registration $registration): bool
    {
        // Chỉ cho phép nếu user đã nhập đúng mật khẩu tournament (session)
        $sessionKey = 'tournament_setting_' . $registration->tournament_id;
        return session($sessionKey, false) === true || $user->hasRole('admin') || $user->hasRole('mod');
    }
    public function delete(User $user, Registration $registration): bool
    {
    return $user->hasRole('admin');
    }
}