<?php

namespace App\Policies;

use App\Models\MatchModel;
use App\Models\User;
use Illuminate\Auth\Access\Response;

class MatchesPolicy
{
    public function viewAny(User $user): bool
    {
        return true; // Public
    }

    public function create(User $user): bool
    {
        return $user->hasRole('admin') || $user->hasRole('mod');
    }

    public function update(User $user, MatchModel $match): bool
    {
        return $user->hasRole('admin') || $user->hasRole('mod');
    }

    public function delete(User $user, MatchModel $match): bool
    {
        return $user->hasRole('admin');
    }

    public function updateScore(User $user, MatchModel $match): bool
    {
        // Admin và mod có thể cập nhật điểm số
        // Organizer với password đúng cũng có thể (check trong middleware)
        return $user->hasRole('admin') || $user->hasRole('mod');
    }
}