<?php

namespace App\Notifications;

use App\Services\TelegramService;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Notification;

class NewMemberRegistration extends Notification implements ShouldQueue
{
    use Queueable;

    protected $memberData;

    /**
     * Create a new notification instance.
     */
    public function __construct($memberData)
    {
        $this->memberData = $memberData;
    }

    /**
     * Get the notification's delivery channels.
     */
    public function via($notifiable)
    {
        return ['telegram'];
    }

    /**
     * Get the telegram representation of the notification.
     */
    public function toTelegram($notifiable)
    {
        $telegramService = app(TelegramService::class);

        return $telegramService->sendNewMemberNotification($this->memberData);
    }

    /**
     * Get the array representation of the notification.
     */
    public function toArray($notifiable)
    {
        return [
            'type' => 'new_member_registration',
            'member_data' => $this->memberData,
            'timestamp' => now(),
        ];
    }
}
