<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Venue extends Model
{
    use HasFactory;

    /**
     * Venue belongs to a user (người tạo hoặc quản lý venue)
     */
    public function user()
    {
        return $this->belongsTo(User::class);
    }
    use HasFactory;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'user_id',
        'name',
        'slug',
        'location',
        'address',
        'description',
        'contact_phone',
        'contact_email',
        'images',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'images' => 'array',
    ];

    /**
     * Get the route key for the model.
     *
     * @return string
     */
    public function getRouteKeyName()
    {
        return 'slug';
    }

    /**
     * Accessor to get the main image URL.
     * Returns the first image or a default one.
     */
    public function getMainImageAttribute(): string
    {
        if ($this->images && ! empty($this->images[0])) {
            // Ensure the path is correctly handled by asset()
            return asset($this->images[0]);
        }

        return asset('assets/images/default.png');
    }

    /**
     * Get all reviews for the venue.
     */
    public function reviews()
    {
        return $this->hasMany(Review::class)->latest();
    }

    /**
     * Get all tournaments for the venue.
     */
    public function tournaments()
    {
        return $this->hasMany(Tournament::class);
    }
}