<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Spatie\Activitylog\LogOptions;
use Spatie\Activitylog\Traits\LogsActivity;

class TournamentRound extends Model
{
    use HasFactory;
    use LogsActivity;

    protected $fillable = ['tournament_id', 'name', 'type', 'playoff_level', 'meta_data', 'parent_round_id'];

    protected $casts = [
        'meta_data' => 'array',
    ];

    public function getActivitylogOptions(): LogOptions
    {
        return LogOptions::defaults()
            ->logOnly(['name', 'type'])
            ->setDescriptionForEvent(fn (string $eventName) => "Vòng đấu '{$this->name}' đã được ".trans("activitylog.{$eventName}"));
    }

    public function tournament()
    {
        return $this->belongsTo(Tournament::class);
    }

    public function matches()
    {
        return $this->hasMany(MatchModel::class, 'tournament_round_id');
    }
}
