<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Spatie\Activitylog\LogOptions;
use Spatie\Activitylog\Traits\LogsActivity;

class TournamentGroup extends Model
{
    use HasFactory;
    use LogsActivity;

    protected $fillable = ['tournament_id', 'name'];

    public function getActivitylogOptions(): LogOptions
    {
        return LogOptions::defaults()
            ->logOnly(['name'])
            ->setDescriptionForEvent(fn (string $eventName) => "Bảng đấu '{$this->name}' đã được ".trans("activitylog.{$eventName}"));
    }

    public function tournament()
    {
        return $this->belongsTo(Tournament::class);
    }

    public function pairs()
    {
        return $this->hasMany(GroupPair::class, 'group_id');
    }

    public function matches()
    {
        // Lấy tất cả các trận đấu mà cặp này là pair1
        return $this->hasManyThrough(
            \App\Models\MatchModel::class,
            \App\Models\GroupPair::class,
            'group_id', // Foreign key on GroupPair
            'pair1_id',  // Foreign key on MatchModel
            'id',        // Local key on TournamentGroup
            'id'         // Local key on GroupPair
        );
    }

    /**
     * Lấy tất cả các trận đấu mà cặp thuộc bảng này là pair1 hoặc pair2
     */
    public function getAllMatches()
    {
        $pairIds = $this->pairs->pluck('id');
        return \App\Models\MatchModel::whereIn('pair1_id', $pairIds)
            ->orWhereIn('pair2_id', $pairIds)
            ->get();
    }
}
