<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

use App\Models\Tournament;
use App\Models\Player;

class Registration extends Model
{
    use HasFactory;

    protected $fillable = ['tournament_id', 'player1_id', 'player2_id', 'score_sum', 'status', 'reason']; // player2_id có thể nullable nếu singles

    public function tournament()
    {
        return $this->belongsTo(Tournament::class);
    }

    public function player1()
    {
        return $this->belongsTo(Player::class, 'player1_id');
    }

    public function player2()
    {
        return $this->belongsTo(Player::class, 'player2_id');
    }
}