<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class MatchModel extends Model
{
    use HasFactory;

    protected $fillable = [
        'match_id', 'tournament_id', 'tournament_round_id', 'date', 'type', 'result', 'score_change', 'score',
        'doubles_score', 'singles_score',
        'pair1_id', 'pair2_id', 'round_number', 'status', 'images',
    ];

    protected $table = 'matches';

    protected $casts = [
        'images' => 'array',
        'date' => 'datetime',
        'doubles_score' => 'float',
        'singles_score' => 'float',
    ];

    public function tournament()
    {
        return $this->belongsTo(Tournament::class);
    }

    public function pair1()
    {
        return $this->belongsTo(GroupPair::class, 'pair1_id');
    }

    public function pair2()
    {
        return $this->belongsTo(GroupPair::class, 'pair2_id');
    }

    public function round()
    {
        return $this->belongsTo(TournamentRound::class, 'tournament_round_id');
    }

    protected static function booted()
    {
        // Logic tính điểm Elo đã được chuyển sang một service hoặc xử lý ở nơi khác
        // để tránh logic phức tạp trong model event.
        // Nếu bạn vẫn muốn giữ logic này, hãy đảm bảo nó tương thích với cấu trúc mới (pair1, pair2).
    }
}
