<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class GroupPair extends Model
{
    use HasFactory;

    protected $fillable = ['group_id', 'player1_id', 'player2_id'];

    public function matchesAsPair1()
    {
        return $this->hasMany(\App\Models\MatchModel::class, 'pair1_id');
    }

    public function matchesAsPair2()
    {
        return $this->hasMany(\App\Models\MatchModel::class, 'pair2_id');
    }

    public function getAllMatches()
    {
        return \App\Models\MatchModel::where('pair1_id', $this->id)
            ->orWhere('pair2_id', $this->id);
    }

    public function group()
    {
        return $this->belongsTo(TournamentGroup::class, 'group_id');
    }

    public function player1()
    {
        return $this->belongsTo(Player::class, 'player1_id');
    }

    public function player2()
    {
        return $this->belongsTo(Player::class, 'player2_id');
    }

    public function scopeSearch($query, $searchTerm, $groupAlias = 'tournament_groups')
    {
        if ($searchTerm) {
            return $query->where(function ($q) use ($searchTerm, $groupAlias) {
                $q->where('p1.name', 'like', '%'.$searchTerm.'%')
                    ->orWhere('p2.name', 'like', '%'.$searchTerm.'%')
                    ->orWhere($groupAlias.'.name', 'like', '%'.$searchTerm.'%');
            });
        }

        return $query;
    }
}
