<?php

namespace App\Jobs;

use App\Services\TelegramService;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\Log;

class SendTelegramNotificationJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    public string $message;

    public function __construct(string $message)
    {
        $this->message = $message;
        // Keep the job lightweight; no heavy serialization
        $this->onQueue('notifications');
    }

    public function handle(TelegramService $telegram): void
    {
        try {
            if ($telegram->isConfigured()) {
                $telegram->sendMessage($this->message);
            } else {
                Log::warning('Telegram not configured. Skipping queued notification.');
            }
        } catch (\Throwable $e) {
            Log::error('Failed to send Telegram notification (queued): '.$e->getMessage());
            // Let the job fail silently; depending on needs we could retry
        }
    }
}
