<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use App\Rules\ImageValidationRules;
use App\Rules\ValidImageContent;

class VenueRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        // Authorization logic is handled by policies in the controller,
        // so we can return true here.
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, mixed>
     */
    public function rules()
    {
        $venueId = $this->route('venue') ? $this->route('venue')->id : null;

        return [
            'name' => 'required|string|max:255',
            'slug' => 'sometimes|string|max:255|unique:venues,slug,'.$venueId,
            'address' => 'required|string|max:500',
            'location' => 'required|string|max:100',
            'description' => 'nullable|string',
            'contact_phone' => 'nullable|string|max:20',
            'contact_email' => 'nullable|email|max:255',
            'images' => ImageValidationRules::venueImages(),
            // Validate each file in the 'images' array
            'images.*' => array_merge(ImageValidationRules::venueImage(), [new ValidImageContent()]), // Max 5MB per image
        ];
    }

    /**
     * Get the custom validation messages for the defined rules.
     *
     * @return array<string, string>
     */
    public function messages()
    {
        return array_merge([
            'name.required' => 'Tên sân là bắt buộc.',
            'name.max' => 'Tên sân không được vượt quá 255 ký tự.',
            'address.required' => 'Địa chỉ là bắt buộc.',
            'address.max' => 'Địa chỉ không được vượt quá 500 ký tự.',
            'location.required' => 'Khu vực là bắt buộc.',
            'location.max' => 'Khu vực không được vượt quá 100 ký tự.',
            'contact_phone.max' => 'Số điện thoại không được vượt quá 20 ký tự.',
            'contact_email.email' => 'Định dạng email không hợp lệ.',
            'contact_email.max' => 'Email không được vượt quá 255 ký tự.',
            'images.array' => 'Hình ảnh phải là một mảng.',
            'images.max' => 'Không được chọn quá 10 hình ảnh.',
        ], ImageValidationRules::customMessages('images.*', 5120));
    }
}