<?php
namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class TournamentSettingRequest extends FormRequest
{
    public function authorize()
    {
        return true;
    }

    public function rules()
    {
        return [
            'name' => 'required|string|max:255',
            'type' => 'nullable|in:normal,round_tree',
            'player1_id' => 'nullable|exists:players,id',
            'player2_id' => 'nullable|exists:players,id|different:player1_id',
            'password' => 'nullable|digits:6',
        ];
    }
}
