<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use App\Rules\ImageValidationRules;
use App\Rules\ValidImageContent;

class TournamentRequest extends FormRequest
{
    public function authorize(): bool
    {
        return auth()->user()->hasRole('admin') || auth()->user()->hasRole('mod');
    }

    public function rules(): array
    {
        // Chỉ áp dụng các quy tắc nghiêm ngặt cho việc tạo và cập nhật giải đấu
        if (! $this->routeIs('admin.tournaments.store') && ! $this->routeIs('admin.tournaments.update')) {
            return [];
        }

        return [
            'name' => 'required|string|max:255',
            'start_date' => 'required|date|after_or_equal:today',
            'end_date' => 'required|date|after_or_equal:start_date',
            'description' => 'required|string',
            'location' => 'required|string|max:100',
            'max_pairs' => 'required|integer|min:2|max:72',
            'fee' => 'required|integer|min:0',
            'prizes' => 'required|string|max:255',
            'rules' => 'required|string',
            'skill_point' => 'required|numeric|min:0',
            'skill_tolerance' => 'required|numeric|min:0',
            'image' => array_merge(ImageValidationRules::tournamentImage(), [new ValidImageContent()]),
        ];
    }

    /**
     * Get custom error messages
     */
    public function messages(): array
    {
        return ImageValidationRules::customMessages('image', 2048);
    }
}
