<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;
use App\Rules\ImageValidationRules;
use App\Rules\ValidImageContent;

class RegisterMemberRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true; // Allow all, or check if not logged in
    }

    public function rules(): array
    {
        return [
            'name' => ['required', 'string', 'max:255'],
            'email' => ['required', 'email', 'unique:users,email'],
            'phone' => ['nullable', 'string', 'max:20'],
            'location' => ['required', 'string', 'max:100'],
            'gender' => ['required', Rule::in(['Nam', 'Nữ'])],
            'initial_level' => ['required', 'numeric', 'between:2.0,6.5'],
            'avatar' => array_merge(ImageValidationRules::avatar(), [new ValidImageContent()]),           
        ];
    }

    public function messages(): array
    {
        return array_merge([
            'name.required' => 'Tên là bắt buộc.',
            'email.required' => 'Email là bắt buộc.',
            'email.unique' => 'Email đã được sử dụng.',
            'location.required' => 'Khu vực là bắt buộc.',
            'gender.required' => 'Giới tính là bắt buộc.',
            'initial_level.required' => 'Trình độ ban đầu là bắt buộc.',
            'initial_level.between' => 'Trình độ ban đầu phải từ 2.0 đến 6.0.',
        ], ImageValidationRules::customMessages('avatar', 4096));
    }
    // public function rules(): array
    // {
    //     return [
    //         'name' => ['required', 'string', 'max:255'],
    //         'email' => ['required', 'email', 'unique:users,email'],
    //         'password' => ['required', 'string', 'min:8', 'confirmed'],
    //         'phone' => ['nullable', 'string', 'max:20'],
    //         'location' => ['required', 'string', 'max:100'],
    //         'gender' => ['required', Rule::in(['Nam', 'Nữ'])],
    //         'initial_level' => ['required', 'numeric', 'between:2.0,6.0'],
    //         'tennis_points' => ['nullable', 'numeric', 'between:620,750'],
    //         'avatar' => ['nullable', 'image', 'mimes:jpeg,png,jpg', 'max:2048'],
            
    //     ];
    // }

    // public function messages(): array
    // {
    //     return [
    //         'initial_level.between' => 'Trình độ ban đầu phải từ 2.0 đến 6.0.',
    //         'tennis_points.between' => 'Điểm tennis phải từ 620 đến 750 để quy đổi.',
    //         'avatar.image' => 'Avatar phải là hình ảnh (jpeg, png, jpg).',
    //         'avatar.max' => 'Avatar không được vượt quá 2MB.',
    //     ];
    // }
}