<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use App\Rules\ImageValidationRules;
use App\Rules\ValidImageContent;

class PlayerRequest extends FormRequest
{
    public function authorize(): bool
    {
        return auth()->user()->hasRole('admin') || auth()->user()->hasRole('mod');
    }

    public function rules(): array
    {
        $id = $this->route('player')?->id;
        $rules = [
            'name' => 'required|string|max:255',
            'email' => 'required|email|max:255',
            'initial_level' => 'required|numeric|min:2|max:6',
            'location' => 'required|string',
            'phone' => 'required|string',
            'gender' => 'required|string',
            'avatar' => array_merge(ImageValidationRules::avatar(), [new ValidImageContent()]),
            'status' => 'required|in:0,1,2',
        ];
        if ($id) {
            $rules['player_id'] = 'required|string|unique:players,player_id,' . $id;
            $rules['doubles_score'] = 'nullable|numeric';
            $rules['doubles_matches'] = 'nullable|integer';
            $rules['doubles_wins'] = 'nullable|integer';
            $rules['doubles_losses'] = 'nullable|integer';
            $rules['max_score'] = 'nullable|numeric';
            $rules['lock_score'] = 'nullable|numeric';
            $rules['singles_score'] = 'nullable|numeric';
            $rules['singles_matches'] = 'nullable|integer';
            $rules['singles_win'] = 'nullable|integer';
            $rules['singles_lose'] = 'nullable|integer';
        }
        return $rules;
    }

    /**
     * Get custom error messages
     */
    public function messages(): array
    {
        return array_merge(
            parent::messages(),
            ImageValidationRules::customMessages('avatar', 4096)
        );
    }
}