<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;

class TournamentPasswordMiddleware
{
    public function handle(Request $request, Closure $next)
    {
        $tournamentId = $request->route('tournament');
        // If the route uses model binding, the route param may already be a model instance.
        if ($tournamentId instanceof \App\Models\Tournament) {
            $tournamentId = $tournamentId->id;
        }

        // Nếu không có tournamentId, thử lấy từ group (có thể là id hoặc model)
        if (! $tournamentId && $request->route('group')) {
            $groupParam = $request->route('group');
            if ($groupParam instanceof \App\Models\TournamentGroup) {
                $tournamentId = $groupParam->tournament_id;
            } else {
                $group = \App\Models\TournamentGroup::find($groupParam);
                $tournamentId = $group ? $group->tournament_id : null;
            }
        }
        // Nếu vẫn chưa có, thử lấy từ input
        if (! $tournamentId) {
            $tournamentId = $request->input('tournamentId');
        }
        if (! $tournamentId) {
            return $next($request);
        }

        $sessionKeyOrg = 'tournament_pw_'.$tournamentId;
        $sessionKeyRole = 'tournament_role_'.$tournamentId;
        $role = Session::get($sessionKeyRole);
        $isOrganizer = Session::get($sessionKeyOrg);
        $isReferee = $role === 'referee';

        if (! $isOrganizer && ! $isReferee) {
            // If the request expects JSON (AJAX/API), keep returning JSON 403 so callers can handle it.
            if ($request->expectsJson() || $request->isJson() || $request->wantsJson()) {
                return response()->json(['error' => 'Password required'], 403);
            }

            // For normal browser requests, redirect to the password entry page so the organizer/referee can enter the password.
            // Preserve the intended URL so we can return after successful auth.
            $intended = $request->fullUrl();
            session()->put('url.intended', $intended);

            return redirect()->route('tournament.setting.index', ['tournament' => $tournamentId]);
        }

        return $next($request);
    }
}
