<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;

class OptimizeMemoryUsage
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure(\Illuminate\Http\Request): (\Illuminate\Http\Response|\Illuminate\Http\RedirectResponse)  $next
     * @return \Illuminate\Http\Response|\Illuminate\Http\RedirectResponse
     */
    public function handle(Request $request, Closure $next)
    {
        // Set initial memory limit
        $initialMemory = memory_get_usage();
        
        // Increase memory limit for heavy operations
        ini_set('memory_limit', '512M');
        
        $response = $next($request);
        
        // Force garbage collection for large requests
        $finalMemory = memory_get_usage();
        $memoryUsed = $finalMemory - $initialMemory;
        
        if ($memoryUsed > 50 * 1024 * 1024) { // > 50MB
            Log::info("High memory usage detected: " . number_format($memoryUsed / 1024 / 1024, 2) . "MB for " . $request->getUri());
            gc_collect_cycles();
        }
        
        return $response;
    }
}