<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;

class DatabaseQueryOptimizer
{
    /**
     * Handle an incoming request.
     */
    public function handle(Request $request, Closure $next)
    {
        $startTime = microtime(true);
        $startQueries = $this->getQueryCount();
        
        $response = $next($request);
        
        $endTime = microtime(true);
        $endQueries = $this->getQueryCount();
        
        $executionTime = ($endTime - $startTime) * 1000; // milliseconds
        $queryCount = $endQueries - $startQueries;
        
        // Log performance warnings for heavy operations
        if ($executionTime > 5000 || $queryCount > 50) {
            Log::warning('Performance Alert', [
                'url' => $request->getUri(),
                'method' => $request->getMethod(),
                'execution_time_ms' => round($executionTime, 2),
                'query_count' => $queryCount,
                'memory_usage_mb' => round(memory_get_peak_usage(true) / 1024 / 1024, 2)
            ]);
        }
        
        return $response;
    }
    
    /**
     * Get current query count
     */
    private function getQueryCount(): int
    {
        return count(DB::getQueryLog());
    }
}