<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class CheckRole
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @param  string  $roles
     * @return mixed
     */
    public function handle(Request $request, Closure $next, $roles)
    {
        $user = Auth::user();
        $roleArr = explode('|', $roles);
        if (!$user) {
            abort(403, 'Bạn chưa đăng nhập.');
        }
        $hasAnyRole = false;
        foreach ($roleArr as $role) {
            if ($user->hasRole($role)) {
                $hasAnyRole = true;
                break;
            }
        }
        if (!$hasAnyRole) {
            abort(403, 'Bạn không có quyền truy cập chức năng này.');
        }
        return $next($request);
    }
}