@extends('layouts.app')

@section('title', 'Danh sách sân Pickleball')

@section('content')
<div class="container mx-auto px-4 sm:px-6 lg:px-8 py-8">
    <h1 class="text-3xl font-bold text-gray-800 mb-6">Khám phá các sân Pickleball</h1>

    <!-- Filter and Search Form -->
    <div class="bg-white p-4 rounded-lg shadow-sm mb-6">
        <form action="{{ route('venues.index') }}" method="GET" class="grid grid-cols-1 md:grid-cols-3 gap-4">
            <div>
                <label for="search" class="block text-sm font-medium text-gray-700">Tìm kiếm theo tên, địa chỉ</label>
                <input type="text" name="search" id="search" value="{{ request('search') }}"
                    class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 sm:text-sm"
                    placeholder="VD: Pickleball Zone">
            </div>
            <div>
                <label for="location" class="block text-sm font-medium text-gray-700">Lọc theo khu vực</label>
                <select name="location" id="location"
                    class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 sm:text-sm">
                    <option value="">Tất cả khu vực</option>
                    @foreach($locations as $location)
                    <option value="{{ $location }}" {{ request('location')==$location ? 'selected' : '' }}>
                        {{ $location }}
                    </option>
                    @endforeach
                </select>
            </div>
            <div class="flex items-end">
                <button type="submit"
                    class="w-full md:w-auto inline-flex justify-center items-center px-4 py-2 border border-transparent text-sm font-medium rounded-md shadow-sm text-white bg-blue-600 hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500">
                    <i class="bi bi-search mr-2"></i> Tìm kiếm
                </button>
            </div>
        </form>
    </div>

    <!-- Venues Grid -->
    @if($venues->isEmpty())
    <div class="text-center py-12">
        <p class="text-gray-500 text-lg">Không tìm thấy sân nào phù hợp.</p>
    </div>
    @else
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
        @foreach($venues as $venue)
        <div
            class="bg-white rounded-lg shadow-lg overflow-hidden transform hover:-translate-y-1 transition-transform duration-300">
            <a href="{{ route('venues.show', $venue->slug) }}">
                <img class="h-56 w-full object-cover"
                    src="{{ $venue->images[0] ?? 'https://via.placeholder.com/400x300.png?text=PickleballVNA' }}"
                    alt="Hình ảnh của {{ $venue->name }}">
            </a>
            <div class="p-6">
                <h3 class="text-xl font-semibold text-gray-800 mb-2">
                    <a href="{{ route('venues.show', $venue->slug) }}" class="hover:text-blue-600">{{ $venue->name
                        }}</a>
                </h3>
                <p class="text-gray-600 text-sm mb-4"><i class="bi bi-geo-alt-fill mr-1"></i> {{ $venue->address }}</p>
                <span
                    class="inline-block bg-blue-100 text-blue-800 text-xs font-semibold mr-2 px-2.5 py-0.5 rounded-full">{{
                    $venue->location }}</span>
            </div>
        </div>
        @endforeach
    </div>

    <!-- Pagination -->
    <div class="mt-8">
        {{ $venues->appends(request()->query())->links() }}
    </div>
    @endif
</div>
@endsection