<?php

namespace App\Http\Controllers;

use App\Http\Requests\StoreRegistrationRequest;
use App\Models\Registration;
use App\Models\Tournament;
use App\Services\RegistrationService;

class RegistrationController extends Controller
{
    public function store(StoreRegistrationRequest $request, Tournament $tournament)
    {
        try {
            $registrationService = app(RegistrationService::class);
            $registration = $registrationService->createRegistration($tournament, $request->validated());

            return redirect()
                ->route('tournaments.show', $tournament->slug)
                ->with('success', 'Đăng ký thành công! Đơn của bạn sẽ được BTC duyệt.');

        } catch (\Illuminate\Validation\ValidationException $e) {
            return back()->withErrors($e->errors())->withInput();
        } catch (\Exception $e) {
            return back()->withErrors(['error' => $e->getMessage()])->withInput();
        }
    }

    public function updateStatus(\Illuminate\Http\Request $request, $id)
    {
        $registration = Registration::findOrFail($id);
        // Middleware `TournamentPasswordMiddleware` đã kiểm tra quyền truy cập
        // $this->authorize('update', $registration);
        $validated = $request->validate([
            'status' => 'required|in:pending,approved,rejected',
            'reason' => 'nullable|string',
        ]);
        try {
            $registrationService = app(RegistrationService::class);
            $registrationService->updateStatus($registration, $validated['status'], $validated['reason']);

            return response()->json(['success' => true, 'message' => 'Cập nhật trạng thái thành công!']);
        } catch (\Exception $e) {
            return response()->json(['success' => false, 'message' => $e->getMessage()], 422); // 422 Unprocessable Entity
        }
    }
}
