<?php

namespace App\Http\Controllers;

use App\Models\Player;
use App\Models\Tournament;
use Illuminate\Http\Request;

class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    // public function __construct()
    // {
    //     $this->middleware('auth');
    // }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function index(Request $request)
    {
        $search = $request->input('search');
        $playersQuery = Player::query();
        if ($search) {
            $playersQuery->where(function ($q) use ($search) {
                $q->where('name', 'like', '%'.$search.'%')
                  ->orWhere('player_id', 'like', '%'.$search.'%')
                  ->orWhere('phone', 'like', '%'.$search.'%');
            });
        }
        // Filter by phone (exact or partial)
        if ($request->filled('phone')) {
            $playersQuery->where('phone', 'like', '%'.$request->phone.'%');
        }
        // Filter by gender
        if ($request->filled('gender')) {
            $playersQuery->where('gender', $request->gender);
        }
        // Filter by player location
        if ($request->filled('player_location')) {
            $playersQuery->where('location', $request->player_location);
        }
        
        // Order by newest registered players first
        $players = $playersQuery->orderByDesc('created_at')->paginate(12)->appends($request->query());

        // Tournament search & filter
        $tournamentQuery = Tournament::where('start_date', '>=', now());
        if ($request->filled('search')) {
            $tournamentQuery->where('name', 'like', '%'.$request->search.'%');
        }
        if ($request->filled('location')) {
            $tournamentQuery->where('location', $request->location);
        }
        if ($request->filled('type')) {
            $tournamentQuery->where('type', $request->type);
        }
        $tournaments = $tournamentQuery->orderBy('start_date')->get();
        $locations = Tournament::select('location')->distinct()->pluck('location')->filter()->values();
        $playerLocations = Player::select('location')->distinct()->pluck('location')->filter()->values();

        return view('home', compact('players', 'tournaments', 'locations', 'playerLocations'));
    }
}
