<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Cache;

class JobStatusController extends Controller
{
    /**
     * Get job status for tournament operations
     */
    public function getTournamentJobStatus(Request $request, $tournamentId)
    {
        $jobType = $request->get('type', 'groups'); // groups, rounds, playoffs
        $key = "tournament_job_{$tournamentId}_{$jobType}";
        
        $status = Cache::get($key, [
            'status' => 'not_started',
            'message' => 'Chưa có job nào được khởi tạo',
            'progress' => 0,
            'updated_at' => null,
        ]);

        return response()->json([
            'success' => true,
            'data' => $status
        ]);
    }

    /**
     * Clear job status cache
     */
    public function clearTournamentJobStatus(Request $request, $tournamentId)
    {
        $jobType = $request->get('type', 'groups');
        $key = "tournament_job_{$tournamentId}_{$jobType}";
        
        Cache::forget($key);

        return response()->json([
            'success' => true,
            'message' => 'Đã xóa trạng thái job'
        ]);
    }
}