<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Tournament;
use App\Models\TournamentRound;
use Illuminate\Http\Request;

class TournamentRoundController extends Controller
{
    public function index(Tournament $tournament)
    {
        $rounds = $tournament->rounds()->get();

        return view('admin.rounds.index', compact('tournament', 'rounds'));
    }

    public function create(Tournament $tournament)
    {
        return view('admin.rounds.create', compact('tournament'));
    }

    public function store(Request $request, Tournament $tournament)
    {
        $data = $request->validate([
            'name' => 'required|string|max:50',
            'type' => 'required|in:normal,round_robin,playoff',
        ]);
        $data['tournament_id'] = $tournament->id;
        TournamentRound::create($data);

        return redirect()->route('admin.rounds.index', $tournament)->with('success', 'Tạo vòng đấu thành công!');
    }

    public function edit(Tournament $tournament, TournamentRound $round)
    {
        return view('admin.rounds.edit', compact('tournament', 'round'));
    }

    public function update(Request $request, Tournament $tournament, TournamentRound $round)
    {
        $data = $request->validate([
            'name' => 'required|string|max:50',
            'type' => 'required|in:normal,round_robin,playoff',
        ]);
        $round->update($data);

        return redirect()->route('admin.rounds.index', $tournament)->with('success', 'Cập nhật vòng đấu thành công!');
    }

    public function destroy(Tournament $tournament, TournamentRound $round)
    {
        $round->delete();

        return redirect()->route('admin.rounds.index', $tournament)->with('success', 'Đã xóa vòng đấu!');
    }
}
