<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\GroupPair;
use App\Models\Tournament;
use Illuminate\Http\Request;

class TournamentPairController extends Controller
{
    /**
     * Display a listing of all pairs in a tournament.
     *
     * @return \Illuminate\View\View
     */
    public function index(Request $request, Tournament $tournament)
    {
        $this->authorize('update', $tournament);

        $search = $request->input('search');

        // Tối ưu hóa: Sử dụng JOIN thay vì whereHas và chỉ chọn các cột cần thiết.
        $pairsQuery = GroupPair::query()
            ->select(
                'group_pairs.id',
                'group_pairs.group_id',
                'group_pairs.player1_id',
                'group_pairs.player2_id',
                'g.name as group_name',
                'p1.name as player1_name', // Giữ lại để tương thích với view hiện tại
                'p2.name as player2_name'  // Giữ lại để tương thích với view hiện tại
            )
            ->join('tournament_groups as g', 'group_pairs.group_id', '=', 'g.id')
            ->join('players as p1', 'group_pairs.player1_id', '=', 'p1.id')
            ->join('players as p2', 'group_pairs.player2_id', '=', 'p2.id')
            ->where('g.tournament_id', $tournament->id);

        // Sử dụng scope `search` đã được refactor từ model GroupPair
        $pairsQuery->search($search, 'g');

        $pairs = $pairsQuery->orderBy('group_pairs.group_id')->paginate(20);

        return view('admin.pairs.index', compact('tournament', 'pairs', 'search'));
    }
}