<?php
namespace App\Http\Controllers\Admin;
use App\Http\Controllers\Controller;
use App\Models\TournamentGroup;
use App\Models\Tournament;
use Illuminate\Http\Request;
class TournamentGroupController extends Controller
{
    public function index(Tournament $tournament)
    {
        $groups = $tournament->groups()->get();
        return view('admin.groups.index', compact('tournament', 'groups'));
    }
    public function create(Tournament $tournament)
    {
        return view('admin.groups.create', compact('tournament'));
    }
    public function store(Request $request, Tournament $tournament)
    {
        $data = $request->validate([
            'name' => 'required|string|max:50|unique:tournament_groups,name,NULL,id,tournament_id,' . $tournament->id,
        ], [
            'name.unique' => 'Tên bảng này đã tồn tại trong giải đấu.'
        ]);
        $data['tournament_id'] = $tournament->id;
        TournamentGroup::create($data);
        return back()->with('success', 'Đã thêm bảng đấu thủ công thành công!')->with('open_tab', 'groups-pairs');
    }
    // public function edit(Tournament $tournament, TournamentGroup $group)
    // {
    //     return view('admin.groups.edit', compact('tournament', 'group'));
    // }
    // public function update(Request $request, Tournament $tournament, TournamentGroup $group)
    // {
    //     $data = $request->validate(['name' => 'required|string|max:50']);
    //     $group->update($data);
    //     return redirect()->route('admin.groups.index', $tournament)->with('success', 'Cập nhật bảng đấu thành công!');
    // }
    public function destroy(Tournament $tournament, TournamentGroup $group)
    {
        $group->delete();
        return back()->with('success', 'Đã xóa bảng đấu!')->with('open_tab', 'groups-pairs');
    }
}