<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Player;
use App\Models\Registration;
use App\Models\Tournament;
use App\Models\User;
use App\Models\Venue;

class DashboardController extends Controller
{
    /**
     * Display the admin dashboard.
     *
     * @return \Illuminate\View\View
     */
    public function index()
    {
        $user = auth()->user();
        
        // Build tournament query based on user role
        $tournamentsQuery = Tournament::query();
        if ($user->hasRole('mod')) {
            // Mod only sees their own tournaments
            $tournamentsQuery->where('created_by', $user->id);
        }
        // Admin sees all tournaments (no additional filter)

        // Players: mods should see all players like admin, so no per-mod filter here
        $playersQuery = Player::query();

        $stats = [
            'tournaments' => $tournamentsQuery->count(),
            'venues' => Venue::count(),
            'players' => $playersQuery->count(),
            'users' => User::count(),
        ];

        // Build upcoming tournaments query based on user role
        $upcomingQuery = Tournament::where('start_date', '>=', now())
            ->with('registrations');
        
        if ($user->hasRole('mod')) {
            $upcomingQuery->where('created_by', $user->id);
        }

        $upcoming_tournaments = $upcomingQuery
            ->orderBy('start_date', 'asc')
            ->take(5)
            ->get();

        // Recent players: show latest global players to mods as well
        $recent_players = Player::latest()->take(6)->get();
        
        return view('admin.dashboard', compact('stats', 'upcoming_tournaments', 'recent_players'));
    }
}