<?php

namespace App\Exports;

use App\Models\Tournament;
use App\Services\StandingsService;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMultipleSheets;
use Maatwebsite\Excel\Concerns\WithTitle;

// Tạm thời sử dụng để gọi getStandings

class StandingsExport implements WithMultipleSheets
{
    protected $tournament;

    protected $standingsByGroup;

    public function __construct(Tournament $tournament)
    {
        $this->tournament = $tournament;
        $standingsService = app(StandingsService::class);
        // Eager load các quan hệ cần thiết một lần
        $tournament->load('groups.pairs.player1', 'groups.pairs.player2', 'rounds.matches');
        $this->standingsByGroup = \Illuminate\Support\Facades\DB::transaction(function () use ($standingsService, $tournament) {
            $standingsData = [];
            foreach ($tournament->groups as $group) {
                $standingsData[$group->name] = $standingsService->calculateForGroup($group, $tournament->rounds);
            }

            return $standingsData;
        });
    }

    public function sheets(): array
    {
        $sheets = [];

        foreach ($this->standingsByGroup as $groupName => $standings) {
            $sheets[] = new GroupStandingsSheet($groupName, $standings);
        }

        return $sheets;
    }
}

class GroupStandingsSheet implements FromCollection, WithHeadings, WithTitle
{
    private $groupName;

    private $standings;

    public function __construct(string $groupName, array $standings)
    {
        $this->groupName = 'Bảng '.$groupName;
        $this->standings = $standings;
    }

    /**
     * @return \Illuminate\Support\Collection
     */
    public function collection()
    {
        $collection = collect();
        foreach ($this->standings as $index => $standing) {
            $collection->push([
                'rank' => $index + 1,
                'pair' => ($standing['pair']->player1->name ?? 'N/A').' & '.($standing['pair']->player2->name ?? 'N/A'),
                'played' => $standing['played'],
                'wins' => $standing['wins'],
                'losses' => $standing['losses'],
                'points_diff' => $standing['points_for'] - $standing['points_against'],
            ]);
        }

        return $collection;
    }

    public function title(): string
    {
        return $this->groupName;
    }

    public function headings(): array
    {
        return [
            '#',
            'Cặp đấu',
            'Số trận',
            'Thắng',
            'Bại',
            'Hiệu số',
        ];
    }
}