<?php

namespace App\Exports;

use App\Models\Tournament;
use Illuminate\Support\Collection;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMultipleSheets;
use Maatwebsite\Excel\Concerns\WithTitle;

class PairsExport implements WithMultipleSheets
{
    public function __construct(private Tournament $tournament)
    {
        // Eager-load minimal relations
        $this->tournament->loadMissing('groups.pairs.player1', 'groups.pairs.player2');
    }

    public function sheets(): array
    {
        $sheets = [];
        foreach ($this->tournament->groups as $group) {
            $sheets[] = new GroupPairsSheet($group->name, $group->pairs);
        }
        return $sheets;
    }
}

class GroupPairsSheet implements FromCollection, WithHeadings, WithTitle
{
    public function __construct(private string $groupName, private Collection $pairs)
    {
    }

    public function collection()
    {
        $rows = collect();
        foreach ($this->pairs as $index => $pair) {
            $rows->push([
                'no' => $index + 1,
                'pair' => ($pair->player1->name ?? 'N/A') . ($pair->player2 ? ' & ' . ($pair->player2->name ?? 'N/A') : ''),
                'player1' => $pair->player1->name ?? 'N/A',
                'player2' => $pair->player2->name ?? '-',
            ]);
        }
        return $rows;
    }

    public function headings(): array
    {
        return ['#', 'Cặp đấu', 'VĐV 1', 'VĐV 2'];
    }

    public function title(): string
    {
        return 'Bảng ' . $this->groupName;
    }
}