<?php

namespace App\Console\Commands;

use App\Http\Requests\PlayerRequest;
use App\Http\Requests\RegisterMemberRequest;
use Illuminate\Console\Command;

class DebugValidation extends Command
{
    protected $signature = 'debug:validation';

    protected $description = 'Debug validation rules for avatar uploads';

    public function handle()
    {
        $this->info('🔍 Debugging Validation Rules...');

        // Test PlayerRequest
        $this->info("\n📝 PlayerRequest Rules:");
        try {
            $playerRequest = new PlayerRequest;
            $rules = $playerRequest->rules();
            $this->line('Avatar rule: '.($rules['avatar'] ?? 'Not found'));
        } catch (\Exception $e) {
            $this->error('Error getting PlayerRequest rules: '.$e->getMessage());
        }

        // Test RegisterMemberRequest
        $this->info("\n📝 RegisterMemberRequest Rules:");
        try {
            $memberRequest = new RegisterMemberRequest;
            $rules = $memberRequest->rules();
            $this->line('Avatar rule: '.print_r($rules['avatar'] ?? 'Not found', true));

            $messages = $memberRequest->messages();
            $this->info("\nValidation Messages:");
            foreach ($messages as $key => $message) {
                if (str_contains($key, 'avatar')) {
                    $this->line("  {$key}: {$message}");
                }
            }
        } catch (\Exception $e) {
            $this->error('Error getting RegisterMemberRequest rules: '.$e->getMessage());
        }

        // Test file upload simulation
        $this->info("\n🧪 Testing File Types:");
        $mimeTypes = [
            'image/jpeg' => 'JPEG',
            'image/jpg' => 'JPG',
            'image/png' => 'PNG',
            'image/gif' => 'GIF',
            'image/webp' => 'WebP',
        ];

        foreach ($mimeTypes as $mime => $name) {
            // Simulate validation
            $validator = \Validator::make(
                ['avatar' => ['mime_type' => $mime]],
                ['avatar' => 'nullable|file|image|mimes:jpeg,jpg,png,gif,webp|max:2048']
            );

            $status = $validator->passes() ? '✅' : '❌';
            $this->line("  {$status} {$name} ({$mime})");
        }

        $this->info("\n🎉 Validation debug completed!");

        return 0;
    }
}
