<?php
namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\Player;
use Carbon\Carbon;

class ApprovePendingAvatars extends Command
{
    protected $signature = 'avatars:approve-pending';
    protected $description = 'Approve all pending avatars older than 24 hours';

    public function handle()
    {
        $now = Carbon::now();
        $players = Player::whereNotNull('avatar_pending')
            ->whereNotNull('avatar_pending_requested_at')
            ->where('avatar_pending_requested_at', '<=', $now->subHours(24))
            ->get();
        $count = 0;
        foreach ($players as $player) {
            // Delete old avatar if exists
            if ($player->avatar && file_exists(public_path($player->avatar))) {
                @unlink(public_path($player->avatar));
            }
            // Approve pending avatar
            $player->avatar = $player->avatar_pending;
            $player->avatar_pending = null;
            $player->avatar_pending_requested_at = null;
            $player->save();
            $count++;
        }
        $this->info("Approved $count pending avatars.");
    }
}
